/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.javaee.cdi.ui.quickfix;

import com.ibm.etools.javaee.cdi.ui.quickfix.proposals.RemoveMultiScopeProposal;
import com.ibm.etools.javaee.cdi.ui.quickfix.proposals.ReplaceWithStatefulAnnotationProposal;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.ui.text.java.IInvocationContext;
import org.eclipse.jdt.ui.text.java.IJavaCompletionProposal;
import org.eclipse.jdt.ui.text.java.IProblemLocation;
import org.eclipse.jdt.ui.text.java.IQuickFixProcessor;

public class ScopeQuickFixProcessor
implements IQuickFixProcessor {
    public IJavaCompletionProposal[] getCorrections(IInvocationContext context, IProblemLocation[] locations) throws CoreException {
        for (IProblemLocation problemLocation : locations) {
            String[] arguments = problemLocation.getProblemArguments();
            if (arguments == null || arguments.length < 2) continue;
            String pluginId = arguments[0];
            String errorId = arguments[1];
            if (!pluginId.equals("com.ibm.etools.javaee.cdi.ext.ui")) continue;
            if (errorId.equals("MULTI_SCOPE_ERR")) {
                ASTNode selectedNode = problemLocation.getCoveringNode(context.getASTRoot());
                return new IJavaCompletionProposal[]{new RemoveMultiScopeProposal(context, selectedNode, 100)};
            }
            if (!errorId.equals("SB_STATEFUL_ERR")) continue;
            ASTNode selectedNode = problemLocation.getCoveringNode(context.getASTRoot());
            return new IJavaCompletionProposal[]{new ReplaceWithStatefulAnnotationProposal(context, selectedNode, 100)};
        }
        return null;
    }

    public boolean hasCorrections(ICompilationUnit cu, int problemId) {
        return problemId == 900;
    }
}

