/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.javaee.cdi.ui.quickfix;

import com.ibm.etools.javaee.cdi.ui.quickfix.resolutions.AbstractAPResolution;
import com.ibm.etools.javaee.cdi.ui.quickfix.resolutions.AddSerializableResolution;
import com.ibm.etools.javaee.cdi.ui.quickfix.resolutions.RemoveScopeResolution;
import com.ibm.etools.javaee.cdi.ui.quickfix.resolutions.ReplaceWithStatefulResolution;
import com.ibm.etools.javaee.internal.cdi.ui.CDIUIExtPlugin;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.CorrectionEngine;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.ui.IMarkerResolution;
import org.eclipse.ui.IMarkerResolution2;
import org.eclipse.ui.IMarkerResolutionGenerator2;

public class CDIAPQuickFixGenerator
implements IMarkerResolutionGenerator2 {
    public IMarkerResolution[] getResolutions(IMarker marker) {
        String problemId = null;
        String[] arguments = CorrectionEngine.getProblemArguments((IMarker)marker);
        if (arguments.length == 2) {
            problemId = arguments[1];
        }
        if (problemId != null) {
            IJavaElement element;
            IResource res;
            if (problemId.equals("MB_SER_ERR")) {
                return new IMarkerResolution2[]{new AddSerializableResolution()};
            }
            if ((problemId.equals("MULTI_SCOPE_ERR") || problemId.equals("SB_STATEFUL_ERR")) && (res = marker.getResource()) instanceof IFile && res.isAccessible() && (element = JavaCore.create((IFile)((IFile)res))) instanceof ICompilationUnit) {
                ICompilationUnit icu = (ICompilationUnit)element;
                try {
                    AbstractAPResolution resolution = problemId.equals("MULTI_SCOPE_ERR") ? new RemoveScopeResolution(icu, marker) : new ReplaceWithStatefulResolution(icu, marker);
                    IMarkerResolution[] resolutions = new IMarkerResolution[]{resolution};
                    return resolutions;
                }
                catch (CoreException e) {
                    CDIUIExtPlugin.logError(e.getMessage(), e);
                }
            }
        }
        return new IMarkerResolution2[0];
    }

    public boolean hasResolutions(IMarker marker) {
        String problemId = null;
        String[] arguments = CorrectionEngine.getProblemArguments((IMarker)marker);
        return arguments.length >= 2 && arguments[0].equals("com.ibm.etools.javaee.cdi.ext.ui") && ((problemId = arguments[1]).equals("MULTI_SCOPE_ERR") || problemId.equals("MB_SER_ERR") || problemId.equals("SB_STATEFUL_ERR"));
    }
}

