/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.javaee.cdi.ui.quickfix;

import com.ibm.etools.javaee.cdi.ui.internal.quickfix.CDIUtils;
import com.ibm.etools.javaee.cdi.ui.quickfix.CDIQuickFixMessages;
import com.ibm.etools.javaee.cdi.ui.quickfix.proposals.AddCDISupportProposal;
import com.ibm.etools.javaee.internal.cdi.ui.CDIUIExtPlugin;
import java.util.ArrayList;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.ui.text.java.IInvocationContext;
import org.eclipse.jdt.ui.text.java.IJavaCompletionProposal;
import org.eclipse.jdt.ui.text.java.IProblemLocation;
import org.eclipse.jdt.ui.text.java.IQuickFixProcessor;

public class AddCDISupportQuickFixProcessor
implements IQuickFixProcessor {
    public IJavaCompletionProposal[] getCorrections(IInvocationContext context, IProblemLocation[] locations) throws CoreException {
        IJavaCompletionProposal[] result = null;
        ICompilationUnit unit = context.getCompilationUnit();
        if (!CDIUtils.isFaceted(unit.getJavaProject())) {
            ArrayList<IJavaCompletionProposal> res = null;
            for (IProblemLocation problem : locations) {
                int id = problem.getProblemId();
                if ((!CDIUtils.isJavaVersionSupported(unit.getJavaProject()) || 0x1000002 != id) && -1610612233 != id) continue;
                res = this.getAddCDISupportProposals(context, problem, res);
            }
            if (res != null && !res.isEmpty()) {
                result = res.toArray(new IJavaCompletionProposal[res.size()]);
            }
        }
        return result;
    }

    public boolean hasCorrections(ICompilationUnit cu, int problemId) {
        return problemId == 0x1000002 || problemId == -1610612233;
    }

    private ArrayList<IJavaCompletionProposal> getAddCDISupportProposals(IInvocationContext context, IProblemLocation location, ArrayList<IJavaCompletionProposal> proposals) {
        try {
            String typeName;
            ASTNode selectedNode = location.getCoveringNode(context.getASTRoot());
            if (proposals == null) {
                proposals = new ArrayList();
            }
            if (selectedNode instanceof Name && CDIUtils.isSupportedAnnotation(typeName = CDIUtils.getTypeName(selectedNode)) && CDIUtils.isCDISupportedByRuntimes()) {
                proposals.add(new AddCDISupportProposal(context, 8, selectedNode));
            }
        }
        catch (Exception e) {
            CDIUIExtPlugin.logWarning(CDIQuickFixMessages.CDI_Warning_Message, e);
        }
        return proposals;
    }
}

