/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.javaee.cdi.ui.internal.quickfix;

import com.ibm.etools.javaee.cdi.ui.internal.quickfix.CDIFacet;
import com.ibm.etools.javaee.project.facet.IJavaEEFacetConstants;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.internal.corext.dom.ASTNodes;
import org.eclipse.jem.workbench.utility.JemProjectUtilities;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jst.j2ee.project.JavaEEProjectUtilities;
import org.eclipse.jst.server.core.FacetUtil;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;
import org.eclipse.wst.server.core.IRuntime;
import org.eclipse.wst.server.core.IRuntimeType;
import org.eclipse.wst.server.core.ServerCore;

public class CDIUtils {
    private static final String LIBERTY = "Liberty";
    public static final String LIBERTY_RUNTIME_ID_PREFIX = "com.ibm.ws.st.runtime";
    public static final String WAS_RUNTIME_ID = "com.ibm.ws.ast.st.runtime";
    private static final Map<String, String> CDI_ANNOTATIONS = new HashMap<String, String>();
    private static final Map<String, String> CDI_12_ANNOTATIONS;
    private static final Map<String, String> CDI_20_ANNOTATIONS;
    private static final Map<String, String> CDI_COMPLETE_ANNOTATIONS;

    public static org.eclipse.wst.common.project.facet.core.runtime.IRuntime findRuntimeWithId(String runtimeId) {
        for (IRuntime runtime : ServerCore.getRuntimes()) {
            if (!runtime.getId().equals(runtimeId)) continue;
            return FacetUtil.getRuntime((IRuntime)runtime);
        }
        return null;
    }

    public static org.eclipse.wst.common.project.facet.core.runtime.IRuntime findRuntimeWithName(String runtimeName) {
        org.eclipse.wst.common.project.facet.core.runtime.IRuntime result = null;
        for (IRuntime runtime : ServerCore.getRuntimes()) {
            if (!runtime.getName().equals(runtimeName)) continue;
            result = FacetUtil.getRuntime((IRuntime)runtime);
            break;
        }
        return result;
    }

    public static void setRuntime(IFacetedProject facetedProject, org.eclipse.wst.common.project.facet.core.runtime.IRuntime runtime) throws CoreException {
        Set runSet = facetedProject.getTargetedRuntimes();
        if (runSet.isEmpty() || !runSet.contains(runtime)) {
            HashSet<org.eclipse.wst.common.project.facet.core.runtime.IRuntime> runtimes = new HashSet<org.eclipse.wst.common.project.facet.core.runtime.IRuntime>();
            runtimes.add(runtime);
            facetedProject.setTargetedRuntimes(runtimes, (IProgressMonitor)new NullProgressMonitor());
        }
        facetedProject.setPrimaryRuntime(runtime, (IProgressMonitor)new NullProgressMonitor());
    }

    public static boolean isJavaVersionSupported(IJavaProject javaProject) {
        IProject project = javaProject.getProject();
        IJavaProject jProj = JemProjectUtilities.getJavaProject((IProject)project);
        String jdtVersion = jProj.getOption("org.eclipse.jdt.core.compiler.compliance", true);
        return CDIFacet.v1_0.isJavaVersionSupported(jdtVersion);
    }

    public static boolean hasFacet(IFacetedProject facetProject, String identifier) throws CoreException {
        return facetProject == null ? false : facetProject.hasProjectFacet(ProjectFacetsManager.getProjectFacet((String)identifier));
    }

    public static boolean isFaceted(IJavaProject javaProject) throws CoreException {
        IFacetedProject facetProject = ProjectFacetsManager.create((IProject)javaProject.getProject());
        return facetProject != null;
    }

    public static boolean isRuntimeCDIEnabled(IRuntime runtime) {
        return CDIUtils.isWASv80OrLaterRuntime(runtime) || runtime.getId().contains(LIBERTY) && (FacetUtil.getRuntime((IRuntime)runtime).supports(CDIFacet.v1_0.getFacetVersion()) || FacetUtil.getRuntime((IRuntime)runtime).supports(CDIFacet.v1_2.getFacetVersion()) || FacetUtil.getRuntime((IRuntime)runtime).supports(CDIFacet.v2_0.getFacetVersion()));
    }

    public static boolean isCDISupportedByRuntimes() {
        boolean result = false;
        for (IRuntime runtime : ServerCore.getRuntimes()) {
            if (!CDIUtils.isRuntimeCDIEnabled(runtime)) continue;
            result = true;
            break;
        }
        return result;
    }

    public static boolean isSupportedAnnotation(String typeName) {
        return CDI_COMPLETE_ANNOTATIONS.containsKey(typeName);
    }

    public static boolean isHighestSpecLevelSupportedAnnotation(String typeName) {
        return CDI_12_ANNOTATIONS.containsKey(typeName) || CDI_20_ANNOTATIONS.containsKey(typeName);
    }

    public static String getQualifiedName(String typeName) {
        return CDIUtils.isSupportedAnnotation(typeName) ? CDI_COMPLETE_ANNOTATIONS.get(typeName) : null;
    }

    public static String getTypeName(ASTNode selectedNode) {
        return ASTNodes.getSimpleNameIdentifier((Name)((Name)selectedNode));
    }

    public static void displayMessage(final String title, final String message) {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                Shell shell = Display.getDefault().getActiveShell();
                MessageDialog.openInformation((Shell)shell, (String)title, (String)message);
            }
        });
    }

    public static boolean isJavaEE6Project(IProject project) {
        return JavaEEProjectUtilities.isDynamicWebProject((IProject)project) && JavaEEProjectUtilities.getProjectFacetVersion((IProject)project, (String)"jst.web").equals((Object)IJavaEEFacetConstants.DYNAMIC_WEB_30) || JavaEEProjectUtilities.isWebFragmentProject((IProject)project) && JavaEEProjectUtilities.getProjectFacetVersion((IProject)project, (String)"jst.webfragment").equals((Object)IJavaEEFacetConstants.WEBFRAGMENT_30) || JavaEEProjectUtilities.isEJBProject((IProject)project) && JavaEEProjectUtilities.getProjectFacetVersion((IProject)project, (String)"jst.ejb").equals((Object)IJavaEEFacetConstants.EJB_31) || JavaEEProjectUtilities.isApplicationClientProject((IProject)project) && JavaEEProjectUtilities.getProjectFacetVersion((IProject)project, (String)"jst.appclient").equals((Object)IJavaEEFacetConstants.APPLICATION_CLIENT_60) || JavaEEProjectUtilities.isJCAProject((IProject)project) && JavaEEProjectUtilities.getProjectFacetVersion((IProject)project, (String)"jst.connector").equals((Object)IJavaEEFacetConstants.JCA_16);
    }

    public static boolean isJavaEE7Project(IProject project) {
        return JavaEEProjectUtilities.isDynamicWebProject((IProject)project) && JavaEEProjectUtilities.getProjectFacetVersion((IProject)project, (String)"jst.web").equals((Object)IJavaEEFacetConstants.DYNAMIC_WEB_31) || JavaEEProjectUtilities.isWebFragmentProject((IProject)project) && JavaEEProjectUtilities.getProjectFacetVersion((IProject)project, (String)"jst.webfragment").equals((Object)IJavaEEFacetConstants.WEBFRAGMENT_31) || JavaEEProjectUtilities.isEJBProject((IProject)project) && JavaEEProjectUtilities.getProjectFacetVersion((IProject)project, (String)"jst.ejb").equals((Object)IJavaEEFacetConstants.EJB_32) || JavaEEProjectUtilities.isApplicationClientProject((IProject)project) && JavaEEProjectUtilities.getProjectFacetVersion((IProject)project, (String)"jst.appclient").equals((Object)IJavaEEFacetConstants.APPLICATION_CLIENT_70) || JavaEEProjectUtilities.isJCAProject((IProject)project) && JavaEEProjectUtilities.getProjectFacetVersion((IProject)project, (String)"jst.connector").equals((Object)IJavaEEFacetConstants.JCA_17);
    }

    public static boolean isJavaEE8Project(IProject project) {
        return JavaEEProjectUtilities.isDynamicWebProject((IProject)project) && JavaEEProjectUtilities.getProjectFacetVersion((IProject)project, (String)"jst.web").equals((Object)IJavaEEFacetConstants.DYNAMIC_WEB_40) || JavaEEProjectUtilities.isWebFragmentProject((IProject)project) && JavaEEProjectUtilities.getProjectFacetVersion((IProject)project, (String)"jst.webfragment").equals((Object)IJavaEEFacetConstants.WEBFRAGMENT_40) || JavaEEProjectUtilities.isEJBProject((IProject)project) && JavaEEProjectUtilities.getProjectFacetVersion((IProject)project, (String)"jst.ejb").equals((Object)IJavaEEFacetConstants.EJB_32) || JavaEEProjectUtilities.isApplicationClientProject((IProject)project) && JavaEEProjectUtilities.getProjectFacetVersion((IProject)project, (String)"jst.appclient").equals((Object)IJavaEEFacetConstants.APPLICATION_CLIENT_80) || JavaEEProjectUtilities.isJCAProject((IProject)project) && JavaEEProjectUtilities.getProjectFacetVersion((IProject)project, (String)"jst.connector").equals((Object)IJavaEEFacetConstants.JCA_17);
    }

    public static boolean isWASv80OrLaterRuntime(IRuntime runtime) {
        int nextDigit;
        String remainder;
        char nextChar;
        String runtimeTypeId;
        IRuntimeType runtimeType;
        boolean retVal = false;
        if (runtime != null && (runtimeType = runtime.getRuntimeType()) != null && (runtimeTypeId = runtimeType.getId()).startsWith(WAS_RUNTIME_ID) && !(retVal = runtimeTypeId.startsWith("com.ibm.ws.ast.st.runtime.v8")) && Character.isDigit(nextChar = (remainder = runtimeTypeId.substring(WAS_RUNTIME_ID.length() + 2)).charAt(0)) && ((nextDigit = Character.getNumericValue(nextChar)) >= 8 || nextDigit < 4)) {
            retVal = true;
        }
        return retVal;
    }

    public static IFile getBeansFile(IProject project, IContainer container) {
        boolean isWeb = JavaEEProjectUtilities.isDynamicWebProject((IProject)project);
        String path = isWeb ? "WEB-INF/beans.xml" : "META-INF/beans.xml";
        return container.getFile((IPath)new Path(path));
    }

    static {
        CDI_ANNOTATIONS.put("Inject", "javax.inject.Inject");
        CDI_ANNOTATIONS.put("Named", "javax.inject.Named");
        CDI_ANNOTATIONS.put("Qualifier", "javax.inject.Qualifier");
        CDI_ANNOTATIONS.put("Scope", "javax.inject.Scope");
        CDI_ANNOTATIONS.put("Alternative", "javax.enterprise.inject.Alternative");
        CDI_ANNOTATIONS.put("Any", "javax.enterprise.inject.Any");
        CDI_ANNOTATIONS.put("Default", "javax.enterprise.inject.Default");
        CDI_ANNOTATIONS.put("Disposes", "javax.enterprise.inject.Disposes");
        CDI_ANNOTATIONS.put("Model", "javax.enterprise.inject.Model");
        CDI_ANNOTATIONS.put("New", "javax.enterprise.inject.New");
        CDI_ANNOTATIONS.put("Produces", "javax.enterprise.inject.Produces");
        CDI_ANNOTATIONS.put("Specializes", "javax.enterprise.inject.Specializes");
        CDI_ANNOTATIONS.put("Stereotype", "javax.enterprise.inject.Stereotype");
        CDI_ANNOTATIONS.put("Typed", "javax.enterprise.inject.Typed");
        CDI_ANNOTATIONS.put("ApplicationScoped", "javax.enterprise.context.ApplicationScoped");
        CDI_ANNOTATIONS.put("ConversationScoped", "javax.enterprise.context.ConversationScoped");
        CDI_ANNOTATIONS.put("Dependent", "javax.enterprise.context.Dependent");
        CDI_ANNOTATIONS.put("NormalScoped", "javax.enterprise.context.NormalScoped");
        CDI_ANNOTATIONS.put("RequestScoped", "javax.enterprise.context.RequestScoped");
        CDI_ANNOTATIONS.put("SessionScoped", "javax.enterprise.context.SessionScoped");
        CDI_ANNOTATIONS.put("Decorator", "javax.decorator.Decorator");
        CDI_ANNOTATIONS.put("Delegate", "javax.decorator.Delegate");
        CDI_12_ANNOTATIONS = new HashMap<String, String>();
        CDI_12_ANNOTATIONS.put("TransientReference", "javax.enterprise.inject.TransientReference");
        CDI_12_ANNOTATIONS.put("Vetoed", "javax.enterprise.inject.Vetoed");
        CDI_12_ANNOTATIONS.put("Destroyed", "javax.enterprise.context.Destroyed");
        CDI_12_ANNOTATIONS.put("Initialized", "javax.enterprise.context.Initialized");
        CDI_12_ANNOTATIONS.put("WithAnnotations", "javax.enterprise.inject.spi.WithAnnotations");
        CDI_20_ANNOTATIONS = new HashMap<String, String>();
        CDI_20_ANNOTATIONS.put("ObservesAsync", "javax.enterprise.event.ObservesAsync");
        CDI_COMPLETE_ANNOTATIONS = new HashMap<String, String>();
        CDI_COMPLETE_ANNOTATIONS.putAll(CDI_ANNOTATIONS);
        CDI_COMPLETE_ANNOTATIONS.putAll(CDI_12_ANNOTATIONS);
        CDI_COMPLETE_ANNOTATIONS.putAll(CDI_20_ANNOTATIONS);
    }
}

