/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.javaee.cdi.ui.internal.quickfix;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.wst.common.project.facet.core.IProjectFacet;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;

public enum CDIFacet {
    v1_0("1.0", "1.6", "1.7", "1.8"),
    v1_2("1.2", "1.7", "1.8"),
    v2_0("2.0", "1.8");

    public static final String CDI_FACET_ID = "com.ibm.etools.javaee.cdi";
    private final String version;
    private final List<String> supportedJavaVersion;
    private final IProjectFacetVersion facetVersion;

    private CDIFacet(String version, String ... javaVersionArray) {
        this.version = version;
        this.supportedJavaVersion = Arrays.asList(javaVersionArray);
        Collections.sort(this.supportedJavaVersion);
        this.facetVersion = ProjectFacetsManager.getProjectFacet((String)CDI_FACET_ID).getVersion(version);
    }

    public String getVersion() {
        return this.version;
    }

    public String toString() {
        return this.getFacet().toString() + " " + this.getFacetVersion().toString();
    }

    public static CDIFacet getByVersionString(String strVersion) {
        CDIFacet version = v1_0;
        for (CDIFacet c : CDIFacet.values()) {
            if (!c.getVersion().equalsIgnoreCase(strVersion)) continue;
            version = c;
            break;
        }
        return version;
    }

    public IProjectFacetVersion getFacetVersion() {
        return this.facetVersion;
    }

    public IProjectFacet getFacet() {
        return this.facetVersion.getProjectFacet();
    }

    public boolean isJavaVersionSupported(String jdtVersion) {
        return Collections.binarySearch(this.supportedJavaVersion, jdtVersion) >= 0;
    }

    private final void readObject(ObjectInputStream in) throws IOException {
        throw new IOException("Cannot be deserialized");
    }
}

