/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.javaee.cdi.ui.internal.actions;

import com.ibm.etools.javaee.internal.cdi.ui.CDIUIExtPlugin;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.jem.util.emf.workbench.ProjectUtilities;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.componentcore.resources.IVirtualFolder;

public final class ResourceUtils {
    public static IProject getProjectFromSelection(ISelection selection) {
        Object firstElement;
        IStructuredSelection structuredSelection = (IStructuredSelection)selection;
        IProject project = ProjectUtilities.getProject((Object)structuredSelection.getFirstElement());
        if (project == null && (firstElement = structuredSelection.getFirstElement()) instanceof IResource) {
            project = ((IResource)firstElement).getProject();
        }
        return project;
    }

    public static void openResource(final IFile resource) {
        Display display;
        final IWorkbenchPage activePage = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        if (activePage != null && (display = PlatformUI.getWorkbench().getDisplay()) != null) {
            display.asyncExec(new Runnable(){

                @Override
                public void run() {
                    try {
                        IDE.openEditor((IWorkbenchPage)activePage, (IFile)resource, (boolean)true);
                    }
                    catch (PartInitException e) {
                        CDIUIExtPlugin.logError(e.getMessage());
                    }
                }
            });
        }
    }

    public static IContainer getContainer(IProject project) {
        Object container = null;
        IVirtualComponent virtualComponent = ComponentCore.createComponent((IProject)project, (boolean)false);
        if (virtualComponent != null) {
            IVirtualFolder root = virtualComponent.getRootFolder();
            container = root.getProjectRelativePath().segmentCount() == 0 ? project : project.getFolder(root.getProjectRelativePath());
        }
        return container;
    }
}

