/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.javaee.cdi.ui.internal.actions;

import com.ibm.etools.javaee.cdi.ui.internal.actions.ResourceUtils;
import com.ibm.etools.javaee.cdi.ui.internal.quickfix.CDIUtils;
import com.ibm.etools.javaee.internal.cdi.ui.CDIUIExtPlugin;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jst.j2ee.project.JavaEEProjectUtilities;
import org.eclipse.ui.IActionDelegate;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;

public class GenerateBeansDeploymentDescriptorAction
implements IActionDelegate {
    private IProject project;

    public void run(IAction action) {
        if (this.project != null) {
            IContainer container = ResourceUtils.getContainer(this.project);
            IFile configFile = this.createBeansFile(this.project, container, null);
            ResourceUtils.openResource(configFile);
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
        this.project = ResourceUtils.getProjectFromSelection(selection);
        if (this.project != null) {
            action.setEnabled(!this.doesBeansDDExist(this.project));
        }
    }

    private boolean doesBeansDDExist(IProject proj) {
        boolean isWeb;
        String path;
        IFile beansDDFile;
        IContainer container = ResourceUtils.getContainer(proj);
        return container != null && (beansDDFile = container.getFile((IPath)new Path(path = (isWeb = JavaEEProjectUtilities.isDynamicWebProject((IProject)this.project)) ? "WEB-INF/beans.xml" : "META-INF/beans.xml"))).exists();
    }

    private IFile createBeansFile(IProject project, IContainer container, IProgressMonitor monitor) {
        IFile file = CDIUtils.getBeansFile(project, container);
        if (file.exists()) {
            return file;
        }
        IProjectFacetVersion cdiPfv = JavaEEProjectUtilities.getProjectFacetVersion((IProject)project, (String)"com.ibm.etools.javaee.cdi");
        try {
            if (cdiPfv.getVersionString().equals("1.0")) {
                file.create((InputStream)new ByteArrayInputStream("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<beans xmlns=\"http://java.sun.com/xml/ns/javaee\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:schemaLocation=\"http://java.sun.com/xml/ns/javaee http://java.sun.com/xml/ns/javaee/beans_1_0.xsd\">\n</beans>".getBytes("UTF-8")), true, monitor);
            } else if (cdiPfv.getVersionString().equals("1.2")) {
                file.create((InputStream)new ByteArrayInputStream("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<beans bean-discovery-mode=\"annotated\" xmlns=\"http://xmlns.jcp.org/xml/ns/javaee\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:schemaLocation=\"http://xmlns.jcp.org/xml/ns/javaee http://xmlns.jcp.org/xml/ns/javaee/beans_1_1.xsd\">\n</beans>".getBytes("UTF-8")), true, monitor);
            } else if (cdiPfv.getVersionString().equals("2.0")) {
                file.create((InputStream)new ByteArrayInputStream("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<beans bean-discovery-mode=\"annotated\" xmlns=\"http://xmlns.jcp.org/xml/ns/javaee\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:schemaLocation=\"http://xmlns.jcp.org/xml/ns/javaee http://xmlns.jcp.org/xml/ns/javaee/beans_2_0.xsd\">\n</beans>".getBytes("UTF-8")), true, monitor);
            }
        }
        catch (UnsupportedEncodingException e) {
            CDIUIExtPlugin.logError(e.getMessage());
        }
        catch (CoreException e) {
            CDIUIExtPlugin.logError(e.getMessage());
        }
        return file;
    }
}

