/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.javaee.cdi.ui.dialogs;

import com.ibm.etools.javaee.internal.cdi.ui.CDIUIExtPlugin;
import com.ibm.xwt.dde.customization.IAdvancedCustomizationObject;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.core.IClassFile;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.core.search.SearchMatch;
import org.eclipse.jdt.core.search.SearchParticipant;
import org.eclipse.jdt.core.search.SearchPattern;
import org.eclipse.jdt.core.search.SearchRequestor;
import org.eclipse.jdt.internal.ui.javaeditor.InternalClassFileEditorInput;
import org.eclipse.jdt.internal.ui.wizards.NewClassCreationWizard;
import org.eclipse.jdt.ui.wizards.NewClassWizardPage;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.layout.PixelConverter;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.FileEditorInput;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class NewJavaClassActionHandler
implements IAdvancedCustomizationObject {
    private static boolean _firstTime = true;

    public String invoke(String value, Node itemNode, Element closestAncestor, IEditorPart editorPart) {
        if ((value = value.trim()).length() == 0) {
            return this.createNew(value, itemNode, closestAncestor, editorPart);
        }
        try {
            TypeFinder finder = new TypeFinder(value);
            if (_firstTime) {
                ProgressMonitorDialog dialog = new ProgressMonitorDialog(this.getShell());
                dialog.run(true, false, (IRunnableWithProgress)finder);
                _firstTime = false;
            } else {
                finder.run((IProgressMonitor)new NullProgressMonitor());
            }
            if (finder.getType() != null) {
                this.openExisting(finder.getType());
                return value;
            }
            return this.createNew(value, itemNode, closestAncestor, editorPart);
        }
        catch (InterruptedException e) {
            return value;
        }
        catch (InvocationTargetException e) {
            Throwable t = e.getTargetException();
            String msg = "An error occured: " + String.valueOf(t);
            CDIUIExtPlugin.logError(t.getLocalizedMessage());
            MessageDialog.openError((Shell)this.getShell(), (String)"Error", (String)msg);
            return value;
        }
    }

    private String createNew(String value, Node itemNode, Element closestAncestor, IEditorPart editorPart) {
        NewClassWizardPage page = this.createNewClassWizardPage(editorPart, value);
        if (value.length() > 0) {
            int pos = value.lastIndexOf(46);
            if (pos >= 0) {
                page.setTypeName(value.substring(pos + 1), true);
            } else {
                page.setTypeName(value, true);
            }
        }
        Shell shell = this.getShell();
        NewClassCreationWizard wizard = new NewClassCreationWizard(page, true);
        wizard.init(PlatformUI.getWorkbench(), null);
        WizardDialog dialog = new WizardDialog(shell, (IWizard)wizard);
        PixelConverter converter = new PixelConverter(JFaceResources.getDialogFont());
        dialog.setMinimumPageSize(converter.convertWidthInCharsToPixels(70), converter.convertHeightInCharsToPixels(20));
        dialog.create();
        if (dialog.open() == 0) {
            IType type = (IType)wizard.getCreatedElement();
            return type.getFullyQualifiedName();
        }
        return value;
    }

    private NewClassWizardPage createNewClassWizardPage(IEditorPart editorPart, String value) {
        NewClassWizardPage page = new NewClassWizardPage();
        try {
            int pos;
            IFile file = (IFile)editorPart.getEditorInput().getAdapter(IFile.class);
            if (file != null) {
                IPackageFragmentRoot[] roots;
                IJavaProject project = JavaCore.create((IProject)file.getProject());
                for (IPackageFragmentRoot root : roots = project.getPackageFragmentRoots()) {
                    if (root.getKind() != 1 || root.getUnderlyingResource().getName().equals(".apt_generated")) continue;
                    page.setPackageFragmentRoot(root, true);
                    break;
                }
            }
            if (page.getPackageFragmentRoot() != null && (pos = value.lastIndexOf(46)) > 0) {
                IPackageFragment pkg = page.getPackageFragmentRoot().getPackageFragment(value.substring(0, pos));
                page.setPackageFragment(pkg, true);
            }
        }
        catch (CoreException e) {
            CDIUIExtPlugin.logError(e.getLocalizedMessage());
        }
        return page;
    }

    protected Shell getShell() {
        return PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
    }

    private void openExisting(IType type) {
        try {
            IEditorDescriptor descriptor;
            IWorkbenchPage workbenchPage = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
            if (type.getCompilationUnit() != null) {
                IEditorDescriptor descriptor2 = PlatformUI.getWorkbench().getEditorRegistry().getDefaultEditor("foo.java");
                if (descriptor2 != null) {
                    String id = descriptor2.getId();
                    workbenchPage.openEditor((IEditorInput)new FileEditorInput((IFile)type.getResource()), id);
                }
            } else if (type.getClassFile() != null && (descriptor = PlatformUI.getWorkbench().getEditorRegistry().getDefaultEditor("foo.class")) != null) {
                String id = descriptor.getId();
                workbenchPage.openEditor((IEditorInput)new InternalClassFileEditorInput((IClassFile)type.getClassFile()), id);
            }
        }
        catch (CoreException e) {
            CDIUIExtPlugin.logError(e.getLocalizedMessage());
        }
    }

    private static class TypeFinder
    implements IRunnableWithProgress {
        private final String _value;
        private IType _type;

        public TypeFinder(String value) {
            this._value = value;
        }

        public IType getType() {
            return this._type;
        }

        public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
            try {
                SearchPattern pattern = SearchPattern.createPattern((String)this._value, (int)5, (int)0, (int)0);
                IJavaSearchScope scope = SearchEngine.createWorkspaceScope();
                final ArrayList found = new ArrayList();
                SearchRequestor requestor = new SearchRequestor(){

                    public void acceptSearchMatch(SearchMatch match) throws CoreException {
                        found.add((IType)match.getElement());
                    }
                };
                SearchEngine engine = new SearchEngine();
                engine.search(pattern, new SearchParticipant[]{SearchEngine.getDefaultSearchParticipant()}, scope, requestor, monitor);
                if (!found.isEmpty()) {
                    this._type = (IType)found.get(0);
                }
            }
            catch (Exception e) {
                throw new InvocationTargetException(e);
            }
        }
    }
}

