/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.javaee.cdi.ui.dialogs;

import com.ibm.etools.javaee.cdi.ui.internal.quickfix.CDIFacet;
import com.ibm.etools.javaee.cdi.ui.quickfix.CDIQuickFixMessages;
import com.ibm.etools.javaee.internal.cdi.annotations.processor.utils.JcdiAPUtils;
import com.ibm.etools.javaee.project.facet.IJavaEEFacetConstants;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jst.server.core.FacetUtil;
import org.eclipse.jst.ws.internal.ui.common.UIUtils;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.SelectionDialog;
import org.eclipse.wst.common.project.facet.core.runtime.IRuntime;

public class CDIUtilityProjectVersionSelectionDialog
extends SelectionDialog {
    protected String title;
    protected String message;
    protected org.eclipse.wst.server.core.IRuntime wasRuntime;
    protected CDIFacet cdiVersion;
    protected Combo targetedRuntimes;
    protected Combo cdiVersions;
    protected IProject utilProj;

    public CDIUtilityProjectVersionSelectionDialog(Shell parent, String title, String message, IProject proj) {
        super(parent);
        this.title = title;
        this.message = message;
        this.utilProj = proj;
        this.setShellStyle(0x10870 | CDIUtilityProjectVersionSelectionDialog.getDefaultOrientation());
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(this.title);
    }

    protected Control createDialogArea(Composite composite) {
        this.setTitle(this.title);
        this.setMessage(this.message);
        Composite parent = (Composite)super.createDialogArea(composite);
        UIUtils uiUtils = new UIUtils("com.ibm.etools.javaee.cdi.ext.ui");
        GridData gd = new GridData(1808);
        gd.widthHint = 630;
        parent.setLayoutData((Object)gd);
        GridLayout gl = new GridLayout();
        gl.marginHeight = 10;
        gl.marginWidth = 10;
        parent.setLayout((Layout)gl);
        Composite runtimeComp = uiUtils.createComposite(parent, 2);
        this.cdiVersions = uiUtils.createCombo(runtimeComp, CDIQuickFixMessages.CDI_Version_Label, CDIQuickFixMessages.CDI_Version_ToolTip, null, 2056);
        this.cdiVersions.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
            }
        });
        this.updateCDIVersions();
        return parent;
    }

    protected void updateCDIVersions() {
        this.cdiVersions.removeAll();
        try {
            IRuntime facetRuntime = FacetUtil.getRuntime((org.eclipse.wst.server.core.IRuntime)JcdiAPUtils.getServerRuntime(this.utilProj));
            if (facetRuntime.supports(IJavaEEFacetConstants.CDI_1)) {
                this.cdiVersions.add("1.0");
            }
            if (facetRuntime.supports(IJavaEEFacetConstants.CDI_12)) {
                this.cdiVersions.add("1.2");
            }
            if (facetRuntime.supports(IJavaEEFacetConstants.CDI_20)) {
                this.cdiVersions.add("2.0");
            }
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        this.cdiVersions.select(0);
    }

    protected void okPressed() {
        this.cdiVersion = CDIFacet.getByVersionString(this.cdiVersions.getText());
        super.okPressed();
    }

    public CDIFacet getCdiVersion() {
        return this.cdiVersion;
    }
}

