/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.javaee.cdi.ui.dialogs;

import com.ibm.etools.javaee.cdi.ui.internal.quickfix.CDIFacet;
import com.ibm.etools.javaee.cdi.ui.internal.quickfix.CDIUtils;
import com.ibm.etools.javaee.cdi.ui.quickfix.CDIQuickFixMessages;
import com.ibm.etools.javaee.project.facet.IJavaEEFacetConstants;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.internal.corext.dom.ASTNodes;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jst.server.core.FacetUtil;
import org.eclipse.jst.ws.internal.ui.common.UIUtils;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.wst.server.core.IRuntime;
import org.eclipse.wst.server.core.ServerCore;

public class CDIRuntimeSelectionDialog
extends TitleAreaDialog {
    protected String title;
    protected String message;
    protected IRuntime wasRuntime;
    protected CDIFacet cdiVersion;
    protected Combo targetedRuntimes;
    protected Combo cdiVersions;
    protected boolean isCDI12SelectionOrGreater = false;
    protected Map<String, IRuntime> selectIRuntimes = new HashMap<String, IRuntime>();

    public CDIRuntimeSelectionDialog(Shell parent, String title, String message) {
        super(parent);
        this.title = title;
        this.message = message;
        this.setShellStyle(0x10870 | CDIRuntimeSelectionDialog.getDefaultOrientation());
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(this.title);
    }

    protected Control createDialogArea(Composite composite) {
        this.setTitle(this.title);
        this.setMessage(this.message);
        Composite parent = (Composite)super.createDialogArea(composite);
        UIUtils uiUtils = new UIUtils("com.ibm.etools.javaee.cdi.ext.ui");
        GridData gd = new GridData(1808);
        gd.widthHint = 500;
        parent.setLayoutData((Object)gd);
        GridLayout gl = new GridLayout();
        gl.marginHeight = 10;
        gl.marginWidth = 10;
        parent.setLayout((Layout)gl);
        Composite runtimeComp = uiUtils.createComposite(parent, 2);
        this.targetedRuntimes = uiUtils.createCombo(runtimeComp, CDIQuickFixMessages.CDI_Runtime_Label, CDIQuickFixMessages.CDI_Runtime_ToolTip, null, 2056);
        this.targetedRuntimes.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CDIRuntimeSelectionDialog.this.updateCDIVersions();
            }
        });
        for (IRuntime runtime : ServerCore.getRuntimes()) {
            org.eclipse.wst.common.project.facet.core.runtime.IRuntime facetRuntime;
            if (runtime.getRuntimeType() == null || !this.isCDISupported(facetRuntime = FacetUtil.getRuntime((IRuntime)runtime))) continue;
            this.targetedRuntimes.add(runtime.getName());
            this.selectIRuntimes.put(runtime.getName(), runtime);
        }
        this.targetedRuntimes.select(this.targetedRuntimes.getItemCount() - 1);
        this.cdiVersions = uiUtils.createCombo(runtimeComp, CDIQuickFixMessages.CDI_Version_Label, CDIQuickFixMessages.CDI_Version_ToolTip, null, 2056);
        this.cdiVersions.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
            }
        });
        this.updateCDIVersions();
        return parent;
    }

    protected void updateCDIVersions() {
        this.cdiVersions.removeAll();
        String runtimeText = this.targetedRuntimes.getText();
        IRuntime runtime = this.selectIRuntimes.get(runtimeText);
        if (CDIUtils.isWASv80OrLaterRuntime(runtime) || runtime.getRuntimeType().getId().startsWith("com.ibm.ws.st.runtime") && this.selectIRuntimes.containsKey(runtimeText)) {
            org.eclipse.wst.common.project.facet.core.runtime.IRuntime facetRuntime = FacetUtil.getRuntime((IRuntime)runtime);
            if (facetRuntime.supports(IJavaEEFacetConstants.CDI_20)) {
                this.cdiVersions.add("2.0");
            }
            if (facetRuntime.supports(IJavaEEFacetConstants.CDI_12)) {
                this.cdiVersions.add("1.2");
            }
            if (!this.isCDI12SelectionOrGreater) {
                this.cdiVersions.add("1.0");
            }
            this.cdiVersions.select(0);
        }
    }

    protected void okPressed() {
        this.wasRuntime = this.selectIRuntimes.get(this.targetedRuntimes.getText());
        this.cdiVersion = CDIFacet.getByVersionString(this.cdiVersions.getText());
        super.okPressed();
    }

    public IRuntime getWasRuntime() {
        return this.wasRuntime;
    }

    public CDIFacet getCdiVersion() {
        return this.cdiVersion;
    }

    public void setSelectedNode(ASTNode selectedNode) {
        if (selectedNode != null) {
            String typeName = ASTNodes.getSimpleNameIdentifier((Name)((Name)selectedNode));
            this.isCDI12SelectionOrGreater = CDIUtils.isHighestSpecLevelSupportedAnnotation(typeName);
        }
    }

    private boolean isCDISupported(org.eclipse.wst.common.project.facet.core.runtime.IRuntime facetRuntime) {
        if (this.isCDI12SelectionOrGreater) {
            return facetRuntime.supports(IJavaEEFacetConstants.CDI_12) || facetRuntime.supports(IJavaEEFacetConstants.CDI_20);
        }
        return facetRuntime.supports(IJavaEEFacetConstants.CDI_1);
    }
}

