/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.aries.internal.websphere.ui.extensions;

import com.ibm.etools.aries.internal.websphere.core.extensions.ExtensionRecord;
import com.ibm.etools.aries.internal.websphere.core.extensions.QueryBLAJob;
import com.ibm.etools.aries.internal.websphere.core.extensions.QueryCUJob;
import com.ibm.etools.aries.internal.websphere.core.extensions.QueryServerJob;
import com.ibm.etools.aries.internal.websphere.ui.Activator;
import com.ibm.etools.aries.internal.websphere.ui.Messages;
import com.ibm.etools.aries.internal.websphere.ui.extensions.BaseSelectionDialog;
import com.ibm.etools.aries.internal.websphere.ui.extensions.QueryServerJobListener;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;

public class EBASelectionDialog
extends BaseSelectionDialog {
    private String cbaID_;
    private String cbaVersion_;
    private String cbaModuleID_;
    private Combo blaInput_;
    private Combo cuInput_;
    private Map<String, List<String>> cache_ = new Hashtable<String, List<String>>();
    private String bla_ = "";
    private String cu_ = "";

    public EBASelectionDialog(Shell shell, Object input, ILabelProvider labelProvider, String message, String cbaID, String cbaVersion, String cbaModuleID) {
        super(shell, input, labelProvider, message);
        this.setTitleImage(Activator.getDefault().getImage("icons/wizban/manage_comp_ext_banner.png"));
        this.cbaID_ = cbaID;
        this.cbaVersion_ = cbaVersion;
        this.cbaModuleID_ = cbaModuleID;
    }

    @Override
    protected String getInfoPopID() {
        return "com.ibm.etools.aries.websphere.v8.ui.MANAGE_COMP_EXTENSIONS";
    }

    @Override
    protected String getAdvancedSectionText() {
        return Messages.MSG_EXTRA_EBAS;
    }

    @Override
    protected void createAdvancedControls(Composite parent) {
        this.blaInput_ = this.createDropdown(parent, Messages.MSG_BLA);
        this.blaInput_.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                final String bla = EBASelectionDialog.this.blaInput_.getText();
                List cus = (List)EBASelectionDialog.this.cache_.get(bla);
                if (cus != null) {
                    EBASelectionDialog.this.cuInput_.removeAll();
                    for (String cu : cus) {
                        EBASelectionDialog.this.cuInput_.add(cu);
                    }
                } else {
                    QueryCUJob job = new QueryCUJob(EBASelectionDialog.this.server_, bla);
                    job.addJobChangeListener((IJobChangeListener)new QueryServerJobListener((QueryServerJob)job, EBASelectionDialog.this.cuInput_){

                        @Override
                        protected List<String> getResults() {
                            List<String> cus = super.getResults();
                            EBASelectionDialog.this.cache_.put(bla, cus);
                            return cus;
                        }
                    });
                    job.schedule();
                }
            }
        });
        this.cuInput_ = this.createDropdown(parent, Messages.MSG_CU);
    }

    @Override
    protected void getInfoFromServer() {
        QueryBLAJob job = new QueryBLAJob(this.server_);
        job.addJobChangeListener((IJobChangeListener)new QueryServerJobListener((QueryServerJob)job, this.blaInput_));
        job.schedule();
    }

    @Override
    protected void okPressed() {
        if (this.blaInput_.isEnabled() && this.cuInput_.isEnabled()) {
            this.bla_ = this.blaInput_.getText();
            this.cu_ = this.cuInput_.getText();
        }
        super.okPressed();
    }

    @Override
    public ExtensionRecord getExtraExtension() {
        this.bla_ = this.bla_.trim();
        this.cu_ = this.cu_.trim();
        if (this.bla_.length() == 0 || this.cu_.length() == 0) {
            return null;
        }
        ExtensionRecord record = new ExtensionRecord(new ExtensionRecord.EBARecord(new String[]{this.bla_, this.cu_}), this.cbaID_, this.cbaVersion_, this.cbaModuleID_);
        record.setExtend(true);
        return record;
    }
}

