/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.aries.internal.websphere.ui.extensions;

import com.ibm.etools.aries.internal.websphere.core.extensions.ExtensionRecord;
import com.ibm.etools.aries.internal.websphere.core.extensions.QueryIBRJob;
import com.ibm.etools.aries.internal.websphere.core.extensions.QueryServerJob;
import com.ibm.etools.aries.internal.websphere.ui.Activator;
import com.ibm.etools.aries.internal.websphere.ui.Messages;
import com.ibm.etools.aries.internal.websphere.ui.extensions.BaseSelectionDialog;
import com.ibm.etools.aries.internal.websphere.ui.extensions.QueryServerJobListener;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class CBASelectionDialog
extends BaseSelectionDialog {
    private String[] ebaIDs_;
    private Combo idInput_;
    private Text versionInput_;
    private String cbaID_ = "";
    private String cbaVersion_ = "";

    public CBASelectionDialog(Shell shell, Object input, ILabelProvider labelProvider, String message, String[] ebaIDs) {
        super(shell, input, labelProvider, message);
        this.setTitleImage(Activator.getDefault().getImage("icons/wizban/manage_app_ext_banner.png"));
        this.ebaIDs_ = ebaIDs;
    }

    @Override
    protected String getInfoPopID() {
        return "com.ibm.etools.aries.websphere.v8.ui.MANAGE_APP_EXTENSIONS";
    }

    @Override
    protected String getAdvancedSectionText() {
        return Messages.MSG_EXTRA_CBAS;
    }

    @Override
    protected void createAdvancedControls(Composite parent) {
        this.idInput_ = this.createDropdown(parent, Messages.MSG_CBA_ID);
        Label lbl = new Label(parent, 0);
        lbl.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        lbl.setText(Messages.MSG_CBA_VERSION);
        this.versionInput_ = new Text(parent, 2048);
        this.versionInput_.setLayoutData((Object)new GridData(4, 4, true, false));
    }

    @Override
    protected void getInfoFromServer() {
        QueryIBRJob job = new QueryIBRJob(this.server_);
        job.addJobChangeListener((IJobChangeListener)new QueryServerJobListener((QueryServerJob)job, this.idInput_));
        job.schedule();
        this.versionInput_.setEnabled(false);
    }

    @Override
    protected void okPressed() {
        if (this.idInput_.isEnabled()) {
            if (this.versionInput_.isEnabled()) {
                this.cbaID_ = this.idInput_.getText();
                this.cbaVersion_ = this.versionInput_.getText();
            } else {
                String value = this.idInput_.getText();
                int index = value.indexOf(" (");
                if (index != -1) {
                    this.cbaID_ = value.substring(0, index);
                    this.cbaVersion_ = value.substring(index + 2, value.length() - 1);
                }
            }
        }
        super.okPressed();
    }

    @Override
    public ExtensionRecord getExtraExtension() {
        this.cbaID_ = this.cbaID_.trim();
        this.cbaVersion_ = this.cbaVersion_.trim();
        if (this.cbaID_.length() == 0 || this.cbaVersion_.length() == 0) {
            return null;
        }
        String cbaModuleID = "[[cbamodule]]" + this.cbaID_ + "_" + this.cbaVersion_;
        ExtensionRecord record = new ExtensionRecord(new ExtensionRecord.EBARecord(this.ebaIDs_), this.cbaID_, this.cbaVersion_, cbaModuleID);
        record.setExtend(true);
        return record;
    }
}

