/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.aries.internal.websphere.ui.extensions;

import com.ibm.etools.aries.internal.websphere.core.extensions.ExtensionRecord;
import com.ibm.etools.aries.internal.websphere.core.extensions.QueryServerJob;
import com.ibm.etools.aries.internal.websphere.ui.Messages;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.wst.server.core.IServer;

public abstract class BaseSelectionDialog
extends TitleAreaDialog {
    private Object input_;
    private ILabelProvider labelProvider_;
    private String message_;
    private CheckboxTableViewer viewer_;
    private Object[] selectedElements_;
    protected IServer server_;

    public BaseSelectionDialog(Shell shell, Object input, ILabelProvider labelProvider, String message) {
        super(shell);
        this.input_ = input;
        this.labelProvider_ = labelProvider;
        this.message_ = message;
    }

    public void setInitialSelections(Object[] selectedElements) {
        this.selectedElements_ = selectedElements;
    }

    public void setServer(IServer server) {
        this.server_ = server;
    }

    protected void configureShell(Shell newShell) {
        newShell.setText(Messages.TITLE_MANAGE_EXTENSIONS);
        newShell.setSize(535, 500);
        super.configureShell(newShell);
    }

    protected Combo createDropdown(Composite parent, String label) {
        Label lbl = new Label(parent, 0);
        lbl.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        lbl.setText(label);
        Combo combo = new Combo(parent, 4);
        combo.setLayoutData((Object)new GridData(4, 4, true, false));
        combo.setBackground(Display.getDefault().getSystemColor(25));
        return combo;
    }

    private void createAdvancedSection(Composite parent) {
        Section section = new Section(parent, 18);
        section.setText(Messages.MSG_ADVANCED);
        section.setFont(JFaceResources.getFontRegistry().getBold("org.eclipse.jface.dialogfont"));
        Composite client = new Composite((Composite)section, 0);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        client.setLayout((Layout)layout);
        Text label = new Text(client, 64);
        GridData gd = new GridData(4, 4, true, false);
        gd.widthHint = 400;
        label.setLayoutData((Object)gd);
        label.setText(this.getAdvancedSectionText());
        label.setEditable(false);
        label.setBackground(client.getBackground());
        Composite inner = new Composite(client, 0);
        inner.setLayoutData((Object)new GridData(4, 4, true, true));
        layout = new GridLayout(2, false);
        layout.marginWidth = 0;
        layout.marginTop = 5;
        layout.marginLeft = 3;
        inner.setLayout((Layout)layout);
        this.createAdvancedControls(inner);
        final Button button = new Button(inner, 8);
        button.setLayoutData((Object)new GridData(0x1000008, 4, false, false, 2, 1));
        button.setText(Messages.MSG_GET_INFO_FROM_SERVER);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                button.setEnabled(false);
                BaseSelectionDialog.this.getInfoFromServer();
            }
        });
        section.setClient((Control)client);
    }

    protected void setShellStyle(int newShellStyle) {
        super.setShellStyle(newShellStyle | 0x10);
    }

    protected Control createDialogArea(Composite parent) {
        this.setTitle(Messages.TITLE_MANAGE_EXTENSIONS);
        this.setMessage(this.message_);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, this.getInfoPopID());
        Composite composite = new Composite((Composite)super.createDialogArea(parent), 0);
        GridData gd = new GridData(4, 4, true, true);
        gd.heightHint = 300;
        composite.setLayoutData((Object)gd);
        GridLayout layout = new GridLayout(2, false);
        layout.marginLeft = 5;
        layout.marginRight = 5;
        composite.setLayout((Layout)layout);
        this.viewer_ = CheckboxTableViewer.newCheckList((Composite)composite, (int)2560);
        this.viewer_.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this.viewer_.setLabelProvider((IBaseLabelProvider)this.labelProvider_);
        this.viewer_.setSorter(new ViewerSorter());
        this.viewer_.getControl().setLayoutData((Object)new GridData(4, 4, true, true, 1, 2));
        this.viewer_.setInput(this.input_);
        this.viewer_.setCheckedElements(this.selectedElements_);
        Button button = new Button(composite, 0);
        button.setLayoutData((Object)new GridData(4, 128, false, false));
        button.setText(Messages.MSG_SELECT_ALL);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                BaseSelectionDialog.this.viewer_.setAllChecked(true);
            }
        });
        button = new Button(composite, 0);
        button.setLayoutData((Object)new GridData(4, 128, false, false));
        button.setText(Messages.MSG_DESELECT_ALL);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                BaseSelectionDialog.this.viewer_.setAllChecked(false);
            }
        });
        this.createAdvancedSection(composite);
        return composite;
    }

    protected Control createButtonBar(Composite parent) {
        Control control = super.createButtonBar(parent);
        this.getButton(0).setText(Messages.MSG_FINISH);
        return control;
    }

    protected void okPressed() {
        this.selectedElements_ = this.viewer_.getCheckedElements();
        super.okPressed();
    }

    public int open() {
        int r = super.open();
        Job.getJobManager().cancel(QueryServerJob.class);
        return r;
    }

    public Object[] getResult() {
        ExtensionRecord record = this.getExtraExtension();
        if (record == null) {
            return this.selectedElements_;
        }
        for (int i = 0; i < this.selectedElements_.length; ++i) {
            if (!record.equals(this.selectedElements_[i])) continue;
            return this.selectedElements_;
        }
        Object[] newResults = new Object[this.selectedElements_.length + 1];
        System.arraycopy(this.selectedElements_, 0, newResults, 0, this.selectedElements_.length);
        newResults[this.selectedElements_.length] = record;
        return newResults;
    }

    protected abstract String getInfoPopID();

    protected abstract String getAdvancedSectionText();

    protected abstract void createAdvancedControls(Composite var1);

    protected abstract void getInfoFromServer();

    protected abstract ExtensionRecord getExtraExtension();
}

