/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.aries.internal.websphere.ui.actions;

import com.ibm.etools.aries.internal.websphere.core.extensions.ExtensionEngine;
import com.ibm.etools.aries.internal.websphere.core.extensions.ExtensionRecord;
import com.ibm.etools.aries.internal.websphere.core.extensions.ModulePublishRecordManager;
import com.ibm.etools.aries.internal.websphere.ui.Activator;
import com.ibm.etools.aries.internal.websphere.ui.Messages;
import com.ibm.etools.aries.internal.websphere.ui.actions.BaseServerModuleAction;
import com.ibm.etools.aries.internal.websphere.ui.extensions.BaseSelectionDialog;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.ui.progress.IProgressService;
import org.eclipse.wst.server.core.IModule;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.IServerWorkingCopy;
import org.eclipse.wst.server.core.ServerUtil;

public abstract class ManageExtensionsAction
extends BaseServerModuleAction {
    private static final String JOB_FAMILY = "com.ibm.etools.aries.websphere.ui.manageExtensionsJob";
    private IWorkspaceRoot root_ = ResourcesPlugin.getWorkspace().getRoot();

    @Override
    protected String getTitle() {
        return Messages.TITLE_MANAGE_EXTENSIONS;
    }

    private List<ExtensionRecord> filterInitialSelection(List<ExtensionRecord> records) {
        ArrayList<ExtensionRecord> filtered = new ArrayList<ExtensionRecord>();
        for (ExtensionRecord record : records) {
            if (!record.getExtend()) continue;
            filtered.add(record);
        }
        return filtered;
    }

    protected void updateRecords(ModulePublishRecordManager manager, List<ExtensionRecord> records, IModule[] modules) {
    }

    private IStatus publish(List<ExtensionRecord> records, ModulePublishRecordManager manager, IProgressMonitor monitor) throws CoreException {
        ArrayList<IModule> modules = new ArrayList<IModule>();
        for (ExtensionRecord record : records) {
            IProject project = this.root_.getProject(this.getPublishProjectName(record));
            IModule module = ServerUtil.getModule((IProject)project);
            if (module == null) {
                record.flagError();
                continue;
            }
            modules.add(module);
        }
        if (modules.isEmpty()) {
            return Activator.createStatus(4, Messages.ERR_EXTENSIONS_PUBLISH, null);
        }
        IModule[] add = modules.toArray(new IModule[modules.size()]);
        IServerWorkingCopy copy = manager.getServer().createWorkingCopy();
        ServerUtil.modifyModules((IServerWorkingCopy)copy, (IModule[])add, null, (IProgressMonitor)monitor);
        IStatus status = copy.save(true, monitor).publish(1, monitor);
        if (status.isOK()) {
            this.updateRecords(manager, records, add);
        }
        return status;
    }

    private void execute(final ExtensionEngine engine, List<Object> records) {
        if (records.isEmpty()) {
            return;
        }
        final ArrayList<ExtensionRecord> toPublish = new ArrayList<ExtensionRecord>();
        for (Object obj : records) {
            ExtensionRecord record = (ExtensionRecord)obj;
            if (record.getExtend()) {
                if (record.getNeedPublish()) {
                    toPublish.add(record);
                }
                engine.addToAddQueue(record);
            } else {
                engine.addToRemoveQueue(record);
            }
            engine.addToUpdateQueue(record);
        }
        final boolean shouldPublish = !toPublish.isEmpty();
        Job job = new Job(Messages.TITLE_MANAGE_EXTENSIONS){

            public boolean belongsTo(Object family) {
                return ManageExtensionsAction.JOB_FAMILY.equals(family);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected IStatus run(IProgressMonitor monitor) {
                IWorkspaceRoot rule = shouldPublish ? ManageExtensionsAction.this.root_ : engine.getMPRManager().getServer();
                Job.getJobManager().beginRule((ISchedulingRule)rule, monitor);
                try {
                    IStatus status;
                    if (shouldPublish && !(status = ManageExtensionsAction.this.publish(toPublish, engine.getMPRManager(), monitor)).isOK()) {
                        IStatus iStatus = status;
                        return iStatus;
                    }
                    engine.run(monitor);
                    status = engine.getStatus();
                    return status;
                }
                catch (CoreException e) {
                    IStatus iStatus = e.getStatus();
                    return iStatus;
                }
                finally {
                    Job.getJobManager().endRule((ISchedulingRule)rule);
                    monitor.done();
                }
            }
        };
        job.schedule();
        IProgressService service = (IProgressService)this.part_.getSite().getService(IProgressService.class);
        service.showInDialog(this.part_.getSite().getShell(), job);
    }

    @Override
    protected IStatus runAction(IServer server, IModule[] modules) {
        ModulePublishRecordManager manager = new ModulePublishRecordManager(server, true);
        if (!this.extractID(modules, manager)) {
            return Activator.createStatus(4, Messages.ERR_EXTENSIONS_NO_ID, null);
        }
        List<ExtensionRecord> records = this.getInput(manager);
        BaseSelectionDialog dialog = this.createDialog(records);
        dialog.setInitialSelections(this.filterInitialSelection(records).toArray());
        dialog.setServer(server);
        if (dialog.open() == 0) {
            ArrayList<Object> selected = new ArrayList<Object>(Arrays.asList(dialog.getResult()));
            for (ExtensionRecord record : records) {
                if (record.getExtend()) {
                    if (selected.contains(record)) {
                        selected.remove(record);
                        continue;
                    }
                    record.setExtend(false);
                    selected.add(record);
                    continue;
                }
                if (!selected.contains(record)) continue;
                record.setExtend(true);
            }
            this.execute(new ExtensionEngine(manager, true), selected);
        }
        return Status.OK_STATUS;
    }

    protected abstract boolean extractID(IModule[] var1, ModulePublishRecordManager var2);

    protected abstract List<ExtensionRecord> getInput(ModulePublishRecordManager var1);

    protected abstract BaseSelectionDialog createDialog(List<ExtensionRecord> var1);

    protected abstract String getPublishProjectName(ExtensionRecord var1);
}

