/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.aries.internal.websphere.ui.actions;

import com.ibm.etools.aries.internal.websphere.ui.Activator;
import com.ibm.etools.aries.internal.websphere.ui.Messages;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.statushandlers.StatusManager;
import org.eclipse.wst.server.core.IModule;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.ui.IServerModule;

public abstract class BaseServerModuleAction
implements IObjectActionDelegate {
    protected IWorkbenchPart part_;
    private IServerModule app_;

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
        this.part_ = targetPart;
    }

    public void selectionChanged(IAction action, ISelection selection) {
        Object element;
        this.app_ = null;
        if (selection instanceof IStructuredSelection && (element = ((IStructuredSelection)selection).getFirstElement()) instanceof IServerModule) {
            this.app_ = (IServerModule)element;
        }
    }

    public void run(IAction action) {
        if (this.app_ == null) {
            return;
        }
        IServer server = this.app_.getServer();
        IModule[] modules = this.app_.getModule();
        if (server.getServerState() != 2 || server.getModulePublishState(modules) != 1) {
            MessageDialog.openInformation((Shell)this.part_.getSite().getShell(), (String)this.getTitle(), (String)Messages.MSG_CANNOT_RUN_ACTION);
            return;
        }
        IStatus status = this.runAction(server, modules);
        if (!status.isOK()) {
            Activator.getDefault().getLog().log(status);
            StatusManager.getManager().handle(status, 4);
        }
    }

    protected abstract String getTitle();

    protected abstract IStatus runAction(IServer var1, IModule[] var2);
}

