/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.aries.internal.websphere.ui.actions;

import com.ibm.etools.aries.core.commands.IOSGiCommand;
import com.ibm.etools.aries.internal.ui.utils.EditorUtils;
import com.ibm.etools.aries.internal.websphere.ui.Activator;
import com.ibm.etools.aries.internal.websphere.ui.Messages;
import com.ibm.etools.aries.internal.websphere.ui.actions.BaseServerModuleAction;
import java.io.File;
import java.io.FileReader;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.wst.server.core.IModule;
import org.eclipse.wst.server.core.IServer;

public abstract class BaseImportDeploymentAction
extends BaseServerModuleAction {
    @Override
    protected IStatus runAction(IServer server, IModule[] modules) {
        File deploymentFile = null;
        try {
            deploymentFile = File.createTempFile("DEPLOYMENT", "MF");
            deploymentFile.deleteOnExit();
            IOSGiCommand command = this.getImportDeploymentCommand(server, modules, deploymentFile);
            ResourcesPlugin.getWorkspace().run((IWorkspaceRunnable)command, command.getSchedulingRule(), 1, null);
            String fileContents = this.readFile(deploymentFile);
            EditorUtils.openDeploymentEditor((String)fileContents, (IProject)modules[0].getProject());
            return Status.OK_STATUS;
        }
        catch (CoreException e) {
            return e.getStatus();
        }
        catch (Exception e) {
            return Activator.createStatus(4, com.ibm.etools.aries.internal.websphere.core.Messages.ERROR_IMPORT_DEPLOYMENT_MF, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String readFile(File deploymentFile) {
        StringBuffer buffer = new StringBuffer();
        FileReader reader = null;
        char[] charBuff = new char[500];
        try {
            reader = new FileReader(deploymentFile);
            int result = reader.read(charBuff, 0, 500);
            while (result != -1) {
                buffer.append(charBuff, 0, result);
                result = reader.read(charBuff, 0, 500);
            }
        }
        catch (Exception exc) {
            Activator.getTrace().trace("/debug/error", "exc", (Throwable)exc);
        }
        finally {
            try {
                if (reader != null) {
                    reader.close();
                }
            }
            catch (Exception exc) {
                Activator.getTrace().trace("/debug/error", "exc", (Throwable)exc);
            }
        }
        return buffer.toString();
    }

    @Override
    protected String getTitle() {
        return Messages.TITLE_IMPORT_DEPLOYMENT;
    }

    protected abstract IOSGiCommand getImportDeploymentCommand(IServer var1, IModule[] var2, File var3);
}

