/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jee.bean.validation.ui.internal.wizards;

import com.ibm.jee.bean.validation.core.content.BeanFileGenerator;
import com.ibm.jee.bean.validation.core.internal.utils.ProjectUtils;
import com.ibm.jee.bean.validation.ui.internal.wizards.Messages;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class NewBeanConstraintsFileWizardPage
extends WizardPage {
    private Text fileNameText;
    private IProject project;
    private Label projectNameLabel;
    private Combo projectNameCombo;

    protected NewBeanConstraintsFileWizardPage(String pageName) {
        super(pageName);
        this.setTitle(Messages.NewBeanConstraintsFileWizardPageTitle);
        this.setDescription(Messages.NewBeanConstraintsFileWizardPageDescription);
    }

    public void createControl(Composite parent) {
        Composite top = new Composite(parent, 0);
        top.setLayout((Layout)new GridLayout(3, false));
        this.createProjectGroup(top);
        this.createFileNameGroup(top);
        this.setControl((Control)top);
        this.validatePage();
    }

    private void createProjectGroup(Composite parent) {
        GridData data = new GridData(768);
        this.projectNameLabel = new Label(parent, 0);
        this.projectNameLabel.setText(Messages.NewBeanConstraintsFileWizardPageProjectLabel);
        this.projectNameLabel.setLayoutData((Object)data);
        data = new GridData(768);
        data.widthHint = 300;
        data.horizontalSpan = 1;
        this.projectNameCombo = new Combo(parent, 2056);
        this.projectNameCombo.setLayoutData((Object)data);
        String projectName = this.getProject().getName();
        this.projectNameCombo.setItems(new String[]{projectName});
        this.projectNameCombo.setText(projectName);
        this.projectNameCombo.setEnabled(false);
        new Label(parent, 0);
    }

    private void createFileNameGroup(Composite top) {
        GridData data = new GridData(768);
        Label fileNameLabel = new Label(top, 0);
        fileNameLabel.setText(Messages.NewBeanConstraintsFileWizardPageFileNameLabel);
        fileNameLabel.setLayoutData((Object)data);
        data = new GridData(768);
        this.fileNameText = new Text(top, 2048);
        this.fileNameText.setLayoutData((Object)data);
        this.fileNameText.addKeyListener(new KeyListener(){

            public void keyReleased(KeyEvent arg0) {
                NewBeanConstraintsFileWizardPage.this.validatePage();
            }

            public void keyPressed(KeyEvent arg0) {
            }
        });
        this.fileNameText.setFocus();
        if (this.project != null) {
            this.fileNameText.setText(BeanFileGenerator.getConstraintFileNamingProposal((IProject)this.project));
        }
        top.setLayoutData((Object)data);
    }

    protected void validatePage() {
        if (this.project == null || !ProjectUtils.isValidProject((IProject)this.project)) {
            this.setErrorMessage(Messages.ErrorNewBeanConstraintsFileWizardPageProjectNotSelected);
            this.setPageComplete(false);
            return;
        }
        String fileName = this.getFileName();
        if (fileName == null || fileName.equals(".xml")) {
            this.setErrorMessage(Messages.ErrorNewBeanConstraintsFileWizardPageFileNameEmpty);
            this.setPageComplete(false);
        } else if (BeanFileGenerator.constraintsFileExists((IProject)this.project, (String)fileName)) {
            this.setErrorMessage(Messages.ErrorNewBeanConstraintsFileWizardPageFileExists);
            this.setPageComplete(false);
        } else {
            this.setErrorMessage(null);
            this.setPageComplete(true);
        }
    }

    String getFileName() {
        String fileName = this.fileNameText.getText();
        if (fileName.endsWith(".xml")) {
            return fileName;
        }
        return fileName + ".xml";
    }

    public void setProject(IProject project) {
        this.project = ProjectUtils.isValidProject((IProject)project) ? project : null;
    }

    public IProject getProject() {
        return this.project;
    }
}

