/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jee.bean.validation.ui.internal.wizards;

import com.ibm.jee.bean.validation.core.content.BeanFileGenerator;
import com.ibm.jee.bean.validation.ui.internal.utils.ResourceUtils;
import com.ibm.jee.bean.validation.ui.internal.wizards.Messages;
import com.ibm.jee.bean.validation.ui.internal.wizards.NewBeanConstraintsFileWizardPage;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;

public class NewBeanConstraintsFileWizard
extends Wizard
implements INewWizard {
    private static final String PAGE_ONE = "pagOne";
    private NewBeanConstraintsFileWizardPage onlyPage;
    private IProject project;
    private String createdFileName;
    private boolean addToValidationXML = true;

    public void addPages() {
        this.setWindowTitle(Messages.NewBeanConstraintsFileWizardTitle);
        this.onlyPage = new NewBeanConstraintsFileWizardPage(PAGE_ONE);
        this.onlyPage.setProject(this.project);
        this.addPage((IWizardPage)this.onlyPage);
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.project = ResourceUtils.getProjectFromSelection((ISelection)selection);
    }

    public boolean performFinish() {
        this.project = this.onlyPage.getProject();
        IFile emptyFile = BeanFileGenerator.createEmptyContraintsFile((IProject)this.project, (String)this.onlyPage.getFileName());
        if (emptyFile != null) {
            ResourceUtils.openResource(emptyFile);
            this.setCreatedFileName(emptyFile);
            if (this.addToValidationXML) {
                BeanFileGenerator.addConstraintMappingsNode((IFile)emptyFile);
            }
        }
        return true;
    }

    public String getCreatedFileName() {
        return this.createdFileName;
    }

    public void setCreatedFileName(IFile createdFile) {
        this.createdFileName = createdFile.getProjectRelativePath().toPortableString();
    }

    public void setProject(IProject project) {
        this.project = project;
    }

    public void setAddToValidationXML(boolean addToValidationXML) {
        this.addToValidationXML = addToValidationXML;
    }
}

