/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jee.bean.validation.ui.internal.utils;

import com.ibm.jee.bean.validation.ui.Activator;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jem.util.emf.workbench.ProjectUtilities;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;

public final class ResourceUtils {
    public static IProject getProjectFromSelection(ISelection selection) {
        Object firstElement;
        IStructuredSelection structuredSelection = (IStructuredSelection)selection;
        IProject project = ProjectUtilities.getProject((Object)structuredSelection.getFirstElement());
        if (project == null && (firstElement = structuredSelection.getFirstElement()) instanceof IResource) {
            project = ((IResource)firstElement).getProject();
        }
        return project;
    }

    public static IProject getProjectFromEditorPart(IEditorPart editor) {
        IEditorInput input;
        if (editor != null && (input = editor.getEditorInput()) instanceof IFileEditorInput) {
            IFile currentFile = ((IFileEditorInput)input).getFile();
            return currentFile.getProject();
        }
        return null;
    }

    public static void openResource(final IFile resource) {
        Display display;
        final IWorkbenchPage activePage = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        if (activePage != null && (display = PlatformUI.getWorkbench().getDisplay()) != null) {
            display.asyncExec(new Runnable(){

                @Override
                public void run() {
                    try {
                        IDE.openEditor((IWorkbenchPage)activePage, (IFile)resource, (boolean)true);
                    }
                    catch (PartInitException e) {
                        Activator.logError((CoreException)e);
                    }
                }
            });
        }
    }

    public static void openClassFile(String fullyQualifiedClassName, IProject project) {
        IJavaProject javaProject = JavaCore.create((IProject)project);
        try {
            IType type = javaProject.findType(fullyQualifiedClassName);
            if (type != null && !type.isBinary()) {
                IResource resource = type.getResource();
                IPath file = resource.getProjectRelativePath();
                IProject srcProj = resource.getProject();
                IFile target = srcProj.getFile(file);
                if (target != null && target.exists()) {
                    ResourceUtils.openResource(target);
                }
            }
        }
        catch (JavaModelException e) {
            Activator.logError((CoreException)e);
        }
    }
}

