/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jee.bean.validation.ui.internal.handlers;

import com.ibm.jee.bean.validation.core.internal.utils.ProjectUtils;
import com.ibm.jee.bean.validation.ui.internal.handlers.AbstractBrowseActionHandler;
import com.ibm.jee.bean.validation.ui.internal.utils.ResourceUtils;
import com.ibm.jee.bean.validation.ui.internal.wizards.NewBeanConstraintsFileWizard;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.ui.IEditorPart;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class ConstraintsMappingHandler
extends AbstractBrowseActionHandler {
    public String invoke(String value, Node itemNode, Element closestAncestor, IEditorPart editorPart) {
        IProject project = ResourceUtils.getProjectFromEditorPart(editorPart);
        if (value == null || value.isEmpty()) {
            NewBeanConstraintsFileWizard wizard = new NewBeanConstraintsFileWizard();
            wizard.setProject(project);
            wizard.setAddToValidationXML(false);
            WizardDialog dialog = new WizardDialog(this.getShell(), (IWizard)wizard);
            if (dialog.open() == 0) {
                String projectRelativeFileName = wizard.getCreatedFileName();
                String runtimePath = ProjectUtils.getPathRelativeToContainer((IProject)project, (String)projectRelativeFileName);
                if (runtimePath != null) {
                    return runtimePath;
                }
                return projectRelativeFileName;
            }
        } else {
            IFile target = ProjectUtils.getProjectRelativePathFromArchivePath((IProject)project, (String)value);
            if (target != null && target.exists()) {
                ResourceUtils.openResource(target);
            }
        }
        return null;
    }
}

