/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jee.bean.validation.ui.internal.handlers;

import com.ibm.jee.bean.validation.core.internal.utils.ProjectUtils;
import com.ibm.jee.bean.validation.ui.Activator;
import com.ibm.jee.bean.validation.ui.internal.handlers.AbstractBrowseActionHandler;
import com.ibm.jee.bean.validation.ui.internal.handlers.Messages;
import com.ibm.jee.bean.validation.ui.internal.utils.ResourceUtils;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;
import org.eclipse.ui.dialogs.ISelectionStatusValidator;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class ConstraintsMappingBrowseHandler
extends AbstractBrowseActionHandler {
    public String invoke(String value, Node itemNode, Element closestAncestor, IEditorPart editorPart) {
        IProject project = ResourceUtils.getProjectFromEditorPart(editorPart);
        IContainer container = ProjectUtils.getContainer((IProject)project, null);
        IFile currentXMLFile = this.browseWorkspaceXMLFile(container);
        if (currentXMLFile != null) {
            String path = currentXMLFile.getProjectRelativePath().toPortableString();
            return ProjectUtils.getPathRelativeToContainer((IProject)project, (String)path);
        }
        return null;
    }

    protected IFile browseWorkspaceXMLFile(Object input) {
        IFile file;
        ElementTreeSelectionDialog dialog = new ElementTreeSelectionDialog(this.getShell(), (ILabelProvider)new WorkbenchLabelProvider(), (ITreeContentProvider)new WorkbenchContentProvider());
        dialog.setInput(input);
        dialog.setAllowMultiple(false);
        dialog.setTitle(Messages.selectMappingsFile_title);
        dialog.setMessage(Messages.selectMappingsFile_message);
        dialog.addFilter(new ViewerFilter(){

            public boolean select(Viewer viewer, Object parentElement, Object element) {
                if (element instanceof IFile) {
                    String path = ((IFile)element).getLocation().toPortableString().toLowerCase();
                    return path.endsWith(".xml") && !path.endsWith("meta-inf/validation.xml");
                }
                return true;
            }
        });
        dialog.setValidator(new ISelectionStatusValidator(){

            public IStatus validate(Object[] selection) {
                if (selection != null && selection.length > 0 && selection[0] instanceof IFile) {
                    return Activator.createStatus(0, "");
                }
                return Activator.createStatus(4, "");
            }
        });
        if (dialog.open() == 0 && (file = (IFile)dialog.getFirstResult()) != null) {
            return file;
        }
        return null;
    }
}

