/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.swagger.rest.api.ui.wizards.jaxrs;

import com.ibm.etools.swagger.rest.api.ui.SwaggerUIMessages;
import com.ibm.etools.swagger.rest.api.ui.SwaggerUIPlugin;
import com.ibm.etools.swagger.rest.api.ui.util.ProjectUtils;
import java.io.File;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.URIUtil;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.JavaConventions;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jst.ws.internal.ui.common.DialogResourceBrowser;
import org.eclipse.jst.ws.internal.ui.common.FileExtensionFilter;
import org.eclipse.jst.ws.internal.ui.common.IFilter;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.dnd.DropTargetAdapter;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.FileTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.SelectionDialog;
import org.eclipse.wst.command.internal.env.core.common.StatusUtils;
import org.eclipse.wst.command.internal.env.ui.widgets.SimpleWidgetDataContributor;
import org.eclipse.wst.command.internal.env.ui.widgets.WidgetDataEvents;

public class SwaggerCodeGenJaxrsClientWidget
extends SimpleWidgetDataContributor {
    private Combo javaProjectsCombo;
    private Combo javaProjectsSourceFoldersCombo;
    private List<String> allValidTargetPaths;
    private List<IJavaProject> availableJavaProjects;
    private IJavaProject selectedTargetProject;
    private List<String> validTargetPathsForProject;
    private String selectedTargetSourceFolder;
    private Text swaggerJsonText;
    private String swaggerJsonFilePath;
    private String urlOfJsonFile;
    private Text targetPackageText;
    private String targetPackage;
    private Button browseButtonForFile;
    private Button browseButtonForPackage;
    private Listener statusListener;
    private Composite parent;
    private IFile swaggerJsonFile;
    private File externalFile;
    private boolean jsonTextModified = false;

    protected String getTooltipSwaggerFile() {
        return SwaggerUIMessages.SWAGGER_WIDGET_JSON_FILE_TOOLTIP;
    }

    protected String getTooltipSourceFolder() {
        return SwaggerUIMessages.SWAGGER_WIDGET_SOURCE_FOLDER_TOOLTIP;
    }

    protected String getTooltipPackage() {
        return SwaggerUIMessages.SWAGGER_WIDGET_TARGET_PACKAGE_TOOLTIP;
    }

    protected String getNoWebProjectsError() {
        return SwaggerUIMessages.SWAGGER_WIDGET_NO_AVAILABLE_PROJECTS_CLIENT;
    }

    public WidgetDataEvents addControls(final Composite parent, Listener listener) {
        this.statusListener = listener;
        this.parent = parent;
        Composite topComposite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        topComposite.setLayout((Layout)layout);
        GridData data = new GridData();
        data.verticalAlignment = 4;
        data.horizontalAlignment = 4;
        data.grabExcessHorizontalSpace = true;
        data.grabExcessVerticalSpace = true;
        topComposite.setLayoutData((Object)data);
        Composite composite = new Composite(topComposite, 0);
        layout = new GridLayout();
        layout.numColumns = 3;
        composite.setLayout((Layout)layout);
        data = new GridData();
        data.verticalAlignment = 4;
        data.horizontalAlignment = 4;
        data.grabExcessHorizontalSpace = true;
        composite.setLayoutData((Object)data);
        Label swaggerJsonLabel = new Label(composite, 16384);
        swaggerJsonLabel.setText(SwaggerUIMessages.SWAGGER_WIDGET_JSON_FILE);
        swaggerJsonLabel.setToolTipText(this.getTooltipSwaggerFile());
        data = new GridData();
        data.horizontalAlignment = 4;
        swaggerJsonLabel.setLayoutData((Object)data);
        this.swaggerJsonText = new Text(composite, 2048);
        this.swaggerJsonText.setToolTipText(this.getTooltipSwaggerFile());
        data = new GridData();
        data.horizontalSpan = 1;
        data.horizontalAlignment = 4;
        data.grabExcessHorizontalSpace = true;
        this.swaggerJsonText.setLayoutData((Object)data);
        this.swaggerJsonText.setText("http://");
        this.swaggerJsonText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent arg0) {
                SwaggerCodeGenJaxrsClientWidget.this.statusListener.handleEvent(null);
            }
        });
        DropTarget dropTarget = new DropTarget((Control)this.swaggerJsonText, 2);
        dropTarget.setTransfer(new Transfer[]{FileTransfer.getInstance()});
        dropTarget.addDropListener((DropTargetListener)new DropTargetAdapter(){

            public void drop(DropTargetEvent event) {
                String[] filenames;
                Object obj = event.data;
                if (obj != null && obj instanceof String[] && (filenames = (String[])obj).length > 0) {
                    SwaggerCodeGenJaxrsClientWidget.this.swaggerJsonText.setText(filenames[0]);
                }
            }
        });
        this.browseButtonForFile = new Button(composite, 8);
        this.browseButtonForFile.setText(SwaggerUIMessages.BUTTON_BROWSE_1);
        data = new GridData();
        data.horizontalSpan = 1;
        data.horizontalAlignment = 4;
        this.browseButtonForFile.setLayoutData((Object)data);
        this.browseButtonForFile.setImage(SwaggerUIPlugin.getDefault().getImage("obj16/ArrowDown.gif"));
        this.browseButtonForFile.setOrientation(0x4000000);
        this.browseButtonForFile.setEnabled(true);
        final Menu menu = new Menu((Control)composite.getShell());
        MenuItem workspaceMenuItem = new MenuItem(menu, 0);
        workspaceMenuItem.setText(SwaggerUIMessages.MENU_ITEM_WORKSPACE);
        workspaceMenuItem.setImage(SwaggerUIPlugin.getDefault().getImage("obj16/workspace_obj.gif"));
        workspaceMenuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SwaggerCodeGenJaxrsClientWidget.this.handleBrowseWorkspace();
                SwaggerCodeGenJaxrsClientWidget.this.statusListener.handleEvent(null);
            }
        });
        MenuItem filesystemMenuItem = new MenuItem(menu, 0);
        filesystemMenuItem.setText(SwaggerUIMessages.MENU_ITEM_EXTERNAL);
        filesystemMenuItem.setImage(SwaggerUIPlugin.getDefault().getImage("obj16/file_system.gif"));
        filesystemMenuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SwaggerCodeGenJaxrsClientWidget.this.handleBrowseExternal();
                SwaggerCodeGenJaxrsClientWidget.this.statusListener.handleEvent(null);
            }
        });
        this.browseButtonForFile.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Button b = (Button)e.widget;
                Rectangle r = b.getBounds();
                Point p = b.getParent().toDisplay(new Point(r.x, r.y));
                menu.setLocation(p.x, p.y + r.height);
                menu.setVisible(true);
            }
        });
        Label projectLabel = new Label(composite, 16384);
        projectLabel.setText(SwaggerUIMessages.SWAGGER_WIDGET_TARGET_PROJECT);
        projectLabel.setToolTipText(SwaggerUIMessages.SWAGGER_WIDGET_TARGET_PROJECT_TOOLTIP);
        data = new GridData();
        data.horizontalAlignment = 4;
        projectLabel.setLayoutData((Object)data);
        this.javaProjectsCombo = new Combo(composite, 8);
        this.javaProjectsCombo.setToolTipText(SwaggerUIMessages.SWAGGER_WIDGET_TARGET_PROJECT_TOOLTIP);
        data = new GridData();
        data.horizontalSpan = 2;
        data.horizontalAlignment = 4;
        data.grabExcessHorizontalSpace = true;
        this.javaProjectsCombo.setLayoutData((Object)data);
        this.javaProjectsCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SwaggerCodeGenJaxrsClientWidget.this.statusListener.handleEvent(null);
                SwaggerCodeGenJaxrsClientWidget.this.updateTargetSourceCombo();
            }
        });
        Label projectSourceFoldersLabel = new Label(composite, 16384);
        projectSourceFoldersLabel.setText(SwaggerUIMessages.SWAGGER_WIDGET_SOURCE_FOLDER);
        projectSourceFoldersLabel.setToolTipText(this.getTooltipSourceFolder());
        data = new GridData();
        data.horizontalAlignment = 4;
        projectSourceFoldersLabel.setLayoutData((Object)data);
        this.javaProjectsSourceFoldersCombo = new Combo(composite, 8);
        this.javaProjectsSourceFoldersCombo.setToolTipText(this.getTooltipSourceFolder());
        data = new GridData();
        data.horizontalSpan = 2;
        data.horizontalAlignment = 4;
        data.grabExcessHorizontalSpace = true;
        this.javaProjectsSourceFoldersCombo.setLayoutData((Object)data);
        this.javaProjectsSourceFoldersCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SwaggerCodeGenJaxrsClientWidget.this.selectedTargetSourceFolder = SwaggerCodeGenJaxrsClientWidget.this.javaProjectsSourceFoldersCombo.getText();
                SwaggerCodeGenJaxrsClientWidget.this.statusListener.handleEvent(null);
            }
        });
        Label targetPackageLabel = new Label(composite, 16384);
        targetPackageLabel.setText(SwaggerUIMessages.SWAGGER_WIDGET_TARGET_PACKAGE);
        targetPackageLabel.setToolTipText(this.getTooltipPackage());
        data = new GridData();
        data.horizontalAlignment = 4;
        targetPackageLabel.setLayoutData((Object)data);
        this.targetPackageText = new Text(composite, 2048);
        this.targetPackageText.setToolTipText(this.getTooltipPackage());
        data = new GridData();
        data.horizontalSpan = 1;
        data.horizontalAlignment = 4;
        data.grabExcessHorizontalSpace = true;
        this.targetPackageText.setLayoutData((Object)data);
        this.targetPackageText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                SwaggerCodeGenJaxrsClientWidget.this.targetPackage = SwaggerCodeGenJaxrsClientWidget.this.targetPackageText.getText();
                SwaggerCodeGenJaxrsClientWidget.this.statusListener.handleEvent(null);
            }
        });
        this.browseButtonForPackage = new Button(composite, 8);
        this.browseButtonForPackage.setText(SwaggerUIMessages.BUTTON_BROWSE_2);
        data = new GridData();
        data.horizontalSpan = 1;
        data.horizontalAlignment = 4;
        this.browseButtonForPackage.setLayoutData((Object)data);
        this.browseButtonForPackage.setEnabled(true);
        this.browseButtonForPackage.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                try {
                    Object o;
                    Object[] result;
                    SelectionDialog packageDialog = JavaUI.createPackageDialog((Shell)parent.getShell(), (IJavaProject)SwaggerCodeGenJaxrsClientWidget.this.selectedTargetProject, (int)0, (String)"*");
                    packageDialog.setTitle(SwaggerUIMessages.SWAGGER_BROWSE_PACKAGE_DIALOG_TITLE);
                    int rc = packageDialog.open();
                    if (rc == 0 && (result = packageDialog.getResult()) != null && result.length == 1 && (o = result[0]) instanceof IPackageFragment) {
                        IPackageFragment pkg = (IPackageFragment)o;
                        SwaggerCodeGenJaxrsClientWidget.this.targetPackageText.setText(pkg.getElementName());
                        SwaggerCodeGenJaxrsClientWidget.this.targetPackage = pkg.getElementName();
                    }
                }
                catch (JavaModelException javaModelException) {
                    // empty catch block
                }
                SwaggerCodeGenJaxrsClientWidget.this.statusListener.handleEvent(null);
            }
        });
        Dialog.applyDialogFont((Control)parent);
        return super.addControls(parent, this.statusListener);
    }

    public IStatus getStatus() {
        if (this.availableJavaProjects != null && this.availableJavaProjects.size() <= 0) {
            this.browseButtonForFile.setEnabled(false);
            this.browseButtonForPackage.setEnabled(false);
            return StatusUtils.errorStatus((String)this.getNoWebProjectsError());
        }
        String targetPackageValue = this.targetPackageText.getText();
        IStatus retStatus = this.validatePackage(targetPackageValue);
        if (retStatus.getSeverity() == 4) {
            return retStatus.getMessage() != null ? StatusUtils.errorStatus((String)retStatus.getMessage()) : StatusUtils.errorStatus((String)SwaggerUIMessages.bind((String)SwaggerUIMessages.ERROR_INVALIDPACKAGENAME, (Object[])new String[]{targetPackageValue}));
        }
        return this.validateSwaggerJSONValue(this.swaggerJsonText.getText());
    }

    public void internalize() {
        if (this.availableJavaProjects != null && this.availableJavaProjects.size() > 0) {
            this.javaProjectsCombo.removeAll();
            for (IJavaProject aProject : this.availableJavaProjects) {
                this.javaProjectsCombo.add(aProject.getProject().getName());
            }
            this.javaProjectsCombo.select(0);
            this.selectedTargetProject = this.availableJavaProjects.get(0);
        } else {
            SwaggerUIPlugin.logError("SwaggerCodeGenJaxrsClientWidget.internalize: There are no available target projects");
        }
        if (this.validTargetPathsForProject == null) {
            try {
                this.validTargetPathsForProject = ProjectUtils.getValidTargetPathForProject(this.selectedTargetProject);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.validTargetPathsForProject != null && this.validTargetPathsForProject.size() > 0) {
            this.javaProjectsSourceFoldersCombo.removeAll();
            for (String src : this.validTargetPathsForProject) {
                if (src.startsWith("/")) {
                    src = src.substring(1);
                }
                this.javaProjectsSourceFoldersCombo.add(src);
            }
            this.javaProjectsSourceFoldersCombo.select(0);
            this.selectedTargetSourceFolder = this.javaProjectsSourceFoldersCombo.getText();
        }
        this.targetPackageText.setText(this.targetPackage);
        if (this.swaggerJsonFilePath != null) {
            if (this.swaggerJsonFilePath.startsWith("/")) {
                this.swaggerJsonFilePath = this.swaggerJsonFilePath.substring(1);
            }
            this.swaggerJsonText.setText(this.swaggerJsonFilePath);
        }
    }

    private void updateTargetSourceCombo() {
        int selectionIndex = this.javaProjectsCombo.getSelectionIndex();
        if (selectionIndex >= 0) {
            this.selectedTargetProject = this.availableJavaProjects.get(selectionIndex);
            try {
                List<String> validTargetPathForProject = ProjectUtils.getValidTargetPathForProject(this.selectedTargetProject);
                this.javaProjectsSourceFoldersCombo.removeAll();
                for (String src : validTargetPathForProject) {
                    if (src.startsWith("/")) {
                        src = src.substring(1);
                    }
                    this.javaProjectsSourceFoldersCombo.add(src);
                }
                this.javaProjectsSourceFoldersCombo.select(0);
                this.selectedTargetSourceFolder = this.javaProjectsSourceFoldersCombo.getText();
            }
            catch (JavaModelException e) {
                SwaggerUIPlugin.logError("SwaggerCodeGenJaxrsClientWidget.updateTargetSourceCombo: Problem getting the list of source folders for the project " + String.valueOf(this.selectedTargetProject), e);
            }
        }
    }

    public void setAllValidTargetPaths(List<String> targetPaths) {
        if (this.allValidTargetPaths == null && targetPaths != null) {
            this.allValidTargetPaths = new ArrayList<String>(targetPaths.size());
            for (String targetPath : targetPaths) {
                this.allValidTargetPaths.add(targetPath);
            }
        }
    }

    public String getTargetSourceFolder() {
        return "";
    }

    public void setSwaggerJsonFilePath(String path) {
        this.swaggerJsonFilePath = path;
    }

    public IFile getSwaggerJsonFile() {
        return this.swaggerJsonFile;
    }

    public void setSwaggerJsonFile(IFile swaggerJsonFile) {
        if (this.swaggerJsonFile == null) {
            this.swaggerJsonFile = swaggerJsonFile;
        }
    }

    public String getTargetPackage() {
        return this.targetPackage;
    }

    public void setTargetPackage(String targetPackage) {
        this.targetPackage = targetPackage;
    }

    public void setAvailableJavaProjects(List<IJavaProject> availableJavaProjects) {
        this.availableJavaProjects = availableJavaProjects;
    }

    public void setValidTargetPathsForProject(List<String> validTargetPathsForProject) {
        this.validTargetPathsForProject = validTargetPathsForProject;
    }

    public IJavaProject getSelectedTargetProject() {
        return this.selectedTargetProject;
    }

    public String getSelectedTargetSourceFolder() {
        return this.selectedTargetSourceFolder;
    }

    public String getUrlOfJsonFile() {
        return this.urlOfJsonFile;
    }

    public File getExternalFile() {
        return this.externalFile;
    }

    private IStatus validatePackage(String packName) {
        if (packName == null || packName.length() == 0) {
            return Status.OK_STATUS;
        }
        return JavaConventions.validatePackageName((String)packName, (String)"1.6", (String)"1.6");
    }

    private void handleBrowseExternal() {
        FileDialog fd = new FileDialog(this.parent.getShell());
        fd.setText(SwaggerUIMessages.SWAGGER_WIDGET_SELECT_EXTERNAL_FILE);
        fd.setFilterExtensions(new String[]{"*.json", "*.yaml"});
        String selectedFile = fd.open();
        if (selectedFile != null && selectedFile.length() > 0) {
            this.externalFile = new File(selectedFile);
            this.swaggerJsonText.setText(selectedFile);
        }
    }

    private void handleBrowseWorkspace() {
        FileExtensionFilter wsFilter = new FileExtensionFilter(new String[]{"json"});
        DialogResourceBrowser dialog = new DialogResourceBrowser(this.parent.getShell(), null, (IFilter)wsFilter);
        int rc = dialog.open();
        if (rc != 0) {
            return;
        }
        this.swaggerJsonFile = (IFile)dialog.getFirstSelection();
        this.urlOfJsonFile = null;
        if (this.swaggerJsonFile != null) {
            this.swaggerJsonFilePath = this.swaggerJsonFile.getFullPath().toString();
            if (this.swaggerJsonFilePath.startsWith("/")) {
                this.swaggerJsonFilePath = this.swaggerJsonFilePath.substring(1);
            }
            IProject project = this.swaggerJsonFile.getProject();
            try {
                this.allValidTargetPaths = ProjectUtils.getAllValidTargetPaths(project);
                this.availableJavaProjects = ProjectUtils.getAvailableWebProjects(project);
                this.validTargetPathsForProject = ProjectUtils.getValidTargetPathForProject(ProjectUtils.getJavaProject(project));
                this.internalize();
                this.updateTargetSourceCombo();
            }
            catch (JavaModelException e) {
                SwaggerUIPlugin.logError("SwaggerCodeGenJaxrsClientWidget.handleBrowseWorkspace: Problem getting source folders", e);
            }
        }
        this.statusListener.handleEvent(null);
    }

    private IStatus validateSwaggerJSONValue(String urlValue) {
        IStatus status = Status.OK_STATUS;
        try {
            this.swaggerJsonFile = null;
            this.externalFile = null;
            IFile file = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(urlValue));
            if (file != null && file.exists()) {
                this.swaggerJsonFile = file;
                return Status.OK_STATUS;
            }
            File testFile = new File(urlValue);
            if (testFile.exists() && testFile.isFile()) {
                this.externalFile = testFile;
                return Status.OK_STATUS;
            }
            if (urlValue.startsWith("file:") && (testFile = URIUtil.toFile((URI)new URI(urlValue))).exists() && testFile.isFile()) {
                this.externalFile = testFile;
                return Status.OK_STATUS;
            }
            status = StatusUtils.errorStatus((String)SwaggerUIMessages.FILE_OR_URL_ERROR_LOCATION_INVALID);
        }
        catch (Exception e) {
            status = StatusUtils.errorStatus((String)SwaggerUIMessages.FILE_OR_URL_ERROR_LOCATION_INVALID);
        }
        if (this.swaggerJsonFile == null && this.externalFile == null && urlValue.startsWith("http:")) {
            status = Status.OK_STATUS;
            try {
                if (urlValue.equals("http://") && !this.jsonTextModified) {
                    this.urlOfJsonFile = null;
                    return status;
                }
                this.jsonTextModified = true;
                URI.create(urlValue);
                if (urlValue.equals("") || urlValue.equals("http:") || urlValue.equals("http:/")) {
                    return StatusUtils.errorStatus((String)(SwaggerUIMessages.FILE_OR_URL_ERROR_INVALID_URL + " " + urlValue));
                }
                this.urlOfJsonFile = urlValue;
            }
            catch (Exception e) {
                this.urlOfJsonFile = null;
                return StatusUtils.errorStatus((String)(SwaggerUIMessages.FILE_OR_URL_ERROR_INVALID_URL + " " + urlValue));
            }
        }
        return status;
    }
}

