/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.swagger.rest.api.ui.wizards;

import com.ibm.etools.openapi.core.util.AbstractFileHandler;
import com.ibm.etools.openapi.core.util.OpenApiFileHandler;
import com.ibm.etools.openapi.core.util.SwaggerFileHandler;
import com.ibm.etools.swagger.rest.api.ui.SwaggerUIMessages;
import com.ibm.etools.swagger.rest.api.ui.util.ProjectUtils;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.accessibility.Accessible;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class SwaggerFileWizardPageOne
extends WizardPage {
    private IProject project;
    private Label projectNameLabel;
    private Label versionLabel;
    private Label fileTypeComboLabel;
    private Combo projectNameCombo;
    private Combo versionCombo;
    private Combo fileTypeCombo;
    protected Button _skeletonButton;
    protected Button _sampleButton;
    protected Button _stubButton;
    protected Button _topLevelLocationButton;
    protected Button _stubLocationButton;
    private Group _fileSelectionGroup;
    private Group _locationSelectionGroup;
    private boolean _genTemplate = true;
    private boolean _genTopLevel = true;
    private boolean _isJson = true;
    private String _specVersion = "3.0";

    protected SwaggerFileWizardPageOne(String pageName) {
        super(pageName);
        this.setTitle(SwaggerUIMessages.SwaggerFileDialogTitle);
        this.setDescription(SwaggerUIMessages.SwaggerFileDialogDescription);
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        composite.setLayout((Layout)layout);
        GridData data = new GridData();
        data.verticalAlignment = 4;
        data.horizontalAlignment = 4;
        data.widthHint = 300;
        composite.setLayoutData((Object)data);
        this.createProjectGroup(composite);
        this.createFileSelectionGroup(composite);
        this.createLocationSelectionGroup(composite);
        this.setControl((Control)composite);
        this._genTopLevel = true;
        this._stubLocationButton.setEnabled(false);
        this.validatePage();
        this.addAccessibilityRelationships();
    }

    private void addAccessibilityRelationships() {
        Accessible accessibleProjectNameLabel = this.projectNameLabel.getAccessible();
        Accessible accessibleProjectNameCombo = this.projectNameCombo.getAccessible();
        Accessible accessibleVersionLabel = this.versionLabel.getAccessible();
        Accessible accessibleVersionCombo = this.versionCombo.getAccessible();
        Accessible accessibleFileTypeComboLabel = this.fileTypeComboLabel.getAccessible();
        Accessible accessibleFileTypeCombo = this.fileTypeCombo.getAccessible();
        Accessible accessibleSkeletonButton = this._skeletonButton.getAccessible();
        Accessible accessibleSampleButton = this._sampleButton.getAccessible();
        Accessible accessibleFileGroup = this._fileSelectionGroup.getAccessible();
        accessibleProjectNameLabel.addRelation(8, accessibleProjectNameCombo);
        accessibleProjectNameCombo.addRelation(9, accessibleProjectNameLabel);
        accessibleVersionLabel.addRelation(8, accessibleVersionCombo);
        accessibleVersionCombo.addRelation(9, accessibleVersionLabel);
        accessibleFileTypeCombo.addRelation(9, accessibleFileTypeComboLabel);
        accessibleFileTypeCombo.addRelation(2, accessibleFileGroup);
        accessibleVersionCombo.addRelation(2, accessibleFileGroup);
        accessibleSkeletonButton.addRelation(10, accessibleFileGroup);
        accessibleSkeletonButton.addRelation(9, accessibleFileGroup);
        accessibleSampleButton.addRelation(10, accessibleFileGroup);
        accessibleSampleButton.addRelation(9, accessibleFileGroup);
    }

    private void createProjectGroup(Composite parent) {
        List<IProject> projects;
        GridData data = new GridData();
        this.projectNameLabel = new Label(parent, 0);
        this.projectNameLabel.setText(SwaggerUIMessages.Project_LABEL);
        this.projectNameLabel.setLayoutData((Object)data);
        data = new GridData(256);
        data.widthHint = 300;
        data.horizontalSpan = 2;
        this.projectNameCombo = new Combo(parent, 2056);
        this.projectNameCombo.setLayoutData((Object)data);
        String initialVersion = "3.0";
        if (this.project != null && ProjectUtils.isLibertyProject(this.project)) {
            projects = ProjectUtils.getAllValidLibertyProjects();
        } else {
            projects = ProjectUtils.getAllValidProjects();
            initialVersion = "2.0";
        }
        String[] names = new String[projects.size()];
        int i = 0;
        for (IProject proj : projects) {
            names[i++] = proj.getName();
        }
        this.projectNameCombo.setItems(names);
        if (this.project != null && ProjectUtils.isValidProject(this.project)) {
            this.projectNameCombo.setText(this.project.getName());
        } else if (names.length > 0) {
            this.projectNameCombo.select(0);
        }
        this.projectNameCombo.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent arg0) {
                IProject project;
                Combo combo = (Combo)arg0.getSource();
                if (combo.getSelectionIndex() >= 0 && (project = ResourcesPlugin.getWorkspace().getRoot().getProject(combo.getText())) != null) {
                    SwaggerFileWizardPageOne.this.setProject(project);
                    SwaggerFileWizardPageOne.this.validatePage();
                }
            }

            public void widgetDefaultSelected(SelectionEvent arg0) {
            }
        });
        data = new GridData();
        this.versionLabel = new Label(parent, 0);
        this.versionLabel.setText(SwaggerUIMessages.Version_LABEL);
        this.versionLabel.setLayoutData((Object)data);
        data = new GridData(256);
        data.horizontalSpan = 1;
        this.versionCombo = new Combo(parent, 2056);
        this.versionCombo.setToolTipText(SwaggerUIMessages.Version_TOOLTIP);
        this.versionCombo.setLayoutData((Object)data);
        this.versionCombo.add("2.0");
        this.versionCombo.add("3.0");
        this.versionCombo.setText(initialVersion);
        this._specVersion = initialVersion;
        this.versionCombo.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent arg0) {
                Combo combo = (Combo)arg0.getSource();
                if (combo != null && combo.getSelectionIndex() >= 0) {
                    String previousVersion = SwaggerFileWizardPageOne.this._specVersion;
                    SwaggerFileWizardPageOne.this._specVersion = combo.getText();
                    if (!previousVersion.equals(SwaggerFileWizardPageOne.this._specVersion)) {
                        String currentSelectedProject = SwaggerFileWizardPageOne.this.projectNameCombo.getText();
                        if ("3.0".equals(SwaggerFileWizardPageOne.this._specVersion)) {
                            boolean doChanges = true;
                            List<IProject> projects = ProjectUtils.getAllValidLibertyProjects();
                            String[] names = new String[projects.size()];
                            int i = 0;
                            boolean listHasPriorSelection = false;
                            for (IProject project : projects) {
                                names[i++] = project.getName();
                                if (!project.getName().equals(currentSelectedProject)) continue;
                                listHasPriorSelection = true;
                            }
                            if (listHasPriorSelection) {
                                SwaggerFileWizardPageOne.this.projectNameCombo.setItems(names);
                                SwaggerFileWizardPageOne.this.projectNameCombo.setText(currentSelectedProject);
                            } else {
                                boolean open = MessageDialog.open((int)6, (Shell)SwaggerFileWizardPageOne.this.getShell(), (String)SwaggerUIMessages.WarningVersionChanged, (String)SwaggerUIMessages.bind((String)SwaggerUIMessages.OpenAPI30SupportOnTWAS, (Object)currentSelectedProject), (int)0);
                                if (open) {
                                    SwaggerFileWizardPageOne.this.projectNameCombo.setItems(names);
                                    if (projects.size() > 0) {
                                        SwaggerFileWizardPageOne.this.projectNameCombo.select(0);
                                    }
                                } else {
                                    doChanges = false;
                                }
                            }
                            if (doChanges) {
                                SwaggerFileWizardPageOne.this.updateOpenApiFileType();
                                SwaggerFileWizardPageOne.this._topLevelLocationButton.setSelection(true);
                                SwaggerFileWizardPageOne.this._stubLocationButton.setSelection(false);
                                SwaggerFileWizardPageOne.this._genTopLevel = true;
                                SwaggerFileWizardPageOne.this._stubLocationButton.setEnabled(false);
                            } else {
                                SwaggerFileWizardPageOne.this._specVersion = previousVersion;
                                SwaggerFileWizardPageOne.this.versionCombo.setText(previousVersion);
                            }
                        } else if ("2.0".equals(SwaggerFileWizardPageOne.this._specVersion)) {
                            SwaggerFileWizardPageOne.this.updateOpenApiFileType();
                            SwaggerFileWizardPageOne.this._stubLocationButton.setEnabled(true);
                            List<IProject> projects = ProjectUtils.getAllValidProjects();
                            String[] names = new String[projects.size()];
                            int i = 0;
                            for (IProject project : projects) {
                                names[i++] = project.getName();
                            }
                            SwaggerFileWizardPageOne.this.projectNameCombo.setItems(names);
                            SwaggerFileWizardPageOne.this.projectNameCombo.setText(currentSelectedProject);
                        }
                        SwaggerFileWizardPageOne.this.versionCombo.getAccessible().sendEvent(32781, null);
                        SwaggerFileWizardPageOne.this._fileSelectionGroup.layout(true);
                        SwaggerFileWizardPageOne.this.validatePage();
                    }
                }
            }

            public void widgetDefaultSelected(SelectionEvent arg0) {
            }
        });
        new Label(parent, 0);
        data = new GridData();
        this.fileTypeComboLabel = new Label(parent, 0);
        this.fileTypeComboLabel.setText(SwaggerUIMessages.SWAGGER_FILE_TYPE_LABEL);
        this.fileTypeComboLabel.setToolTipText(SwaggerUIMessages.SWAGGER_FILE_TYPE_COMBO_TOOLTIP);
        this.fileTypeComboLabel.setLayoutData((Object)data);
        data = new GridData(256);
        data.horizontalSpan = 1;
        this.fileTypeCombo = new Combo(parent, 2056);
        this.fileTypeCombo.setToolTipText(SwaggerUIMessages.SWAGGER_FILE_TYPE_COMBO_TOOLTIP);
        this.fileTypeCombo.setLayoutData((Object)data);
        this.fileTypeCombo.add("json".toUpperCase());
        this.fileTypeCombo.add("yaml".toUpperCase());
        this.fileTypeCombo.select(0);
        this.fileTypeCombo.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent arg0) {
                SwaggerFileWizardPageOne.this.updateOpenApiFileType();
                SwaggerFileWizardPageOne.this.fileTypeCombo.getAccessible().sendEvent(32781, null);
            }

            public void widgetDefaultSelected(SelectionEvent arg0) {
            }
        });
        new Label(parent, 0);
    }

    private void updateOpenApiFileType() {
        if ("2.0".equals(this._specVersion)) {
            String fileName;
            if ("yaml".equalsIgnoreCase(this.fileTypeCombo.getText())) {
                fileName = "swagger.yaml";
                this._isJson = false;
            } else {
                fileName = "swagger.json";
                this._isJson = true;
            }
            this._skeletonButton.setText(NLS.bind((String)SwaggerUIMessages.GenerateSkeletonFile_LABEL, (Object)fileName));
            this._skeletonButton.setToolTipText(NLS.bind((String)SwaggerUIMessages.GenerateSkeletonFile_TOOLTIP, (Object)fileName));
            this._sampleButton.setText(NLS.bind((String)SwaggerUIMessages.GenerateSampleFile_LABEL, (Object)fileName));
            this._sampleButton.setToolTipText(NLS.bind((String)SwaggerUIMessages.GenerateSampleFile_TOOLTIP, (Object)fileName));
        } else {
            String fileName;
            if ("yaml".equalsIgnoreCase(this.fileTypeCombo.getText())) {
                fileName = "openapi.yaml";
                this._isJson = false;
            } else {
                fileName = "openapi.json";
                this._isJson = true;
            }
            this._skeletonButton.setText(NLS.bind((String)SwaggerUIMessages.GenerateAnOpenApiSkeletonFile_LABEL, (Object)fileName));
            this._skeletonButton.setToolTipText(NLS.bind((String)SwaggerUIMessages.GenerateAnOpenApiSkeletonFile_TOOLTIP, (Object)fileName));
            this._sampleButton.setText(NLS.bind((String)SwaggerUIMessages.GenerateAnOpenApiSampleFile_LABEL, (Object)fileName));
            this._sampleButton.setToolTipText(NLS.bind((String)SwaggerUIMessages.GenerateAnOpenApiSampleFile_TOOLTIP, (Object)fileName));
        }
    }

    private void createFileSelectionGroup(Composite composite) {
        this._fileSelectionGroup = new Group(composite, 16);
        this._fileSelectionGroup.setText(SwaggerUIMessages.TemplateOptions);
        this._fileSelectionGroup.setLayout((Layout)new GridLayout(3, false));
        GridData gd = new GridData(768);
        gd.horizontalSpan = 3;
        this._fileSelectionGroup.setLayoutData((Object)gd);
        GridData radioButtonGridData = new GridData(4, 4, true, true);
        radioButtonGridData.horizontalSpan = 3;
        radioButtonGridData.grabExcessHorizontalSpace = true;
        this._skeletonButton = new Button((Composite)this._fileSelectionGroup, 16);
        this._skeletonButton.setLayoutData((Object)radioButtonGridData);
        this._skeletonButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                SwaggerFileWizardPageOne.this._genTemplate = SwaggerFileWizardPageOne.this._skeletonButton.getSelection();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this._skeletonButton.setSelection(true);
        this._sampleButton = new Button((Composite)this._fileSelectionGroup, 16);
        this._sampleButton.setLayoutData((Object)radioButtonGridData);
        this._sampleButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent arg0) {
                SwaggerFileWizardPageOne.this._genTemplate = !SwaggerFileWizardPageOne.this._sampleButton.getSelection();
            }

            public void widgetDefaultSelected(SelectionEvent arg0) {
            }
        });
        this.updateOpenApiFileType();
    }

    private void createLocationSelectionGroup(Composite composite) {
        this._locationSelectionGroup = new Group(composite, 16);
        this._locationSelectionGroup.setText(SwaggerUIMessages.SwaggerFileLocationLabel);
        this._locationSelectionGroup.setLayout((Layout)new GridLayout(3, false));
        GridData gd = new GridData(768);
        gd.horizontalSpan = 3;
        this._locationSelectionGroup.setLayoutData((Object)gd);
        GridData gd2 = new GridData();
        gd2.horizontalSpan = 3;
        gd2.grabExcessHorizontalSpace = true;
        this._topLevelLocationButton = new Button((Composite)this._locationSelectionGroup, 16);
        this._topLevelLocationButton.setText(SwaggerUIMessages.SwaggerFileLocationTopLevel);
        this._topLevelLocationButton.setToolTipText(SwaggerUIMessages.SwaggerFileLocationTopLevelToolTip);
        this._topLevelLocationButton.setLayoutData((Object)gd2);
        this._topLevelLocationButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                SwaggerFileWizardPageOne.this._genTopLevel = SwaggerFileWizardPageOne.this._topLevelLocationButton.getSelection();
                SwaggerFileWizardPageOne.this.validatePage();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this._topLevelLocationButton.setSelection(true);
        GridData gd3 = new GridData();
        gd3.horizontalSpan = 3;
        gd3.grabExcessHorizontalSpace = true;
        this._stubLocationButton = new Button((Composite)this._locationSelectionGroup, 16);
        this._stubLocationButton.setText(SwaggerUIMessages.SwaggerFileLocationStub);
        this._stubLocationButton.setToolTipText(SwaggerUIMessages.SwaggerFileLocationStubToolTip);
        this._stubLocationButton.setLayoutData((Object)gd3);
        this._stubLocationButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent arg0) {
                SwaggerFileWizardPageOne.this._genTopLevel = !SwaggerFileWizardPageOne.this._stubLocationButton.getSelection();
                SwaggerFileWizardPageOne.this.validatePage();
            }

            public void widgetDefaultSelected(SelectionEvent arg0) {
            }
        });
        this._topLevelLocationButton.setSelection(true);
    }

    public void setProject(IProject project) {
        this.project = project;
    }

    public boolean genTemplate() {
        return this._genTemplate;
    }

    public boolean genAsTopLevel() {
        return this._genTopLevel;
    }

    public IProject getProject() {
        return this.project;
    }

    public String getOpenApiVersion() {
        return this._specVersion;
    }

    public boolean fileTypeIsJson() {
        return this._isJson;
    }

    public void validatePage() {
        IProject proj = this.getProject();
        String msg = null;
        if (proj != null) {
            String[] conflictingFiles;
            boolean isV20 = "2.0".equals(this._specVersion);
            List existingFiles = AbstractFileHandler.getExistingFiles((boolean)isV20, (IProject)proj);
            IFile conflictingFile = AbstractFileHandler.getFileEndingWith((List)existingFiles, (String[])(conflictingFiles = isV20 && !this.genAsTopLevel() ? SwaggerFileHandler.getStubFileLocations() : (isV20 && this.genAsTopLevel() ? SwaggerFileHandler.getTopLevelFileLocations() : OpenApiFileHandler.getPossibleFileLocations())));
            if (conflictingFile != null) {
                String fileLocation = conflictingFile.getParent().getProjectRelativePath().toPortableString();
                String fileName = conflictingFile.getName();
                msg = isV20 ? NLS.bind((String)SwaggerUIMessages.SwaggerFileExists, (Object)fileName, (Object)fileLocation) : NLS.bind((String)SwaggerUIMessages.AnOpenSpecFileExists, (Object)fileName, (Object)fileLocation);
                this.setErrorMessage(msg);
            } else {
                msg = null;
                this.setErrorMessage(null);
                this._fileSelectionGroup.setEnabled(true);
                this._skeletonButton.setEnabled(true);
                this._sampleButton.setEnabled(true);
                this.setMessage(SwaggerUIMessages.SwaggerFileDialogDescription);
            }
        }
        this.setPageComplete(proj != null && msg == null);
    }
}

