/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.swagger.rest.api.ui.wizards;

import com.ibm.etools.swagger.rest.api.ui.SwaggerUIMessages;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Monitor;
import org.eclipse.swt.widgets.Shell;

public class SwaggerFileSelectionDialog
extends TitleAreaDialog {
    protected String _title;
    protected String _message;
    protected Button _skeletonButton;
    protected Button _sampleButton;
    private Composite _parent = null;
    private boolean genTemplate = true;

    public SwaggerFileSelectionDialog(Shell parentShell, String title, String message) {
        super(parentShell);
        this._title = title;
        this._message = message;
        this.setShellStyle(0x10870 | SwaggerFileSelectionDialog.getDefaultOrientation());
    }

    public void create() {
        super.create();
        this.setTitle(this._title);
        this.setMessage(this._message);
        this._parent.getShell().setSize(600, 300);
        Display display = Display.getCurrent();
        Monitor monitor = display.getActiveShell().getMonitor();
        Rectangle monitorRect = monitor.getBounds();
        Rectangle shellRect = this._parent.getShell().getBounds();
        int x = monitorRect.x + (monitorRect.width - shellRect.width) / 2;
        int y = monitorRect.y + (monitorRect.height - shellRect.height) / 3;
        this._parent.getShell().setLocation(x, y);
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(this._title);
    }

    protected Control createDialogArea(Composite composite) {
        this._parent = (Composite)super.createDialogArea(composite);
        GridData gd = new GridData(1808);
        gd.widthHint = 500;
        this._parent.setLayoutData((Object)gd);
        GridLayout gl = new GridLayout();
        gl.marginHeight = 10;
        gl.marginWidth = 10;
        this._parent.setLayout((Layout)gl);
        this._skeletonButton = new Button(this._parent, 16);
        this._skeletonButton.setText(NLS.bind((String)SwaggerUIMessages.GenerateSkeletonFile_LABEL, (Object)"swagger.json"));
        this._skeletonButton.setToolTipText(NLS.bind((String)SwaggerUIMessages.GenerateSkeletonFile_TOOLTIP, (Object)"swagger.json"));
        this._skeletonButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                SwaggerFileSelectionDialog.this.genTemplate = SwaggerFileSelectionDialog.this._skeletonButton.getSelection();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this._sampleButton = new Button(this._parent, 16);
        this._sampleButton.setText(NLS.bind((String)SwaggerUIMessages.GenerateSampleFile_LABEL, (Object)"swagger.json"));
        this._sampleButton.setToolTipText(NLS.bind((String)SwaggerUIMessages.GenerateSampleFile_TOOLTIP, (Object)"swagger.json"));
        this._sampleButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent arg0) {
                SwaggerFileSelectionDialog.this.genTemplate = !SwaggerFileSelectionDialog.this._sampleButton.getSelection();
            }

            public void widgetDefaultSelected(SelectionEvent arg0) {
            }
        });
        return this._parent;
    }

    public void cancelPressed() {
        this.genTemplate = true;
        super.cancelPressed();
    }

    public boolean genTemplateFile() {
        return this.genTemplate;
    }
}

