/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.swagger.rest.api.ui.validation;

import com.ibm.etools.openapi.core.util.AbstractFileHandler;
import com.ibm.etools.openapi.core.util.SwaggerFileHandler;
import com.ibm.etools.swagger.rest.api.ui.SwaggerUIPlugin;
import com.ibm.etools.swagger.rest.api.ui.validation.Messages;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.validation.AbstractValidator;
import org.eclipse.wst.validation.ValidationResult;
import org.eclipse.wst.validation.ValidationState;
import org.eclipse.wst.validation.ValidatorMessage;

public class StubValidator
extends AbstractValidator {
    private static final String SWAGGER_VALIDATOR_MARKER = "com.ibm.etools.restapi.documentation.swagger.ui.SwaggerStubValidatorMarker";
    private ValidationResult _result;
    private IResource _res;

    public ValidationResult validate(IResource resource, int kind, ValidationState state, IProgressMonitor monitor) {
        this._res = resource;
        this._result = new ValidationResult();
        IProject proj = resource.getProject();
        if (proj != null) {
            try {
                this._res.deleteMarkers(SWAGGER_VALIDATOR_MARKER, true, 0);
                if (SwaggerFileHandler.anyStubFileExists((IProject)proj) && SwaggerFileHandler.anyTopLevelFileExists((IProject)proj) && SwaggerFileHandler.isSwaggerFile((IResource)this._res)) {
                    List existingFiles = AbstractFileHandler.getExistingFiles((boolean)true, (IProject)proj);
                    IFile topLevelFile = AbstractFileHandler.getFileEndingWith((List)existingFiles, (String[])SwaggerFileHandler.getTopLevelFileLocations());
                    String msg = NLS.bind((String)Messages.StubValidatorBothFiles, (Object)topLevelFile.getProjectRelativePath().toPortableString());
                    this._result.add(this.setWarningMarker(msg, 2));
                }
            }
            catch (CoreException e) {
                SwaggerUIPlugin.logError(e);
            }
        }
        return this._result;
    }

    private ValidatorMessage setWarningMarker(String validationMessage, int lineNumber) {
        ValidatorMessage msg = ValidatorMessage.create((String)validationMessage, (IResource)this._res);
        msg.setType(SWAGGER_VALIDATOR_MARKER);
        msg.setAttribute("severity", 1);
        msg.setAttribute("lineNumber", lineNumber);
        return msg;
    }
}

