/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.swagger.rest.api.ui.validation;

import com.ibm.etools.swagger.rest.api.ui.SwaggerUIMessages;
import com.ibm.etools.webtools.json.internal.core.model.JSONArray;
import com.ibm.etools.webtools.json.internal.core.model.JSONBoolean;
import com.ibm.etools.webtools.json.internal.core.model.JSONElement;
import com.ibm.etools.webtools.json.internal.core.model.JSONObject;
import com.ibm.etools.webtools.json.internal.core.model.JSONString;
import com.ibm.etools.webtools.json.internal.core.syntax.Parser;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Scanner;
import java.util.StringTokenizer;
import javax.activation.MimeType;
import javax.activation.MimeTypeParseException;
import org.eclipse.core.filebuffers.FileBuffers;
import org.eclipse.core.filebuffers.ITextFileBuffer;
import org.eclipse.core.filebuffers.ITextFileBufferManager;
import org.eclipse.core.filebuffers.LocationKind;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.validation.AbstractValidator;
import org.eclipse.wst.validation.ValidationEvent;
import org.eclipse.wst.validation.ValidationResult;
import org.eclipse.wst.validation.ValidationState;
import org.eclipse.wst.validation.ValidatorMessage;
import org.osgi.framework.Version;

public class OpenApiValidator
extends AbstractValidator {
    ArrayList<String> _uniqueOperationId;
    public static final String OPENAPI_VALIDATOR_MARKER = "com.ibm.etools.restapi.documentation.swagger.ui.OpenApiValidatorMarker";
    protected IResource _res;
    protected ValidationResult _result;
    private boolean filenameIsStandard = false;

    public ValidationResult validate(ValidationEvent event, ValidationState state, IProgressMonitor monitor) {
        this._uniqueOperationId = new ArrayList();
        this._result = new ValidationResult();
        this._res = event.getResource();
        JSONObject model = null;
        Parser parser = new Parser();
        ITextFileBufferManager manager = FileBuffers.getTextFileBufferManager();
        IPath path = this._res.getFullPath();
        if (this._res.getName().endsWith("openapi.json")) {
            this.filenameIsStandard = true;
        }
        try {
            String s;
            this._res.deleteMarkers(OPENAPI_VALIDATOR_MARKER, true, 0);
            manager.connect(path, LocationKind.IFILE, null);
            ITextFileBuffer buffer = manager.getTextFileBuffer(path, LocationKind.IFILE);
            if (buffer != null && (s = buffer.getDocument().get()).length() > 0) {
                char[] contents = s.toCharArray();
                model = (JSONObject)parser.parse(contents);
                this.validateTopLevelElements(model.getPairs());
                this.validateElementsInObjects(model.getPairs());
            }
            manager.disconnect(path, LocationKind.IFILE, null);
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        return this._result;
    }

    protected void validateTopLevelElements(List<JSONElement> elements) {
        Iterator<JSONElement> elemIter = elements.iterator();
        boolean hasOpenapi = false;
        boolean hasInfo = false;
        boolean hasPaths = false;
        while (elemIter.hasNext()) {
            String nodeName;
            block9: {
                JSONElement elementNode = elemIter.next();
                nodeName = elementNode.getName();
                if (nodeName.equals("\"openapi\"")) {
                    hasOpenapi = true;
                    String value = elementNode.getValue();
                    try {
                        Version parseVersion = Version.parseVersion((String)value.replace('\"', ' '));
                        if (parseVersion.compareTo(new Version("3.0.0")) != 0) {
                            this._result.add(this.setErrorMarker(SwaggerUIMessages.OpenApiWrongVersion, elementNode.getLineNumber()));
                        }
                    }
                    catch (Exception e) {
                        if (value.equals("\"3.0\"")) break block9;
                        this._result.add(this.setErrorMarker(SwaggerUIMessages.OpenApiWrongVersion, elementNode.getLineNumber()));
                    }
                }
            }
            if (nodeName.equals("\"info\"")) {
                hasInfo = true;
            }
            if (!nodeName.equals("\"paths\"")) continue;
            hasPaths = true;
        }
        if (!hasOpenapi && this.filenameIsStandard) {
            this._result.add(this.setErrorMarker(SwaggerUIMessages.OpenApiRequired, 2));
        }
        if (!hasInfo) {
            this._result.add(this.setErrorMarker(SwaggerUIMessages.InfoRequired, 2));
        }
        if (!hasPaths) {
            this._result.add(this.setErrorMarker(SwaggerUIMessages.PathsRequired, 2));
        }
    }

    protected ValidatorMessage setErrorMarker(String validationMessage, int lineNumber) {
        ValidatorMessage msg = ValidatorMessage.create((String)validationMessage, (IResource)this._res);
        msg.setType(OPENAPI_VALIDATOR_MARKER);
        msg.setAttribute("severity", 2);
        msg.setAttribute("lineNumber", lineNumber);
        return msg;
    }

    private void validateElementsInObjects(List<JSONElement> elements) {
        for (JSONElement elementNode : elements) {
            String parentName;
            String nodeName = elementNode.getName();
            JSONElement parentNode = elementNode.getParent();
            boolean isTopLevel = parentNode == null || parentNode.getParent() == null;
            if (nodeName.equals("\"components\"")) continue;
            if (nodeName.equals("\"info\"") && isTopLevel) {
                this.validateInfoObject(elementNode);
            } else if (nodeName.equals("\"tags\"")) {
                if (elementNode instanceof JSONArray) {
                    Iterator tagObjIter = ((JSONArray)elementNode).getElements().iterator();
                    ArrayList<String> uniqueTagNames = new ArrayList<String>();
                    while (tagObjIter.hasNext()) {
                        JSONElement tagObj = (JSONElement)tagObjIter.next();
                        if (!(tagObj instanceof JSONObject)) continue;
                        if (!this.hasRequiredField("\"name\"", ((JSONObject)tagObj).getPairs())) {
                            this._result.add(this.setErrorMarker(SwaggerUIMessages.TagNameRequired, tagObj.getLineNumber()));
                        } else {
                            this.validateUniqueTagName(((JSONObject)tagObj).getPairs(), uniqueTagNames);
                        }
                        this.validateElementsInObjects(((JSONObject)tagObj).getPairs());
                    }
                }
            } else if (nodeName.equals("\"externalDocs\"")) {
                if (elementNode instanceof JSONObject && !this.hasRequiredField("\"url\"", ((JSONObject)elementNode).getPairs())) {
                    this._result.add(this.setErrorMarker(SwaggerUIMessages.ExternalDocURLRequired, elementNode.getLineNumber()));
                }
            } else if (nodeName.equals("\"license\"")) {
                if (elementNode instanceof JSONObject && !this.hasRequiredField("\"name\"", ((JSONObject)elementNode).getPairs())) {
                    this._result.add(this.setErrorMarker(SwaggerUIMessages.LicenseNameRequired, elementNode.getLineNumber()));
                }
            } else if (nodeName.equals("\"host\"") && isTopLevel) {
                String hostValue;
                if (elementNode instanceof JSONString && (hostValue = ((JSONString)elementNode).getValue()) != null) {
                    if ((hostValue = this.removeQuotes(hostValue)).contains("/")) {
                        this._result.add(this.setErrorMarker(SwaggerUIMessages.InvalidHostName, elementNode.getLineNumber()));
                    } else if (hostValue.indexOf(":") >= 0) {
                        String rightSubString = hostValue.substring(hostValue.indexOf(":") + 1);
                        Scanner scan = new Scanner(rightSubString);
                        if (!scan.hasNextInt()) {
                            this._result.add(this.setErrorMarker(SwaggerUIMessages.InvalidHostName, elementNode.getLineNumber()));
                        }
                        scan.close();
                    }
                }
            } else if (nodeName.equals("\"schemes\"")) {
                if (elementNode instanceof JSONArray) {
                    for (JSONElement schemeValue : ((JSONArray)elementNode).getElements()) {
                        String value;
                        if (!(schemeValue instanceof JSONString) || this.isValidSchemesValue(value = ((JSONString)schemeValue).getValue())) continue;
                        this._result.add(this.setErrorMarker(NLS.bind((String)SwaggerUIMessages.SchemesMustHaveValidValue, (Object)value), schemeValue.getLineNumber()));
                    }
                }
            } else if (nodeName.equals("\"content\"")) {
                if (elementNode instanceof JSONObject) {
                    this.validateMimeTypeSyntax((JSONObject)elementNode);
                }
            } else if (nodeName.equals("\"paths\"")) {
                if (elementNode instanceof JSONObject) {
                    this.validateElementsInObjects(((JSONObject)elementNode).getPairs());
                }
            } else if (nodeName.equals("\"responses\"")) {
                if (elementNode instanceof JSONObject) {
                    List responses = ((JSONObject)elementNode).getPairs();
                    if (responses.isEmpty()) {
                        this._result.add(this.setErrorMarker(SwaggerUIMessages.MissingResponseObject, elementNode.getLineNumber()));
                    } else {
                        Iterator respIter = responses.iterator();
                        int validResponse = 0;
                        while (respIter.hasNext()) {
                            JSONElement response = (JSONElement)respIter.next();
                            if (!(response instanceof JSONObject)) continue;
                            if (this.isValidResponseObject((JSONObject)response)) {
                                ++validResponse;
                                if (this.hasRequiredField("\"description\"", ((JSONObject)response).getPairs())) continue;
                                this._result.add(this.setErrorMarker(NLS.bind((String)SwaggerUIMessages.ResponsesDescriptionRequired, (Object)response.getName()), response.getLineNumber()));
                                continue;
                            }
                            if (response.getName().startsWith("\"x-")) continue;
                            this._result.add(this.setErrorMarker(SwaggerUIMessages.InvalidResponseObject, response.getLineNumber()));
                        }
                        if (validResponse == 0) {
                            this._result.add(this.setErrorMarker(SwaggerUIMessages.MissingResponseObject, elementNode.getLineNumber()));
                        }
                        this.validateElementsInObjects(((JSONObject)elementNode).getPairs());
                    }
                }
            } else if (this.isOperationObject(nodeName)) {
                if (elementNode instanceof JSONObject) {
                    if (!this.hasRequiredField("\"responses\"", ((JSONObject)elementNode).getPairs())) {
                        this._result.add(this.setErrorMarker(NLS.bind((String)SwaggerUIMessages.ResponsesRequired, (Object)elementNode.getName()), elementNode.getLineNumber()));
                    }
                    this.validateElementsInObjects(((JSONObject)elementNode).getPairs());
                }
            } else if (nodeName.equals("\"operationId\"")) {
                if (elementNode instanceof JSONString) {
                    String value = ((JSONString)elementNode).getValue();
                    if (this._uniqueOperationId.contains(value)) {
                        this._result.add(this.setErrorMarker(NLS.bind((String)SwaggerUIMessages.DupOperationIds, (Object)value), elementNode.getLineNumber()));
                    } else {
                        this._uniqueOperationId.add(value);
                    }
                }
            } else if (nodeName.equals("\"parameters\"")) {
                List paramObjs;
                Iterator iter;
                if (elementNode instanceof JSONArray) {
                    iter = ((JSONArray)elementNode).getElements().iterator();
                    paramObjs = ((JSONArray)elementNode).getElements();
                } else if (elementNode instanceof JSONObject) {
                    iter = ((JSONObject)elementNode).getPairs().iterator();
                    paramObjs = ((JSONObject)elementNode).getPairs();
                } else {
                    return;
                }
                JSONElement paramObj = null;
                HashMap<String, String> uniqueParamNames = new HashMap<String, String>();
                ArrayList<String> pathParams = new ArrayList<String>();
                while (iter.hasNext()) {
                    String paramName;
                    paramObj = (JSONElement)iter.next();
                    if (!(paramObj instanceof JSONObject)) continue;
                    JSONObject param = (JSONObject)paramObj;
                    this.validateParameterObject(param, uniqueParamNames);
                    if (this.isPathParam(param) && (paramName = this.getParamName(param)) != null) {
                        pathParams.add(this.removeQuotes(paramName));
                    }
                    this.validateElementsInObjects(((JSONObject)paramObj).getPairs());
                }
                if (paramObj != null && paramObj instanceof JSONObject) {
                    this.validateMissingPathParameterDefinition(this.getPathItemObject((JSONObject)paramObj), pathParams);
                }
            } else if (nodeName.startsWith("\"headers\"")) {
                if (elementNode instanceof JSONObject) {
                    for (JSONElement header : ((JSONObject)elementNode).getPairs()) {
                        this.validateHeaderItemsParameterFields(header, null);
                    }
                    this.validateElementsInObjects(((JSONObject)elementNode).getPairs());
                }
            } else if (nodeName.startsWith("\"items\"")) {
                this.validateHeaderItemsParameterFields(elementNode, null);
                this.validateElementsInObjects(((JSONObject)elementNode).getPairs());
            } else if (nodeName.equals("\"servers\"")) {
                if (elementNode instanceof JSONArray) {
                    Iterator objIter = ((JSONArray)elementNode).getElements().iterator();
                    ArrayList<String> uniqueUrls = new ArrayList<String>();
                    while (objIter.hasNext()) {
                        JSONElement serversObj = (JSONElement)objIter.next();
                        if (!(serversObj instanceof JSONObject)) continue;
                        if (!this.hasRequiredField("\"url\"", ((JSONObject)serversObj).getPairs())) {
                            this._result.add(this.setErrorMarker(SwaggerUIMessages.ServerUrlRequired, serversObj.getLineNumber()));
                        }
                        this.validateUniqueServerUrls(((JSONObject)serversObj).getPairs(), uniqueUrls);
                    }
                    uniqueUrls.clear();
                }
            } else if (nodeName.startsWith("\"/") || nodeName.startsWith("\"x-")) {
                parentName = elementNode.getParent().getName();
                if (parentName != null && parentName.equals("\"paths\"") && elementNode instanceof JSONObject) {
                    this.validateElementsInObjects(((JSONObject)elementNode).getPairs());
                }
            } else if (elementNode instanceof JSONObject) {
                this.validateElementsInObjects(((JSONObject)elementNode).getPairs());
            }
            if (nodeName.startsWith("\"/") || (parentName = elementNode.getParent().getName()) == null || !parentName.equals("\"paths\"") || !(elementNode instanceof JSONObject)) continue;
            this._result.add(this.setErrorMarker(SwaggerUIMessages.FieldNameMustStartWithSlash, elementNode.getLineNumber()));
        }
    }

    private boolean isOperationObject(String nodeName) {
        return nodeName != null && (nodeName.equals("\"get\"") || nodeName.equals("\"put\"") || nodeName.equals("\"post\"") || nodeName.equals("\"delete\"") || nodeName.equals("\"options\"") || nodeName.equals("\"head\"") || nodeName.equals("\"options\""));
    }

    private void validateParameterObject(JSONObject param, HashMap<String, String> uniqueParams) {
        List children = param.getPairs();
        ParameterObjectState pos = this.getParameterState(children);
        if (pos.getRefObject() != null) {
            return;
        }
        if (pos.getNameObject() == null) {
            this._result.add(this.setErrorMarker(SwaggerUIMessages.ParameterNameRequired, param.getLineNumber()));
        } else {
            JSONElement inObject = pos.getInObject();
            if (inObject == null) {
                this._result.add(this.setErrorMarker(SwaggerUIMessages.ParameterInRequiredV3, param.getLineNumber()));
            } else {
                String inValue = inObject.getValue();
                if (inValue != null) {
                    String key = pos.getNameObject().getValue();
                    if (key != null) {
                        String in = uniqueParams.get(key);
                        if (in == null || !in.equals(inValue)) {
                            uniqueParams.put(key, inValue);
                        } else {
                            this._result.add(this.setErrorMarker(SwaggerUIMessages.DupParameterNames, param.getLineNumber()));
                        }
                    }
                    if (inValue.equals("\"path\"")) {
                        JSONElement nameObject = pos.getNameObject();
                        this.validatePathParam(param, nameObject.getValue(), nameObject, pos.getRequiredObject());
                    } else if (inValue.equals("\"query\"") || inValue.equals("\"header\"") || inValue.equals("\"path\"") || inValue.equals("\"cookie\"")) {
                        this.validateHeaderItemsParameterFields(inObject.getParent(), inValue);
                    } else {
                        this._result.add(this.setErrorMarker(SwaggerUIMessages.ParameterInMandatoryValuesV3, inObject.getLineNumber()));
                    }
                }
            }
        }
    }

    private void validateCollectionFormat(JSONElement collectionFormatObj, String inValue) {
        String cfValue = collectionFormatObj.getValue();
        if (!(cfValue == null || cfValue.equals("\"csv\"") || cfValue.equals("\"ssv\"") || cfValue.equals("\"tsv\"") || cfValue.equals("\"pipes\""))) {
            if (inValue == null) {
                this._result.add(this.setErrorMarker(NLS.bind((String)SwaggerUIMessages.CollectionFormatValidValuesForHeaders, (Object)cfValue), collectionFormatObj.getLineNumber()));
            } else if (!cfValue.equals("\"multi\"")) {
                this._result.add(this.setErrorMarker(NLS.bind((String)SwaggerUIMessages.CollectionFormatValidValuesForFormAndQuery, (Object)cfValue), collectionFormatObj.getLineNumber()));
            } else if (!inValue.equals("\"query\"") && !inValue.equals("\"formData\"")) {
                this._result.add(this.setErrorMarker(SwaggerUIMessages.CollectionFormatMultiValidForFormAndQuery, collectionFormatObj.getLineNumber()));
            }
        }
    }

    private ParameterObjectState getParameterState(List<JSONElement> children) {
        ParameterObjectState pos = new ParameterObjectState();
        for (JSONElement elem : children) {
            String fieldName = elem.getName();
            if (fieldName.equals("\"name\"")) {
                pos.setNameObject(elem);
            }
            if (fieldName.equals("\"in\"")) {
                pos.setInObject(elem);
            }
            if (fieldName.equals("\"schema\"")) {
                pos.setSchemaObject(elem);
            }
            if (fieldName.equals("\"allowEmptyValue\"")) {
                pos.setAllowEmptyValueObject(elem);
            }
            if (fieldName.equals("\"required\"")) {
                pos.setRequiredObject(elem);
            }
            if (fieldName.equals("\"collectionFormat\"")) {
                pos.setCollectionFormatObject(elem);
            }
            if (fieldName.equals("\"$ref\"")) {
                pos.setRefObj(elem);
            }
            if (pos.getHasNonBodyField() || !fieldName.equals("\"type\"") && !fieldName.equals("\"format\"") && !fieldName.equals("\"allowEmptyValue\"") && !fieldName.equals("\"items\"") && !fieldName.equals("\"collectionFormat\"") && !fieldName.equals("\"default\"") && !fieldName.equals("\"maximum\"") && !fieldName.equals("\"exclusiveMaximum\"") && !fieldName.equals("\"minimum\"") && !fieldName.equals("\"exclusiveMinimum\"") && !fieldName.equals("\"maxLength\"") && !fieldName.equals("\"minLength\"") && !fieldName.equals("\"pattern\"") && !fieldName.equals("\"maxItems\"") && !fieldName.equals("\"minItems\"") && !fieldName.equals("\"uniqueItems\"") && !fieldName.equals("\"enum\"") && !fieldName.equals("\"multipleOf\"")) continue;
            pos.setHasNonBodyField(true);
        }
        return pos;
    }

    private void validateHeaderItemsParameterFields(JSONElement elementNode, String inValue) {
        if (elementNode instanceof JSONObject) {
            Iterator iter = ((JSONObject)elementNode).getPairs().iterator();
            boolean hasField = false;
            boolean hasRef = false;
            boolean hasCollectionFormat = false;
            JSONElement elem = null;
            JSONElement typeElem = null;
            String typeValue = null;
            while (iter.hasNext()) {
                elem = (JSONElement)iter.next();
                String name = elem.getName();
                if (name.equals("\"type\"")) {
                    hasField = true;
                    typeValue = elem.getValue();
                    typeElem = elem;
                }
                if (name.equals("\"$ref\"")) {
                    hasRef = true;
                }
                if (!name.equals("\"collectionFormat\"")) continue;
                hasCollectionFormat = true;
                this.validateCollectionFormat(elem, inValue);
            }
            if (!hasRef) {
                String elementName = elementNode.getName();
                if (hasField) {
                    if (typeValue != null && typeValue.equals("\"array\"") && !this.hasRequiredField("\"items\"", ((JSONObject)elementNode).getPairs())) {
                        if (elementName != null) {
                            this._result.add(this.setErrorMarker(NLS.bind((String)SwaggerUIMessages.ItemsTypeRequired, (Object)elementNode.getName()), elementNode.getLineNumber()));
                        } else if (inValue != null) {
                            this._result.add(this.setErrorMarker(NLS.bind((String)SwaggerUIMessages.ItemsTypeRequired, (Object)"\"parameters\""), elementNode.getLineNumber()));
                        }
                    }
                    if (!(typeValue.equals("\"string\"") || typeValue.equals("\"integer\"") || typeValue.equals("\"number\"") || typeValue.equals("\"boolean\"") || typeValue.equals("\"array\""))) {
                        if (inValue == null) {
                            this._result.add(this.setErrorMarker(NLS.bind((String)SwaggerUIMessages.TypeValueNotSupportedForHeadersAndItems, (Object)typeValue), typeElem.getLineNumber()));
                        } else if (!typeValue.equals("\"file\"")) {
                            this._result.add(this.setErrorMarker(NLS.bind((String)SwaggerUIMessages.TypeValueNotSupportedForParameters, (Object)typeValue), typeElem.getLineNumber()));
                        } else if (!inValue.equals("\"formData\"")) {
                            this._result.add(this.setErrorMarker(NLS.bind((String)SwaggerUIMessages.FileTypeRequiresFormData, (Object)inValue), typeElem.getLineNumber()));
                        }
                    }
                }
            }
        }
    }

    private void validateInfoObject(JSONElement elementNode) {
        if (elementNode instanceof JSONObject) {
            List infoChildren = ((JSONObject)elementNode).getPairs();
            List<String> messages = this.validateRequiredInfoFields(infoChildren);
            Iterator<String> msgIter = messages.iterator();
            int lineNum = elementNode.getLineNumber();
            while (msgIter.hasNext()) {
                this._result.add(this.setErrorMarker(msgIter.next(), lineNum));
            }
            this.validateElementsInObjects(infoChildren);
        }
    }

    private List<String> validateRequiredInfoFields(List<JSONElement> elements) {
        ArrayList<String> messages = new ArrayList<String>();
        Iterator<JSONElement> it = elements.iterator();
        boolean hasTitle = false;
        boolean hasVersion = false;
        while (it.hasNext()) {
            JSONElement elementNode = it.next();
            String nodeName = elementNode.getName();
            if (elementNode instanceof JSONString) {
                if (nodeName.equals("\"title\"")) {
                    hasTitle = true;
                }
                if (!nodeName.equals("\"version\"")) continue;
                hasVersion = true;
                continue;
            }
            if (nodeName.equals("\"title\"")) {
                hasTitle = true;
                this._result.add(this.setErrorMarker(SwaggerUIMessages.InfoTitleMustBeStringType, elementNode.getLineNumber()));
            }
            if (!nodeName.equals("\"version\"")) continue;
            hasVersion = true;
            this._result.add(this.setErrorMarker(SwaggerUIMessages.InfoVersionMustBeStringType, elementNode.getLineNumber()));
        }
        if (!hasTitle) {
            messages.add(SwaggerUIMessages.InfoTitleRequired);
        }
        if (!hasVersion) {
            messages.add(SwaggerUIMessages.InfoVersionRequired);
        }
        return messages;
    }

    private void validatePathParam(JSONObject param, String pathParamName, JSONElement nameObject, JSONElement requiredObj) {
        if (requiredObj == null) {
            this._result.add(this.setErrorMarker(SwaggerUIMessages.PathParameterRequiredFieldRequired, param.getLineNumber()));
        } else if (requiredObj instanceof JSONBoolean) {
            String reqValue = requiredObj.getValue();
            if (reqValue == null || !requiredObj.getValue().equals(Boolean.TRUE.toString())) {
                this._result.add(this.setErrorMarker(SwaggerUIMessages.PathParameterRequiredValueMustBeTrue, requiredObj.getLineNumber()));
            }
        } else {
            this._result.add(this.setErrorMarker(SwaggerUIMessages.PathParameterRequiredValueMustBeTrue, param.getLineNumber()));
        }
        JSONElement pathItemObject = this.getPathItemObject(param);
        if (pathItemObject == null) {
            return;
        }
        List<String> pathParams = this.getURIPathVariable(pathItemObject);
        String normalizedParamPathName = this.removeQuotes(pathParamName);
        String pathName = pathItemObject.getName();
        if (!pathParams.contains(normalizedParamPathName)) {
            this._result.add(this.setErrorMarker(NLS.bind((String)SwaggerUIMessages.PathParameterMatchNotFound, (Object[])new String[]{pathParamName, "{" + this.removeQuotes(normalizedParamPathName) + "}", pathName}), nameObject.getLineNumber()));
        }
    }

    private JSONElement getPathItemObject(JSONObject param) {
        String pathName;
        String parentName;
        JSONElement parent = param.getParent();
        if (parent.getName().equals("\"parameters\"") && (this.isOperationObject(parentName = (parent = parent.getParent()).getName()) ? this.isValidPathName(pathName = (parent = parent.getParent()).getName()) : this.isValidPathName(parentName))) {
            return parent;
        }
        return null;
    }

    private String removeQuotes(String pathName) {
        int firstQuote = pathName.indexOf("\"");
        int lastQuote = pathName.lastIndexOf("\"");
        if (firstQuote != -1) {
            if (lastQuote != -1) {
                return pathName.substring(firstQuote + 1, lastQuote);
            }
            return pathName.substring(firstQuote + 1);
        }
        return pathName;
    }

    private boolean isValidPathName(String pathName) {
        return pathName != null && pathName.startsWith("\"/");
    }

    private boolean hasRequiredField(String requiredField, List<JSONElement> elements) {
        boolean hasField = false;
        Iterator<JSONElement> iter = elements.iterator();
        while (iter.hasNext()) {
            if (!iter.next().getName().equals(requiredField)) continue;
            hasField = true;
            break;
        }
        return hasField;
    }

    private void validateUniqueTagName(List<JSONElement> tagFields, ArrayList<String> uniqueTagNames) {
        for (JSONElement obj : tagFields) {
            if (!obj.getName().equals("\"name\"")) continue;
            String tagValue = obj.getValue();
            if (uniqueTagNames.contains(tagValue)) {
                this._result.add(this.setErrorMarker(NLS.bind((String)SwaggerUIMessages.DupTagNames, (Object)tagValue), obj.getLineNumber()));
                continue;
            }
            uniqueTagNames.add(tagValue);
        }
    }

    private void validateUniqueServerUrls(List<JSONElement> tagFields, ArrayList<String> uniqueServerUrls) {
        for (JSONElement obj : tagFields) {
            if (!obj.getName().equals("\"url\"")) continue;
            String url = obj.getValue();
            if (uniqueServerUrls.contains(url)) {
                this._result.add(this.setErrorMarker(NLS.bind((String)SwaggerUIMessages.DupServerUrls, (Object)url), obj.getLineNumber()));
                continue;
            }
            uniqueServerUrls.add(url);
        }
    }

    private boolean isValidSchemesValue(String value) {
        return value != null && (value.equals("\"http\"") || value.equals("\"https\"") || value.equals("\"ws\"") || value.equals("\"wss\""));
    }

    private void validateMimeTypeSyntax(JSONObject elementNode) {
        List pairs = elementNode.getPairs();
        if (pairs != null) {
            for (JSONElement elem : pairs) {
                String nodeName;
                String mimeString;
                if (!(elem instanceof JSONObject) || (mimeString = this.removeQuotes(nodeName = elem.getName())) == null || mimeString.isEmpty()) continue;
                try {
                    new MimeType(mimeString);
                }
                catch (MimeTypeParseException mte) {
                    this._result.add(this.setErrorMarker(SwaggerUIMessages.InvalidMimeTypeSyntax, elem.getLineNumber()));
                }
            }
        }
    }

    private boolean isValidResponseObject(JSONObject response) {
        String responseName = response.getName();
        return responseName.equals("\"default\"") || this.isValidHTTPCode(responseName);
    }

    private boolean isValidHTTPCode(String code) {
        int httpCode;
        String codeWithoutQuotes = this.removeQuotes(code);
        if ("1XX".equals(codeWithoutQuotes) || "2XX".equals(codeWithoutQuotes) || "3XX".equals(codeWithoutQuotes) || "4XX".equals(codeWithoutQuotes) || "5XX".equals(codeWithoutQuotes)) {
            return true;
        }
        Scanner codeToInt = new Scanner(codeWithoutQuotes);
        if (codeToInt.hasNextInt() && (httpCode = codeToInt.nextInt()) >= 100) {
            return true;
        }
        codeToInt.close();
        return false;
    }

    private boolean isPathParam(JSONObject paramObj) {
        String inValue;
        List children = paramObj.getPairs();
        ParameterObjectState pos = this.getParameterState(children);
        JSONElement inObj = pos.getInObject();
        return inObj != null && (inValue = inObj.getValue()).equals("\"path\"");
    }

    private String getParamName(JSONObject paramObj) {
        List children = paramObj.getPairs();
        ParameterObjectState pos = this.getParameterState(children);
        JSONElement nameObj = pos.getNameObject();
        if (nameObj != null) {
            return nameObj.getValue();
        }
        return null;
    }

    private void validateMissingPathParameterDefinition(JSONElement pathItemObject, List<String> definedParams) {
        if (pathItemObject != null) {
            List<String> pathVariables = this.getURIPathVariable(pathItemObject);
            for (String pathVariable : pathVariables) {
                if (pathVariable == null || definedParams.contains(pathVariable)) continue;
                this._result.add(this.setErrorMarker(NLS.bind((String)SwaggerUIMessages.MissingPathParam, (Object[])new Object[]{pathVariable, pathVariable}), pathItemObject.getLineNumber()));
            }
        }
    }

    private List<String> getURIPathVariable(JSONElement pathItemObject) {
        String pathName = pathItemObject.getName();
        StringTokenizer st = new StringTokenizer(this.removeQuotes(pathName), "/");
        ArrayList<String> variables = new ArrayList<String>();
        while (st.hasMoreTokens()) {
            String pathSegment = st.nextToken();
            if (!pathSegment.startsWith("{") || !pathSegment.endsWith("}")) continue;
            String opPathSegment = pathSegment.substring(1, pathSegment.length() - 1);
            variables.add(opPathSegment);
        }
        return variables;
    }

    protected class ParameterObjectState {
        JSONElement _nameObj = null;
        JSONElement _inObj = null;
        JSONElement _schemaObj = null;
        JSONElement _allowEmptyObj = null;
        JSONElement _reqObj = null;
        JSONElement _collectionFormatObj = null;
        JSONElement _refObj = null;
        boolean _hasNonBodyField = false;

        protected ParameterObjectState() {
        }

        protected void setNameObject(JSONElement obj) {
            this._nameObj = obj;
        }

        protected void setInObject(JSONElement obj) {
            this._inObj = obj;
        }

        protected void setSchemaObject(JSONElement obj) {
            this._schemaObj = obj;
        }

        protected void setAllowEmptyValueObject(JSONElement obj) {
            this._allowEmptyObj = obj;
        }

        protected void setRequiredObject(JSONElement obj) {
            this._reqObj = obj;
        }

        protected void setHasNonBodyField(boolean flag) {
            this._hasNonBodyField = flag;
        }

        protected void setCollectionFormatObject(JSONElement obj) {
            this._collectionFormatObj = obj;
        }

        protected void setRefObj(JSONElement obj) {
            this._refObj = obj;
        }

        protected boolean getHasNonBodyField() {
            return this._hasNonBodyField;
        }

        protected JSONElement getNameObject() {
            return this._nameObj;
        }

        protected JSONElement getInObject() {
            return this._inObj;
        }

        protected JSONElement getSchemaObject() {
            return this._schemaObj;
        }

        protected JSONElement getAllowEmptyValueObject() {
            return this._allowEmptyObj;
        }

        protected JSONElement getRequiredObject() {
            return this._reqObj;
        }

        protected JSONElement getCollectionFormatObject() {
            return this._collectionFormatObj;
        }

        protected JSONElement getRefObject() {
            return this._refObj;
        }
    }
}

