/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.swagger.rest.api.ui.commands;

import com.ibm.etools.openapi.core.OpenAPICorePlugin;
import com.ibm.etools.swagger.rest.api.ui.SwaggerUIPlugin;
import com.ibm.etools.swagger.rest.api.ui.util.ProjectUtils;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jst.ws.internal.common.J2EEUtils;
import org.eclipse.wst.command.internal.env.core.common.StatusUtils;
import org.eclipse.wst.common.frameworks.datamodel.AbstractDataModelOperation;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;

public class SwaggerCodeGenDefaultingCommand
extends AbstractDataModelOperation {
    IStructuredSelection initialSelection;
    private IProject initialProject;
    private List<String> validTargetPaths;
    private List<IJavaProject> availableWebProjects;
    private List<String> validTargetPathsForProject;
    private IFile swaggerJsonFile;
    private String swaggerJsonFilePath;
    private String targetPackage;
    private List<URL> jarsToCopy;

    public SwaggerCodeGenDefaultingCommand() {
    }

    public SwaggerCodeGenDefaultingCommand(IDataModel model) {
        super(model);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IStatus execute(IProgressMonitor arg0, IAdaptable arg1) throws ExecutionException {
        try {
            this.availableWebProjects = ProjectUtils.getAvailableWebProjects(this.initialProject);
            if (this.initialProject != null && J2EEUtils.isWebComponent((IProject)this.initialProject) && this.availableWebProjects.contains(this.initialProject)) {
                this.validTargetPaths = ProjectUtils.getAllValidTargetPaths(this.initialProject);
                this.validTargetPathsForProject = ProjectUtils.getValidTargetPathForProject(ProjectUtils.getJavaProject(this.initialProject));
            } else {
                this.initialProject = null;
            }
        }
        catch (JavaModelException e) {
            SwaggerUIPlugin.logError("Problem getting source folders", e);
            IStatus iStatus = StatusUtils.errorStatus((Throwable)e);
            return iStatus;
        }
        this.jarsToCopy = new ArrayList<URL>();
        Enumeration findEntries = OpenAPICorePlugin.getDefault().getBundle().findEntries("openAPI/runtime/", "*.jar", false);
        while (findEntries.hasMoreElements()) {
            URL nextElement = (URL)findEntries.nextElement();
            this.jarsToCopy.add(nextElement);
        }
        this.targetPackage = "";
        String defaultTargetPackage = SwaggerUIPlugin.getDefault().getPreferenceStore().getDefaultString("com.ibm.etools.restapi.documentation.swagger.ui.targetpackage");
        if (defaultTargetPackage != null && defaultTargetPackage.length() > 0) {
            this.targetPackage = defaultTargetPackage;
        }
        return Status.OK_STATUS;
    }

    public IStructuredSelection getInitialSelection() {
        return this.initialSelection;
    }

    public void setInitialSelection(IStructuredSelection initialSelection) {
        this.initialSelection = initialSelection;
        try {
            if (initialSelection != null && !initialSelection.isEmpty()) {
                Object firstElement = initialSelection.getFirstElement();
                if (firstElement instanceof IFile) {
                    IFile aFile = (IFile)firstElement;
                    if (aFile.getFileExtension().toLowerCase().equals("json") || aFile.getFileExtension().toLowerCase().equals("yaml")) {
                        this.swaggerJsonFile = (IFile)firstElement;
                        this.swaggerJsonFilePath = this.swaggerJsonFile.getFullPath().toString();
                    }
                    this.initialProject = this.swaggerJsonFile.getProject();
                } else if (firstElement instanceof IProject) {
                    this.initialProject = (IProject)firstElement;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public List<String> getAllValidTargetPaths() {
        return this.validTargetPaths;
    }

    public IProject getInitialProject() {
        return this.initialProject;
    }

    public IFile getSwaggerJsonFile() {
        return this.swaggerJsonFile;
    }

    public String getSwaggerJsonFilePath() {
        return this.swaggerJsonFilePath;
    }

    public List<IJavaProject> getAvailableJavaProjects() {
        return this.availableWebProjects;
    }

    public List<String> getValidTargetPathsForProject() {
        return this.validTargetPathsForProject;
    }

    public List<URL> getJarsToCopy() {
        return this.jarsToCopy;
    }

    public void setJarsToCopy(List<URL> jarsToCopy) {
        this.jarsToCopy = jarsToCopy;
    }

    public String getTargetPackage() {
        return this.targetPackage;
    }
}

