/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.swagger.rest.api.ui.commands;

import com.ibm.etools.openapi.core.commands.CommandRunner;
import com.ibm.etools.swagger.rest.api.ui.SwaggerUILogger;
import com.ibm.etools.swagger.rest.api.ui.commands.AbstractSwaggerCodeGenCommand;
import java.util.List;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.osgi.framework.Version;

public class SwaggerCodeGenCommand
extends AbstractSwaggerCodeGenCommand {
    private IResource swaggerGenSrcDocsFolder = null;
    private IResource swaggerGenSrcGradleWrapperFolder = null;
    private IResource swaggerGenSrcGradleFolder = null;
    private boolean srcDocsFolderExists = false;
    private boolean srcGradleWrapperFolderExists = false;
    private boolean srcGradleFolderExists = false;

    public SwaggerCodeGenCommand() {
    }

    public SwaggerCodeGenCommand(IDataModel model) {
        super(model);
    }

    @Override
    protected void populateArgsList(List<String> mainArgsList) {
        String versionOfJar;
        Version version;
        int indexOfJar;
        Object javaJaxrsClientTemplates = this.argSurround + this.pluginLocation + "openAPI/templates/jaxrsClient" + this.argSurround;
        if (this.isWindows) {
            javaJaxrsClientTemplates = ((String)javaJaxrsClientTemplates).replace("/", "\\");
        }
        mainArgsList.add("-jar");
        mainArgsList.add(this.codegenJar);
        mainArgsList.add("generate");
        mainArgsList.add("-l");
        mainArgsList.add("java");
        boolean isV222orAbove = false;
        int index = this.codegenJar.indexOf("swagger-codegen-cli-");
        if (index > 0 && (indexOfJar = this.codegenJar.indexOf(".jar")) > (index += 20) && (version = new Version(versionOfJar = this.codegenJar.substring(index, indexOfJar))).getMajor() >= 2 && version.getMinor() >= 2 && version.getMicro() >= 2) {
            isV222orAbove = true;
        }
        if (isV222orAbove) {
            mainArgsList.add("--library");
            mainArgsList.add("jersey1");
            mainArgsList.add("--additional-properties");
            mainArgsList.add("jackson=true");
        }
        mainArgsList.add("-t");
        mainArgsList.add((String)javaJaxrsClientTemplates);
        mainArgsList.add("-i");
        if (this.swaggerJsonFile != null) {
            mainArgsList.add(this.argSurround + this.swaggerJsonFile.getLocation().toOSString() + this.argSurround);
        } else if (this.externalFile != null) {
            mainArgsList.add(this.argSurround + this.externalFile.getAbsolutePath() + this.argSurround);
        } else if (this.urlOfJsonFile != null) {
            mainArgsList.add(this.urlOfJsonFile);
        }
        mainArgsList.add("-o");
        mainArgsList.add(this.argSurround + this.srcFolder.getLocation().toOSString() + this.argSurround);
        String apiPackage = this.targetPackage.equals("") ? "io.swagger.client.api" : this.targetPackage + ".api";
        String modelPackage = this.targetPackage.equals("") ? "io.swagger.client.model" : this.targetPackage + ".model";
        String dateLibraryProperty = "";
        if (isV222orAbove) {
            dateLibraryProperty = "dateLibrary=legacy,";
        }
        mainArgsList.add("-D" + dateLibraryProperty + "apiPackage=" + apiPackage + ",modelPackage=" + modelPackage + ",invokerPackage=" + this.targetPackage + ",sourceFolder=.");
        if (SwaggerUILogger.INFO) {
            int i;
            int length = mainArgsList.size();
            for (i = 0; i < length; ++i) {
                SwaggerUILogger.println("/debug/info", "SwaggerCodeGen", "execute", mainArgsList.get(i));
            }
            System.out.println("-------------------------------");
            for (i = 0; i < length; ++i) {
                System.out.print(mainArgsList.get(i) + " ");
            }
            System.out.println("\n-------------------------------");
        }
    }

    @Override
    protected CommandRunner getCommandRunner(List<String> mainArgsList) {
        return new CommandRunner(mainArgsList, "SwaggerCodeGen");
    }

    @Override
    protected void doPreExecuteSetup() {
        this.swaggerGenSrcDocsFolder = this.targetFolder.findMember("docs");
        this.swaggerGenSrcGradleWrapperFolder = this.targetFolder.findMember("gradle/wrapper");
        this.swaggerGenSrcGradleFolder = this.targetFolder.findMember("gradle");
        this.srcDocsFolderExists = this.swaggerGenSrcDocsFolder != null ? this.swaggerGenSrcDocsFolder.exists() : false;
        this.srcGradleWrapperFolderExists = this.swaggerGenSrcGradleWrapperFolder != null ? this.swaggerGenSrcGradleWrapperFolder.exists() : false;
        this.srcGradleFolderExists = this.swaggerGenSrcGradleFolder != null ? this.swaggerGenSrcGradleFolder.exists() : false;
    }

    @Override
    protected void deleteUnneededArtifacts() throws CoreException {
        this.targetFolder.refreshLocal(2, null);
        this.deleteFile(this.targetFolder, "build.gradle", null);
        this.deleteFile(this.targetFolder, "gradle.properties", null);
        this.deleteFile(this.targetFolder, "settings.gradle", null);
        this.deleteFile(this.targetFolder, "pom.xml", null);
        this.deleteFile(this.targetFolder, ".swagger-codegen-ignore", null);
        this.deleteFile(this.targetFolder, "README.md", null);
        this.deleteFile(this.targetFolder, "git_push.sh", null);
        this.deleteFile(this.targetFolder, "gradlew", null);
        this.deleteFile(this.targetFolder, "gradlew.bat", null);
        this.deleteFile(this.targetFolder, "LICENSE", null);
        String folderOfPackage = this.targetPackage.equals("") ? "io/swagger/client" : this.targetPackage.replaceAll("\\.", "/");
        this.deleteFile(this.targetFolder, folderOfPackage + "/RFC3339DateFormat.java", null);
        this.deleteFile(this.targetFolder, "build.sbt", null);
        if (!this.srcMainFolderExists) {
            this.deleteFolder(this.targetFolder, "src/main", null);
        }
        if (!this.srcFolderExists) {
            this.deleteFolder(this.targetFolder, "src", null);
        }
        if (!this.srcDocsFolderExists) {
            this.deleteFolder(this.targetFolder, "docs", null);
        }
        if (!this.srcGradleWrapperFolderExists) {
            this.deleteFolder(this.targetFolder, "gradle/wrapper", null);
        }
        if (!this.srcGradleFolderExists) {
            this.deleteFolder(this.targetFolder, "gradle", null);
        }
        this.targetFolder.refreshLocal(2, null);
    }
}

