/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.swagger.rest.api.ui.commands;

import com.ibm.etools.openapi.core.OpenAPICorePlugin;
import com.ibm.etools.openapi.core.commands.CommandRunner;
import com.ibm.etools.swagger.rest.api.ui.SwaggerUIMessages;
import com.ibm.etools.swagger.rest.api.ui.SwaggerUIPlugin;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jst.server.core.FacetUtil;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wst.command.internal.env.core.common.StatusUtils;
import org.eclipse.wst.common.frameworks.datamodel.AbstractDataModelOperation;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;
import org.eclipse.wst.server.core.IRuntime;

public abstract class AbstractSwaggerCodeGenCommand
extends AbstractDataModelOperation {
    protected String urlOfJsonFile;
    protected String targetPackage;
    protected IFile swaggerJsonFile;
    protected File externalFile;
    protected String selectedTargetSourceFolder;
    protected IFolder targetFolder = null;
    protected IResource swaggerGenSrcMainFolder = null;
    protected IResource swaggerGenSrcFolder = null;
    protected boolean srcMainFolderExists = false;
    protected boolean srcFolderExists = false;
    protected String codegenJar = null;
    protected String configJson = null;
    protected String argSurround = "";
    protected IFolder srcFolder = null;
    protected String pluginLocation = "";
    protected boolean isWindows = true;
    protected IProject project = null;

    public AbstractSwaggerCodeGenCommand() {
    }

    public AbstractSwaggerCodeGenCommand(IDataModel model) {
        super(model);
    }

    public IStatus execute(IProgressMonitor arg0, IAdaptable arg1) throws ExecutionException {
        ArrayList<String> mainArgsList = new ArrayList<String>();
        IStatus result = this.commonSetup();
        if (!result.isOK()) {
            return result;
        }
        this.populateArgsList(mainArgsList);
        result = this.doExecute(mainArgsList);
        if (!result.isOK()) {
            MessageDialog.openError((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)SwaggerUIMessages.SWAGGER_CODEGEN_ERROR_TITLE, (String)SwaggerUIMessages.SWAGGER_CODEGEN_ERROR_MSG);
        }
        return result;
    }

    protected IStatus doExecute(List<String> mainArgsList) {
        Status result = null;
        try {
            IFacetedProject facetedProject = ProjectFacetsManager.create((IProject)this.project);
            org.eclipse.wst.common.project.facet.core.runtime.IRuntime primaryRuntime = facetedProject.getPrimaryRuntime();
            if (primaryRuntime != null && result == null) {
                IRuntime runtime = FacetUtil.getRuntime((org.eclipse.wst.common.project.facet.core.runtime.IRuntime)primaryRuntime);
                CommandRunner swaggerGenRunner = this.getCommandRunner(mainArgsList);
                result = swaggerGenRunner.run(runtime);
                if (result.isOK()) {
                    this.srcFolder.refreshLocal(2, null);
                    try {
                        this.deleteUnneededArtifacts();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                return result;
            }
            if (result == null) {
                result = new Status(4, "com.ibm.etools.restapi.documentation.swagger.ui", SwaggerUIMessages.WADL_MISSING_RUNTIME_ERROR);
            }
        }
        catch (CoreException e) {
            result = new Status(4, "com.ibm.etools.restapi.documentation.swagger.ui", "SwaggerCodeGenCommand Exception", (Throwable)e);
        }
        return result;
    }

    protected abstract CommandRunner getCommandRunner(List<String> var1);

    protected abstract void populateArgsList(List<String> var1);

    protected abstract void doPreExecuteSetup();

    protected abstract void deleteUnneededArtifacts() throws CoreException;

    protected IStatus commonSetup() {
        String osName = System.getProperty("os.name").toLowerCase();
        boolean bl = this.isWindows = osName.indexOf("win") >= 0;
        if (this.isWindows) {
            this.argSurround = "\"";
        }
        try {
            URL coreURL = FileLocator.resolve((URL)OpenAPICorePlugin.getDefault().getBundle().getEntry("/"));
            this.pluginLocation = coreURL.getFile();
            if (this.isWindows && this.pluginLocation != null && this.pluginLocation.startsWith("/")) {
                this.pluginLocation = this.pluginLocation.substring(1);
            }
        }
        catch (IOException e) {
            return StatusUtils.errorStatus((Throwable)e);
        }
        String swaggerCodegenOverride = System.getProperty("com.ibm.etools.openapi.swagger.codegen.jar.path");
        this.codegenJar = swaggerCodegenOverride != null && swaggerCodegenOverride.contains("swagger-codegen") ? this.argSurround + swaggerCodegenOverride + this.argSurround : this.argSurround + this.pluginLocation + "openAPI/codegen/swagger-codegen-cli-2.4.44.jar" + this.argSurround;
        this.configJson = this.argSurround + this.pluginLocation + "openAPI/codegen/config.json" + this.argSurround;
        if (this.isWindows) {
            this.codegenJar = this.codegenJar.replace("/", "\\");
            this.configJson = this.configJson.replace("/", "\\");
        }
        this.srcFolder = (IFolder)ResourcesPlugin.getWorkspace().getRoot().findMember((IPath)new Path(this.selectedTargetSourceFolder));
        this.project = this.srcFolder.getProject();
        SwaggerUIPlugin.getDefault().getPreferenceStore().setDefault("com.ibm.etools.restapi.documentation.swagger.ui.targetpackage", this.targetPackage);
        this.targetFolder = this.srcFolder;
        this.swaggerGenSrcMainFolder = this.targetFolder.findMember("src/main");
        this.swaggerGenSrcFolder = this.targetFolder.findMember("src");
        this.srcMainFolderExists = this.swaggerGenSrcMainFolder != null ? this.swaggerGenSrcMainFolder.exists() : false;
        this.srcFolderExists = this.swaggerGenSrcFolder != null ? this.swaggerGenSrcFolder.exists() : false;
        this.doPreExecuteSetup();
        return OK_STATUS;
    }

    public void setSwaggerJsonFile(IFile swaggerJsonFile) {
        this.swaggerJsonFile = swaggerJsonFile;
    }

    public void setTargetPackage(String targetPackage) {
        this.targetPackage = targetPackage;
    }

    public void setSelectedTargetSourceFolder(String selectedTargetSourceFolder) {
        this.selectedTargetSourceFolder = selectedTargetSourceFolder;
    }

    public void setUrlOfJsonFile(String urlOfJsonFile) {
        this.urlOfJsonFile = urlOfJsonFile;
    }

    public void setExternalFile(File externalFile) {
        this.externalFile = externalFile;
    }

    protected void deleteFile(IFolder folder, String fileToDelete, IProgressMonitor pm) throws CoreException {
        IFile file = folder.getFile("./" + fileToDelete);
        if (file != null && file.exists()) {
            file.delete(true, pm);
        }
    }

    protected void deleteFolder(IFolder folder, String folderToDelete, IProgressMonitor pm) throws CoreException {
        IFolder targetFolder = folder.getFolder("./" + folderToDelete);
        if (targetFolder != null && targetFolder.exists()) {
            targetFolder.delete(true, pm);
        }
    }
}

