/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.swagger.rest.api.ui;

import java.util.Date;
import org.eclipse.osgi.service.debug.DebugOptions;
import org.eclipse.osgi.service.debug.DebugOptionsListener;

public class SwaggerUILogger
implements DebugOptionsListener {
    public static boolean ERROR = false;
    public static boolean WARNING = false;
    public static boolean INFO = false;
    public static boolean DETAILS = false;
    public static final String ERROR_LEVEL = "/debug/error";
    public static final String WARNING_LEVEL = "/debug/warning";
    public static final String INFO_LEVEL = "/debug/info";
    public static final String DETAILS_LEVEL = "/debug/details";

    public void optionsChanged(DebugOptions options) {
        ERROR = options.getBooleanOption("com.ibm.etools.restapi.documentation.swagger.ui/debug/error", false);
        WARNING = options.getBooleanOption("com.ibm.etools.restapi.documentation.swagger.ui/debug/warning", false);
        INFO = options.getBooleanOption("com.ibm.etools.restapi.documentation.swagger.ui/debug/info", false);
        DETAILS = options.getBooleanOption("com.ibm.etools.restapi.documentation.swagger.ui/debug/details", false);
    }

    public static final void println(String level, Class curClass, String methodName, String msgStr) {
        SwaggerUILogger.print(level, curClass, methodName, msgStr, null);
    }

    public static final void println(String level, Class curClass, String methodName, String msgStr, Throwable t) {
        SwaggerUILogger.print(level, curClass, methodName, msgStr, t);
    }

    public static final void println(String level, Object obj, String methodName, String msgStr) {
        Class<?> objClass = obj != null ? obj.getClass() : null;
        SwaggerUILogger.print(level, objClass, methodName, msgStr, null);
    }

    public static final void println(String level, Object obj, String methodName, String msgStr, Throwable t) {
        Class<?> objClass = obj != null ? obj.getClass() : null;
        SwaggerUILogger.print(level, objClass, methodName, msgStr, t);
    }

    private static final void print(String level, Class<?> clazz, String methodName, String msgStr, Throwable t) {
        StringBuffer printStrBuf = new StringBuffer();
        printStrBuf.append(new Date());
        printStrBuf.append(" ");
        printStrBuf.append(level);
        printStrBuf.append(" ");
        if (clazz != null) {
            printStrBuf.append(clazz.getName());
        }
        if (methodName != null) {
            printStrBuf.append(".");
            printStrBuf.append(methodName);
            printStrBuf.append(": ");
        }
        if (msgStr != null) {
            printStrBuf.append(msgStr);
        }
        System.out.println(printStrBuf.toString());
        if (t != null) {
            System.out.print(level + " " + String.valueOf(t));
            t.printStackTrace(System.out);
        }
    }
}

