/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.maven.javaee.ui.validation;

import com.ibm.etools.maven.javaee.core.project.RuntimeDependencyFactory;
import com.ibm.etools.maven.javaee.ui.JavaEEUIPlugin;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;
import org.eclipse.wst.common.project.facet.core.runtime.IRuntime;
import org.eclipse.wst.server.core.internal.facets.FacetUtil;
import org.eclipse.wst.validation.ValidationFramework;
import org.eclipse.wst.validation.ValidatorMessage;
import org.osgi.framework.Bundle;

public class MavenValidationUtility {
    public static void clearMessages(IResource resource, String validatorID) {
        try {
            if (resource instanceof IWorkspaceRoot) {
                IWorkspaceRoot root = (IWorkspaceRoot)resource;
                ValidationFramework.getDefault().clearMessages((IResource)root, validatorID);
                root.deleteMarkers(validatorID, false, 1);
            } else {
                IMarker[] markers;
                IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
                for (IMarker marker : markers = root.findMarkers(validatorID, false, 2)) {
                    IResource resourceFromMarker = marker.getResource();
                    if (resourceFromMarker instanceof IProject) {
                        if (!marker.getResource().getName().equals(resource.getName())) continue;
                        ValidationFramework.getDefault().clearMessages(resourceFromMarker, validatorID);
                        resourceFromMarker.deleteMarkers(validatorID, false, 2);
                        continue;
                    }
                    if (!resourceFromMarker.getFullPath().segment(0).toString().startsWith(resource.getFullPath().segment(0).toString())) continue;
                    ValidationFramework.getDefault().clearMessages(resourceFromMarker, validatorID);
                    resourceFromMarker.deleteMarkers(validatorID, false, 2);
                }
            }
        }
        catch (CoreException e) {
            JavaEEUIPlugin.logError(e);
        }
    }

    public static boolean hasMarker(IResource resource, String validatorID) {
        try {
            if (resource instanceof IWorkspaceRoot) {
                IWorkspaceRoot root = (IWorkspaceRoot)resource;
                IMarker[] markers = root.findMarkers(validatorID, false, 1);
                if (markers.length > 0) {
                    return true;
                }
            } else {
                IMarker[] markers;
                IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
                for (IMarker marker : markers = root.findMarkers(validatorID, false, 2)) {
                    if (marker.getResource() instanceof IProject && marker.getResource().getName().equals(resource.getName())) {
                        return true;
                    }
                    if (!marker.getResource().getFullPath().segment(0).toString().startsWith(resource.getFullPath().segment(0).toString())) continue;
                    return true;
                }
            }
        }
        catch (CoreException e) {
            JavaEEUIPlugin.logError(e);
        }
        return false;
    }

    public static ValidatorMessage createMessage(int msgSev, String message, IResource resource, String markerType, String location) {
        ValidatorMessage msg = ValidatorMessage.create((String)message, (IResource)resource);
        if (markerType != null) {
            msg.setType(markerType);
        }
        if (location != null) {
            msg.setAttribute("location", (Object)location);
        }
        msg.setAttribute("severity", msgSev);
        return msg;
    }

    public static ValidatorMessage createWarningMessage(String message, IResource resource, String markerType, String location) {
        return MavenValidationUtility.createMessage(1, message, resource, markerType, location);
    }

    public static String getServerRuntimeTypeId(IProject project) {
        org.eclipse.wst.server.core.IRuntime primaryServerRuntime = MavenValidationUtility.getPrimaryServerRuntime(project);
        if (primaryServerRuntime != null) {
            return primaryServerRuntime.getRuntimeType().getId();
        }
        return null;
    }

    public static org.eclipse.wst.server.core.IRuntime getPrimaryServerRuntime(IProject project) {
        IRuntime facetRuntime = null;
        IFacetedProject fProject = null;
        try {
            fProject = ProjectFacetsManager.create((IProject)project);
        }
        catch (CoreException e) {
            JavaEEUIPlugin.logError(e);
        }
        if (fProject != null) {
            facetRuntime = fProject.getPrimaryRuntime();
        }
        if (facetRuntime != null) {
            return FacetUtil.getRuntime((IRuntime)facetRuntime);
        }
        return null;
    }

    public static boolean isServerRuntimeSupported(IProject project) {
        org.eclipse.wst.server.core.IRuntime primaryServerRuntime = MavenValidationUtility.getPrimaryServerRuntime(project);
        return primaryServerRuntime != null && RuntimeDependencyFactory.createRuntimeDependency((org.eclipse.wst.server.core.IRuntime)primaryServerRuntime) != null;
    }

    public static boolean isActive(Bundle bundle) {
        return bundle.getState() == 32 || bundle.getState() == 4 || bundle.getState() == 8;
    }
}

