/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.maven.javaee.ui.validation;

import com.ibm.etools.maven.javaee.core.project.MavenProjectEditor;
import com.ibm.etools.maven.javaee.ui.validation.MavenValidator;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.m2e.core.MavenPlugin;
import org.eclipse.m2e.core.internal.MavenPluginActivator;
import org.eclipse.wst.common.componentcore.ModuleCoreNature;
import org.eclipse.wst.common.componentcore.internal.ModuleStructuralModel;
import org.eclipse.wst.common.componentcore.internal.ReferencedComponent;
import org.eclipse.wst.common.componentcore.internal.WorkbenchComponent;
import org.eclipse.wst.validation.ValidationResult;
import org.eclipse.wst.validation.ValidationState;
import org.osgi.framework.Version;

public class MavenSkinnyWarValidator
extends MavenValidator
implements IEclipsePreferences.IPreferenceChangeListener {
    public static final String TYPE = "com.ibm.etools.maven.javaee.ui.MavenSkinnyWarValidatorMarker";

    public ValidationResult validate(IResource resource, int kind, ValidationState state, IProgressMonitor monitor) {
        this.result = new ValidationResult();
        this.project = resource.getProject();
        if (!MavenPlugin.isMavenProject((IProject)this.project)) {
            return this.result;
        }
        MavenProjectEditor mpe = new MavenProjectEditor(this.project);
        if (mpe.isPluginConfigElementValueEqualTo("org.apache.maven.plugins:maven-ear-plugin", "skinnyWars", "true")) {
            Version m2ewtpVersion = Platform.getBundle((String)"org.eclipse.m2e.wtp").getVersion();
            Version mavenRuntimeVersion = Version.parseVersion((String)MavenPluginActivator.getDefault().getMavenRuntimeManager().getRuntime("DEFAULT").getVersion());
            Version targetM2ewtpVersion = new Version(1, 6, 1);
            Version targetMavenRuntimeVersion = new Version(3, 0, 0);
            Boolean addGroupID = m2ewtpVersion.compareTo(targetM2ewtpVersion) < 0 && mavenRuntimeVersion.compareTo(targetMavenRuntimeVersion) >= 0 && !mpe.isPluginConfigElementSpecified("org.apache.maven.plugins:maven-ear-plugin", "outputFileNameMapping");
            ModuleCoreNature mcn = ModuleCoreNature.getModuleCoreNature((IProject)this.project);
            if (mcn != null) {
                for (Resource res : mcn.getResourceSet().getResources()) {
                    for (EObject obj : res.getContents()) {
                        TreeIterator iter = obj.eAllContents();
                        while (iter.hasNext()) {
                            ReferencedComponent comp;
                            Object archiveName;
                            EObject next = (EObject)iter.next();
                            if (!(next instanceof ReferencedComponent) || !((String)(archiveName = (comp = (ReferencedComponent)next).getArchiveName())).toLowerCase().endsWith(".war") || !comp.getHandle().segments()[0].equals("resource")) continue;
                            if (addGroupID.booleanValue()) {
                                archiveName = mpe.getGroupID() + "-" + (String)archiveName;
                            }
                            ModuleStructuralModel msm = mcn.getModuleStructuralModelForWrite((Object)this);
                            WorkbenchComponent wComp = (WorkbenchComponent)comp.eContainer();
                            String newURIString = "module:/classpath/lib/" + this.project.getName() + "/target/" + wComp.getName() + "/" + (String)archiveName;
                            comp.setHandle(URI.createURI((String)newURIString));
                            msm.save((Object)this);
                        }
                    }
                }
            }
        }
        return this.result;
    }

    public void preferenceChange(IEclipsePreferences.PreferenceChangeEvent arg0) {
    }
}

