/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.maven.javaee.ui.validation;

import com.ibm.etools.maven.javaee.core.project.MavenProjectEditor;
import com.ibm.etools.maven.javaee.core.project.RuntimeDependencyFactory;
import com.ibm.etools.maven.javaee.ui.validation.MavenValidationMessages;
import com.ibm.etools.maven.javaee.ui.validation.MavenValidationUtility;
import com.ibm.etools.maven.javaee.ui.validation.MavenValidator;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;
import org.eclipse.wst.server.core.IRuntime;
import org.eclipse.wst.validation.ValidationResult;
import org.eclipse.wst.validation.ValidationState;
import org.eclipse.wst.validation.ValidatorMessage;

public class MavenJEERuntimeValidator
extends MavenValidator {
    public static final String TYPE = "com.ibm.etools.maven.javaee.ui.MavenJEERuntimeValidatorMarker";

    public ValidationResult validate(IResource resource, int kind, ValidationState state, IProgressMonitor monitor) {
        this.result = new ValidationResult();
        this.project = resource.getProject();
        if (this.supportedJavaEEMavenFacetInstalled(this.project)) {
            this.aResource = this.project.getFile("pom.xml");
            this.initializeContext();
            this.context.setResult(this.result);
            String markerID = this.context.getMarkerType();
            MavenValidationUtility.clearMessages(this.aResource, markerID);
            this.validateTargetRuntime();
        }
        return this.result;
    }

    private boolean supportedJavaEEMavenFacetInstalled(IProject project) {
        if (project == null) {
            return false;
        }
        String[] facets = new String[]{"jst.web", "jst.ejb", "jst.utility", "jst.appclient", "jst.connector", "osgi.bundle"};
        try {
            IFacetedProject factedProject = ProjectFacetsManager.create((IProject)project);
            if (factedProject != null) {
                Set installedFacets = factedProject.getProjectFacets();
                for (IProjectFacetVersion facet : installedFacets) {
                    for (int i = 0; i < facets.length; ++i) {
                        String string = facets[i];
                        if (!facet.getProjectFacet().getId().equals(string)) continue;
                        return true;
                    }
                }
            }
        }
        catch (CoreException e) {
            e.printStackTrace();
            return false;
        }
        return false;
    }

    private void validateTargetRuntime() {
        MavenProjectEditor mpe;
        IRuntime primaryServerRuntime = MavenValidationUtility.getPrimaryServerRuntime(this.project);
        if (primaryServerRuntime != null && RuntimeDependencyFactory.createRuntimeDependency((IRuntime)primaryServerRuntime) != null && (mpe = new MavenProjectEditor(this.project)).getDependencyForTargetRuntime(primaryServerRuntime) == null && !MavenValidationUtility.hasMarker(this.aResource, this.context.getMarkerType())) {
            ValidatorMessage msg = MavenValidationUtility.createWarningMessage(MavenValidationMessages.RUNTIME_NOT_DECLARED_IN_POM, this.aResource, this.context.getMarkerType(), this.createLocationString(MavenValidationMessages.MAVEN_PROJECT_LOC, this.context.getProject().getName()));
            this.context.getResult().add(msg);
        }
    }
}

