/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.javaee.internal.cdi.ui;

import com.ibm.etools.javaee.cdi.ui.CDIFacetVersionChangeDelegate;
import com.ibm.etools.javaee.core.JavaEEPlugin;
import com.ibm.etools.javaee.internal.cdi.ui.CDIUIExtPlugin;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.apt.core.util.AptConfig;
import org.eclipse.jdt.apt.core.util.IFactoryPath;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;
import org.eclipse.wst.common.project.facet.core.events.IFacetedProjectEvent;
import org.eclipse.wst.common.project.facet.core.events.IFacetedProjectListener;
import org.eclipse.wst.common.project.facet.core.events.IProjectFacetActionEvent;

public class FacetListener
implements IFacetedProjectListener {
    public void handleEvent(IFacetedProjectEvent event) {
        try {
            if ((event.getType() == IFacetedProjectEvent.Type.POST_INSTALL || event.getType() == IFacetedProjectEvent.Type.POST_VERSION_CHANGE) && this.shouldEnableJEEAnnotationProcessor(((IProjectFacetActionEvent)event).getProjectFacetVersion())) {
                if (event.getType() == IFacetedProjectEvent.Type.POST_VERSION_CHANGE) {
                    this.migrateFacetVersion(event);
                }
                IJavaProject javaProject = JavaCore.create((IProject)event.getProject().getProject());
                this.enableJEEAnnotationProcessor(javaProject);
            }
        }
        catch (CoreException e) {
            CDIUIExtPlugin.getDefault().getLog().log(e.getStatus());
        }
    }

    protected boolean shouldEnableJEEAnnotationProcessor(IProjectFacetVersion version) {
        return version != null && version.getProjectFacet().getId().equals("com.ibm.etools.javaee.cdi");
    }

    protected void enableJEEAnnotationProcessor(IJavaProject javaProject) throws CoreException {
        AptConfig.setEnabled((IJavaProject)javaProject, (boolean)true);
        AptConfig.setProcessDuringReconcile((IJavaProject)javaProject, (boolean)true);
        IFactoryPath path = AptConfig.getFactoryPath((IJavaProject)javaProject);
        path.enablePlugin("com.ibm.etools.javaee.cdi.ext.ui");
        AptConfig.setFactoryPath((IJavaProject)javaProject, (IFactoryPath)path);
    }

    protected void disableJEEAnnotationProcessor(IJavaProject javaProject) throws CoreException {
        IFactoryPath path = AptConfig.getFactoryPath((IJavaProject)javaProject);
        path.disablePlugin("com.ibm.etools.javaee.cdi.ext.ui");
        AptConfig.setFactoryPath((IJavaProject)javaProject, (IFactoryPath)path);
        AptConfig.setEnabled((IJavaProject)javaProject, (boolean)false);
    }

    private void migrateFacetVersion(IFacetedProjectEvent event) {
        if (event.getType() == IFacetedProjectEvent.Type.POST_VERSION_CHANGE) {
            try {
                new CDIFacetVersionChangeDelegate().execute(((IProjectFacetActionEvent)event).getProject().getProject(), ((IProjectFacetActionEvent)event).getProjectFacetVersion(), ((IProjectFacetActionEvent)event).getActionConfig(), (IProgressMonitor)new NullProgressMonitor());
            }
            catch (CoreException e) {
                JavaEEPlugin.logError((CoreException)e);
            }
        }
    }
}

