/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.javaee.internal.cdi.annotations.processor.utils;

import com.ibm.etools.javaee.annotations.jcdi.utils.JCDIUtils;
import com.ibm.etools.javaee.model.internal.Web25ModelProvider;
import com.sun.mirror.declaration.AnnotationMirror;
import com.sun.mirror.declaration.ClassDeclaration;
import com.sun.mirror.declaration.ConstructorDeclaration;
import com.sun.mirror.declaration.Declaration;
import com.sun.mirror.declaration.ExecutableDeclaration;
import com.sun.mirror.declaration.Modifier;
import com.sun.mirror.declaration.ParameterDeclaration;
import com.sun.mirror.declaration.TypeDeclaration;
import com.sun.mirror.type.ClassType;
import com.sun.mirror.type.InterfaceType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jst.j2ee.internal.common.J2EEVersionUtil;
import org.eclipse.jst.j2ee.model.IModelProvider;
import org.eclipse.jst.j2ee.model.ModelProviderManager;
import org.eclipse.jst.j2ee.project.JavaEEProjectUtilities;
import org.eclipse.jst.javaee.ejb.EJBJar;
import org.eclipse.jst.javaee.ejb.EnterpriseBeans;
import org.eclipse.jst.javaee.ejb.EntityBean;
import org.eclipse.jst.javaee.ejb.InterceptorType;
import org.eclipse.jst.javaee.ejb.InterceptorsType;
import org.eclipse.jst.javaee.ejb.MessageDrivenBean;
import org.eclipse.jst.javaee.ejb.SessionBean;
import org.eclipse.jst.server.core.FacetUtil;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;
import org.eclipse.wst.server.core.IRuntime;

public class JcdiAPUtils {
    public static final String cdiUIExtPlugin = "com.ibm.etools.javaee.cdi.ext.ui";
    public static final String annotationNameMB = "javax.annotation.ManagedBean";
    public static final String annotationNameJSFMB = "javax.faces.bean.ManagedBean";
    public static final String producesAnnotation = "javax.enterprise.inject.Produces";
    public static final String vetoedAnnotation = "javax.enterprise.inject.Vetoed";
    public static final String decoratorAnnotation = "javax.decorator.Decorator";
    public static final String injectAnnotation = "javax.inject.Inject";
    public static final String defaultTypedValue = "java.lang.Object";
    public static final String priorityAnnotation = "javax.annotation.Priority";
    public static String[] builtInScopes = new String[]{"javax.enterprise.context.RequestScoped", "javax.enterprise.context.ApplicationScoped", "javax.enterprise.context.SessionScoped", "javax.enterprise.context.ConversationScoped", "javax.enterprise.context.Dependent"};

    public static boolean isAnnotatedManagedBean(Declaration decl) {
        return JcdiAPUtils.isAnnotatedWith(decl, annotationNameMB) || JcdiAPUtils.isAnnotatedWith(decl, annotationNameJSFMB);
    }

    public static boolean isManagedBean(Declaration cDecl, IJavaProject jProject) {
        ClassDeclaration classDecl = (ClassDeclaration)cDecl;
        String packageName = classDecl.getPackage().toString();
        if (JcdiAPUtils.isAnnotatedWith(cDecl, vetoedAnnotation) || JCDIUtils.isPackageVetoed((String)packageName, (IProject)jProject.getProject())) {
            return false;
        }
        if (JcdiAPUtils.isAnnotatedManagedBean(cDecl)) {
            return true;
        }
        if (JcdiAPUtils.isNonStaticInnerClass(classDecl)) {
            return false;
        }
        if (!JcdiAPUtils.isAbstract(cDecl) || JcdiAPUtils.isAnnotatedWith(cDecl, decoratorAnnotation)) {
            if (JcdiAPUtils.hasComponentDefiningAnnotation(cDecl) || JcdiAPUtils.isEJBClassinXML(classDecl, jProject)) {
                return false;
            }
            if (JcdiAPUtils.implementsOrExtends((TypeDeclaration)cDecl, "javax.enterprise.inject.spi.Extension")) {
                return false;
            }
            Iterator it = classDecl.getConstructors().iterator();
            boolean hasValidConstructor = false;
            while (it.hasNext()) {
                ConstructorDeclaration cd = (ConstructorDeclaration)it.next();
                if (cd.getParameters().size() == 0 || JcdiAPUtils.isAnnotatedWith((Declaration)cd, injectAnnotation)) {
                    hasValidConstructor = true;
                    continue;
                }
                hasValidConstructor = false;
            }
            return hasValidConstructor;
        }
        return false;
    }

    public static boolean isEJBClassinXML(ClassDeclaration cDecl, IJavaProject proj) {
        int webVersion;
        String qName = cDecl.getQualifiedName();
        EJBJar ejbJar = null;
        IProject project = proj.getProject();
        if (JavaEEProjectUtilities.isEJBProject((IProject)project)) {
            ejbJar = (EJBJar)ModelProviderManager.getModelProvider((IProject)project).getModelObject();
        } else if (JavaEEProjectUtilities.isDynamicWebProject((IProject)project) && (webVersion = J2EEVersionUtil.convertVersionStringToInt((String)JavaEEProjectUtilities.getProjectFacetVersion((IProject)project, (String)"jst.web").getVersionString())) >= 30) {
            IModelProvider ejbInWarProvider = ((Web25ModelProvider)ModelProviderManager.getModelProvider((IProject)project)).getEjbInWarModelProvider();
            ejbJar = (EJBJar)ejbInWarProvider.getModelObject();
        }
        if (ejbJar == null || ejbJar.getEnterpriseBeans() == null) {
            return false;
        }
        EnterpriseBeans eb = ejbJar.getEnterpriseBeans();
        List entityBeans = eb.getEntityBeans();
        for (int i = 0; i < entityBeans.size(); ++i) {
            if (!qName.equals(((EntityBean)entityBeans.get(i)).getEjbClass())) continue;
            return true;
        }
        List mdbs = eb.getMessageDrivenBeans();
        for (int i = 0; i < mdbs.size(); ++i) {
            if (!qName.equals(((MessageDrivenBean)mdbs.get(i)).getEjbClass())) continue;
            return true;
        }
        List sessionBeans = eb.getSessionBeans();
        for (int i = 0; i < sessionBeans.size(); ++i) {
            if (!qName.equals(((SessionBean)sessionBeans.get(i)).getEjbClass())) continue;
            return true;
        }
        return false;
    }

    public static boolean isNonStaticInnerClass(ClassDeclaration cDecl) {
        Collection innerClasses;
        TypeDeclaration declaringType = cDecl.getDeclaringType();
        return declaringType != null && (innerClasses = cDecl.getDeclaringType().getNestedTypes()).size() > 0 && !JcdiAPUtils.isStatic((Declaration)cDecl);
    }

    public static boolean isManagedBeanPassivationCapable(ClassDeclaration decl) {
        return JcdiAPUtils.implementsOrExtends((TypeDeclaration)decl, "java.io.Serializable");
    }

    public static boolean isStatelessOrSingletonSessionBean(ClassDeclaration decl, IJavaProject proj) {
        String qName = decl.getQualifiedName();
        IModelProvider provider = ModelProviderManager.getModelProvider((IProject)proj.getProject());
        EJBJar ejbJar = (EJBJar)provider.getModelObject();
        if (ejbJar == null) {
            return false;
        }
        List sbList = ejbJar.getEnterpriseBeans().getSessionBeans();
        for (int i = 0; i < sbList.size(); ++i) {
            SessionBean sb = (SessionBean)sbList.get(i);
            if (!sb.getSessionType().equals((Object)1) && !sb.getSessionType().equals((Object)2) || !qName.equals(sb.getEjbClass())) continue;
            return true;
        }
        return false;
    }

    public static boolean hasComponentDefiningAnnotation(Declaration cDecl) {
        String[] componentDefiningAnnos = new String[]{"javax.ejb.Stateless", "javax.ejb.Stateful", "javax.ejb.Singleton", "javax.ejb.MessageDriven", "javax.ejb.EJB", "javax.ejb.EJBs"};
        for (int i = 0; i < componentDefiningAnnos.length; ++i) {
            if (!JcdiAPUtils.isAnnotatedWith(cDecl, componentDefiningAnnos[i])) continue;
            return true;
        }
        return false;
    }

    public static String getLegalBeanType(ITypeBinding td) {
        if (td != null) {
            if (td.isParameterizedType()) {
                return td.getTypeDeclaration().getQualifiedName();
            }
            if (td.isWildcardType()) {
                return null;
            }
            if (td.getName().equals(defaultTypedValue)) {
                return defaultTypedValue;
            }
            return td.getQualifiedName();
        }
        return null;
    }

    public static List<String> getValidUnRestrictedTypes(ITypeBinding bindings) {
        ArrayList<String> unrestrictedTypes = new ArrayList<String>();
        if (bindings != null) {
            String legalBeanType;
            if (bindings.isClass() && (legalBeanType = JcdiAPUtils.getLegalBeanType(bindings)) != null) {
                unrestrictedTypes.add(legalBeanType);
                unrestrictedTypes.addAll(JcdiAPUtils.getValidUnRestrictedTypes(bindings.getSuperclass()));
            }
            ITypeBinding[] superInterfaces = bindings.getInterfaces();
            for (int i = 0; i < superInterfaces.length; ++i) {
                ITypeBinding interfaceType = superInterfaces[i];
                legalBeanType = JcdiAPUtils.getLegalBeanType(interfaceType);
                if (legalBeanType == null) continue;
                unrestrictedTypes.add(legalBeanType);
                unrestrictedTypes.addAll(JcdiAPUtils.getValidUnRestrictedTypes(interfaceType));
            }
        }
        return unrestrictedTypes;
    }

    public static boolean isProducer(Declaration decl) {
        return JcdiAPUtils.isAnnotatedWith(decl, producesAnnotation);
    }

    public static boolean isManagedBean(Declaration cDecl) {
        return JcdiAPUtils.isAnnotatedManagedBean(cDecl);
    }

    public static boolean isAnnotatedWithMultipleScopes(Declaration declaration, String currentScope) {
        Collection mirrors = declaration.getAnnotationMirrors();
        for (AnnotationMirror mirror : mirrors) {
            if (mirror.getAnnotationType() == null || mirror.getAnnotationType().getDeclaration() == null || mirror.getAnnotationType().getDeclaration().getQualifiedName() == null) continue;
            for (int i = 0; i < builtInScopes.length; ++i) {
                if (currentScope.equals(builtInScopes[i]) || !mirror.getAnnotationType().getDeclaration().getQualifiedName().equals(builtInScopes[i])) continue;
                return true;
            }
        }
        return false;
    }

    public static String getQualifiedName(AnnotationMirror mirror) {
        if (mirror.getAnnotationType() == null) {
            return null;
        }
        if (mirror.getAnnotationType().getDeclaration() == null) {
            return null;
        }
        return mirror.getAnnotationType().getDeclaration().getQualifiedName();
    }

    public static IRuntime getServerRuntime(IProject project) throws CoreException {
        if (project == null) {
            return null;
        }
        IFacetedProject facetedProject = ProjectFacetsManager.create((IProject)project);
        if (facetedProject == null) {
            return null;
        }
        org.eclipse.wst.common.project.facet.core.runtime.IRuntime runtime = facetedProject.getRuntime();
        if (runtime == null) {
            return null;
        }
        return FacetUtil.getRuntime((org.eclipse.wst.common.project.facet.core.runtime.IRuntime)runtime);
    }

    public static boolean isAnnotatedWith(Declaration declaration, String annotationName) {
        Collection mirrors = declaration.getAnnotationMirrors();
        for (AnnotationMirror mirror : mirrors) {
            if (mirror.getAnnotationType() == null || mirror.getAnnotationType().getDeclaration() == null || mirror.getAnnotationType().getDeclaration().getQualifiedName() == null || !mirror.getAnnotationType().getDeclaration().getQualifiedName().equals(annotationName)) continue;
            return true;
        }
        return false;
    }

    public static boolean isAbstract(Declaration declaration) {
        Collection modifiers = declaration.getModifiers();
        return modifiers != null && modifiers.contains(Modifier.ABSTRACT);
    }

    public static boolean implementsOrExtends(TypeDeclaration type1, String type2) {
        if (type1 == null || type2 == null) {
            return false;
        }
        return JcdiAPUtils.implementsOrExtends(type1, new String[]{type2});
    }

    public static boolean implementsOrExtends(TypeDeclaration type, String[] types) {
        ClassType superClass;
        if (type == null || types == null) {
            return false;
        }
        String typeName = type.getQualifiedName();
        for (String t : types) {
            if (!typeName.equals(t)) continue;
            return true;
        }
        Collection interfaces = type.getSuperinterfaces();
        if (interfaces != null && !interfaces.isEmpty()) {
            for (InterfaceType i : interfaces) {
                if (!JcdiAPUtils.implementsOrExtends((TypeDeclaration)i.getDeclaration(), types)) continue;
                return true;
            }
        }
        return type instanceof ClassDeclaration && (superClass = ((ClassDeclaration)type).getSuperclass()) != null && JcdiAPUtils.implementsOrExtends((TypeDeclaration)superClass.getDeclaration(), types);
    }

    public static boolean isStatic(Declaration declaration) {
        Collection modifiers = declaration.getModifiers();
        return modifiers != null && modifiers.contains(Modifier.STATIC);
    }

    public static SessionBean getSessionBean(ClassDeclaration decl, IProject proj) {
        EnterpriseBeans eb;
        int webVersion;
        String packageName = decl.getPackage().toString();
        if (JcdiAPUtils.isAnnotatedWith((Declaration)decl, vetoedAnnotation) || JCDIUtils.isPackageVetoed((String)packageName, (IProject)proj.getProject())) {
            return null;
        }
        String qName = decl.getQualifiedName();
        EJBJar ejbJar = null;
        if (JavaEEProjectUtilities.isEJBProject((IProject)proj)) {
            ejbJar = (EJBJar)ModelProviderManager.getModelProvider((IProject)proj).getModelObject();
            if (ejbJar == null) {
                return null;
            }
        } else if (JavaEEProjectUtilities.isDynamicWebProject((IProject)proj) && (webVersion = J2EEVersionUtil.convertVersionStringToInt((String)JavaEEProjectUtilities.getProjectFacetVersion((IProject)proj, (String)"jst.web").getVersionString())) >= 30) {
            IModelProvider ejbInWarProvider = ((Web25ModelProvider)ModelProviderManager.getModelProvider((IProject)proj)).getEjbInWarModelProvider();
            ejbJar = (EJBJar)ejbInWarProvider.getModelObject();
        }
        if (ejbJar != null && (eb = ejbJar.getEnterpriseBeans()) != null) {
            List sbList = eb.getSessionBeans();
            for (int i = 0; i < sbList.size(); ++i) {
                SessionBean sb = (SessionBean)sbList.get(i);
                if (!qName.equals(sb.getEjbClass())) continue;
                return sb;
            }
        }
        return null;
    }

    public static ExecutableDeclaration getContainingExecutable(TypeDeclaration declType, ParameterDeclaration declParameter) {
        ExecutableDeclaration result = null;
        Collection methods = declType.getMethods();
        result = JcdiAPUtils.getContainingExecutable(methods, declParameter);
        if (result != null) {
            return result;
        }
        if (declType instanceof ClassDeclaration) {
            Collection constructors = ((ClassDeclaration)declType).getConstructors();
            result = JcdiAPUtils.getContainingExecutable(constructors, declParameter);
        }
        return result;
    }

    private static ExecutableDeclaration getContainingExecutable(Collection<? extends ExecutableDeclaration> execTypes, ParameterDeclaration declParameter) {
        for (ExecutableDeclaration executableDeclaration : execTypes) {
            if (!JcdiAPUtils.isContainingExecutable(executableDeclaration, declParameter)) continue;
            return executableDeclaration;
        }
        return null;
    }

    private static boolean isContainingExecutable(ExecutableDeclaration declType, ParameterDeclaration declParameter) {
        Collection parameters = declType.getParameters();
        for (ParameterDeclaration para : parameters) {
            if (!para.equals((Object)declParameter)) continue;
            return true;
        }
        return false;
    }

    public static boolean isFinal(Declaration declaration) {
        Collection modifiers = declaration.getModifiers();
        return modifiers != null && modifiers.contains(Modifier.FINAL);
    }

    public static boolean isPublic(Declaration declaration) {
        Collection modifiers = declaration.getModifiers();
        return modifiers != null && modifiers.contains(Modifier.PUBLIC);
    }

    public static List<InterceptorType> getEJBInterceptors(IProject proj) {
        if (!JavaEEProjectUtilities.isEJBProject((IProject)proj)) {
            return null;
        }
        IModelProvider provider = ModelProviderManager.getModelProvider((IProject)proj);
        if (provider == null) {
            return null;
        }
        Object obj = provider.getModelObject();
        if (obj == null || !(obj instanceof EJBJar)) {
            return null;
        }
        EJBJar ejbJar = (EJBJar)obj;
        InterceptorsType type = ejbJar.getInterceptors();
        if (type == null) {
            return null;
        }
        return type.getInterceptors();
    }
}

