/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.javaee.internal.cdi.annotations.processor.jcdi;

import com.ibm.etools.javaee.annotations.jcdi.utils.JCDIUtils;
import com.ibm.etools.javaee.internal.cdi.annotations.processor.jcdi.AbstractAP;
import com.ibm.etools.javaee.internal.cdi.annotations.processor.utils.AnnotationCache;
import com.ibm.etools.javaee.internal.cdi.annotations.processor.utils.JcdiAPUtils;
import com.ibm.etools.javaee.internal.cdi.ui.CDIUIExtPlugin;
import com.ibm.etools.javaee.internal.cdi.ui.Messages;
import com.ibm.ws.ast.facets.core.FacetUtilities;
import com.sun.mirror.apt.AnnotationProcessorEnvironment;
import com.sun.mirror.declaration.AnnotationTypeDeclaration;
import com.sun.mirror.declaration.ClassDeclaration;
import com.sun.mirror.declaration.Declaration;
import com.sun.mirror.declaration.FieldDeclaration;
import com.sun.mirror.declaration.MethodDeclaration;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.apt.core.util.EclipseMessager;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jst.javaee.ejb.SessionBean;
import org.eclipse.jst.javaee.ejb.SessionType;

public abstract class PassivatingScopeAP
extends AbstractAP {
    public static final String MB_SER_ERR = "MB_SER_ERR";
    public static final String SB_STATEFUL_ERR = "SB_STATEFUL_ERR";

    public PassivatingScopeAP(Set<AnnotationTypeDeclaration> atds, AnnotationProcessorEnvironment env) {
        super(atds, env);
    }

    @Override
    protected abstract String getAnnotationName();

    @Override
    protected void processAnnotation(AnnotationCache annotation) {
        block17: {
            Declaration decl = annotation.getDeclaration();
            EclipseMessager em = (EclipseMessager)this.getMessager();
            if (decl instanceof ClassDeclaration) {
                IProject proj = this._env.getJavaProject().getProject();
                try {
                    if (!FacetUtilities.hasFacet((IProject)proj, (String)"com.ibm.etools.javaee.cdi")) break block17;
                    SessionBean sb = JcdiAPUtils.getSessionBean((ClassDeclaration)decl, proj);
                    if (sb != null) {
                        if (!JCDIUtils.isSessionBeanVetoed((ASTNode)this._env.getAST())) {
                            SessionType st = sb.getSessionType();
                            if (st.getValue() == 2 || st.getValue() == 0) {
                                em.printFixableError(decl.getPosition(), Messages.bind((String)Messages.PASSIVATION_SCOPED_ERROR_SESSION_BEAN, (Object)((ClassDeclaration)decl).getQualifiedName()), "com.ibm.etools.javaee.cdi.ext.ui", SB_STATEFUL_ERR);
                            }
                            if (st.getValue() == 1 && sb.isPassivationCapable() && JcdiAPUtils.isAnnotatedWithMultipleScopes(decl, this.getAnnotationName())) {
                                em.printFixableError(annotation.getSourcePosition(), Messages.bind((String)Messages.MULTIPLE_SCOPED_ANNOTATIONS, (Object)((ClassDeclaration)decl).getQualifiedName()), "com.ibm.etools.javaee.cdi.ext.ui", "MULTI_SCOPE_ERR");
                            }
                        }
                    } else {
                        List managedBeans = JCDIUtils.getManagedBeans((ASTNode)this._env.getAST());
                        boolean isManagedBean = false;
                        String qName = ((ClassDeclaration)decl).getQualifiedName();
                        for (int i = 0; i < managedBeans.size(); ++i) {
                            if (!qName.equals(((TypeDeclaration)managedBeans.get(i)).resolveBinding().getQualifiedName())) continue;
                            isManagedBean = true;
                            break;
                        }
                        if (isManagedBean) {
                            if (!JcdiAPUtils.isManagedBeanPassivationCapable((ClassDeclaration)decl)) {
                                em.printFixableError(decl.getPosition(), Messages.bind((String)Messages.PASSIVATION_SCOPED_ERROR_MANAGED_BEAN, (Object)((ClassDeclaration)decl).getQualifiedName()), "com.ibm.etools.javaee.cdi.ext.ui", MB_SER_ERR);
                            }
                            if (JcdiAPUtils.isAnnotatedWithMultipleScopes(decl, this.getAnnotationName())) {
                                em.printFixableError(annotation.getSourcePosition(), Messages.bind((String)Messages.MULTIPLE_SCOPED_ANNOTATIONS, (Object)((ClassDeclaration)decl).getQualifiedName()), "com.ibm.etools.javaee.cdi.ext.ui", "MULTI_SCOPE_ERR");
                            }
                        }
                    }
                }
                catch (CoreException e) {
                    CDIUIExtPlugin.logError(e.getMessage());
                }
            } else if (JcdiAPUtils.isProducer(decl) && JcdiAPUtils.isAnnotatedWithMultipleScopes(decl, this.getAnnotationName())) {
                if (decl instanceof MethodDeclaration) {
                    em.printFixableError(annotation.getSourcePosition(), Messages.bind((String)Messages.MULTIPLE_SCOPED_PRODUCER_METHOD, (Object)decl.getSimpleName()), "com.ibm.etools.javaee.cdi.ext.ui", "MULTI_SCOPE_ERR");
                } else if (decl instanceof FieldDeclaration) {
                    em.printFixableError(annotation.getSourcePosition(), Messages.bind((String)Messages.MULTIPLE_SCOPED_PRODUCER_FIELD, (Object)decl.getSimpleName()), "com.ibm.etools.javaee.cdi.ext.ui", "MULTI_SCOPE_ERR");
                }
            }
        }
    }

    @Override
    protected abstract boolean isValidTarget(Declaration var1);
}

