/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.javaee.internal.cdi.annotations.processor.jcdi;

import com.ibm.etools.javaee.internal.cdi.annotations.processor.jcdi.AbstractAP;
import com.ibm.etools.javaee.internal.cdi.annotations.processor.utils.AnnotationCache;
import com.ibm.etools.javaee.internal.cdi.annotations.processor.utils.JcdiAPUtils;
import com.ibm.etools.javaee.internal.cdi.ui.Messages;
import com.ibm.ws.ast.facets.core.FacetUtilities;
import com.sun.mirror.apt.AnnotationProcessorEnvironment;
import com.sun.mirror.declaration.AnnotationTypeDeclaration;
import com.sun.mirror.declaration.ClassDeclaration;
import com.sun.mirror.declaration.ConstructorDeclaration;
import com.sun.mirror.declaration.Declaration;
import com.sun.mirror.declaration.FieldDeclaration;
import com.sun.mirror.declaration.InterfaceDeclaration;
import com.sun.mirror.declaration.MethodDeclaration;
import com.sun.mirror.declaration.ParameterDeclaration;
import com.sun.mirror.declaration.TypeDeclaration;
import com.sun.mirror.type.ClassType;
import com.sun.mirror.type.InterfaceType;
import com.sun.mirror.type.TypeMirror;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.osgi.util.NLS;

public class DecoratorAP
extends AbstractAP {
    private static final String LEFT_BRACKET = "<";
    public static final String annotationName = "javax.decorator.Decorator";
    public static final String annotationNameInject = "javax.inject.Inject";
    private Declaration delegateAnnotation = null;
    private Declaration containingDelegate = null;
    private boolean hasMultipleDelegate = false;

    public DecoratorAP(Set<AnnotationTypeDeclaration> atds, AnnotationProcessorEnvironment env) {
        super(atds, env);
    }

    @Override
    protected void processAnnotation(AnnotationCache annotation) {
        TypeDeclaration typeDecl = (TypeDeclaration)annotation.getDeclaration();
        IProject proj = this._env.getJavaProject().getProject();
        try {
            if (!FacetUtilities.hasFacet((IProject)proj, (String)"com.ibm.etools.javaee.cdi")) {
                return;
            }
        }
        catch (CoreException e) {
            return;
        }
        if (typeDecl instanceof ClassDeclaration || typeDecl instanceof InterfaceDeclaration) {
            ClassDeclaration classDecl;
            boolean isManagedBean;
            if (typeDecl instanceof ClassDeclaration && !(isManagedBean = JcdiAPUtils.isManagedBean((Declaration)(classDecl = (ClassDeclaration)typeDecl), this._env.getJavaProject()))) {
                this.getMessager().printError(classDecl.getPosition(), NLS.bind((String)Messages.DECORATOR_NOT_MANAGED_BEAN, (Object)classDecl.getSimpleName()));
                return;
            }
            this.processClassDeclaration(typeDecl);
        }
    }

    private void processClassDeclaration(TypeDeclaration classDecl) {
        this.delegateAnnotation = null;
        this.hasMultipleDelegate = false;
        this.containingDelegate = null;
        ArrayList<Declaration> variables = new ArrayList<Declaration>();
        Collection fields = classDecl.getFields();
        for (Object field : fields) {
            variables.add((Declaration)field);
        }
        this.processVariables(variables, null);
        if (!this.verifyDelegateAnnotation((Declaration)classDecl)) {
            return;
        }
        if (classDecl instanceof ClassDeclaration) {
            Collection constructors = ((ClassDeclaration)classDecl).getConstructors();
            for (ConstructorDeclaration item : constructors) {
                variables.clear();
                Collection parameters = item.getParameters();
                for (ParameterDeclaration parameter : parameters) {
                    variables.add((Declaration)parameter);
                }
                this.processVariables(variables, (Declaration)item);
            }
            if (!this.verifyDelegateAnnotation((Declaration)classDecl)) {
                return;
            }
        }
        boolean notFound = this.delegateAnnotation == null;
        Collection methods = classDecl.getMethods();
        for (MethodDeclaration item : methods) {
            variables.clear();
            Collection parameters = item.getParameters();
            for (ParameterDeclaration parameter : parameters) {
                variables.add((Declaration)parameter);
            }
            this.processVariables(variables, (Declaration)item);
        }
        if (!this.verifyDelegateAnnotation((Declaration)classDecl)) {
            return;
        }
        if (notFound && this.delegateAnnotation != null && classDecl instanceof ClassDeclaration) {
            this.getMessager().printError(this.delegateAnnotation.getPosition(), NLS.bind((String)Messages.DECORATOR_NOT_INJECTION_POINT, (Object)this.delegateAnnotation.getSimpleName()));
            return;
        }
        if (this.delegateAnnotation == null) {
            this.getMessager().printError(classDecl.getPosition(), NLS.bind((String)Messages.DECORATOR_NONE_DELEGATE, (Object)classDecl.getSimpleName()));
        }
    }

    private boolean verifyDelegateAnnotation(Declaration classDecl) {
        if (this.hasMultipleDelegate) {
            this.getMessager().printError(this.delegateAnnotation.getPosition(), NLS.bind((String)Messages.DECORATOR_MULTIPLE_DELEGATE, (Object)this.delegateAnnotation.getSimpleName()));
            return false;
        }
        if (this.delegateAnnotation != null) {
            if (!JcdiAPUtils.isAnnotatedWith(this.containingDelegate, annotationNameInject)) {
                this.getMessager().printError(this.containingDelegate.getPosition(), NLS.bind((String)Messages.DECORATOR_NOT_INJECTION_POINT, (Object)this.containingDelegate.getSimpleName()));
                return false;
            }
            TypeMirror mirrorType = null;
            if (this.delegateAnnotation instanceof FieldDeclaration) {
                mirrorType = ((FieldDeclaration)this.delegateAnnotation).getType();
            } else if (this.delegateAnnotation instanceof ParameterDeclaration) {
                mirrorType = ((ParameterDeclaration)this.delegateAnnotation).getType();
            } else {
                return true;
            }
            if (mirrorType == null || !(mirrorType instanceof TypeDeclaration)) {
                return true;
            }
            String variableType = ((TypeDeclaration)mirrorType).getQualifiedName();
            if (classDecl instanceof ClassDeclaration) {
                if (!this.isValidSuperClass((ClassDeclaration)classDecl, null, variableType)) {
                    this.getMessager().printError(this.delegateAnnotation.getPosition(), NLS.bind((String)Messages.DECORATOR_MISMATCHED_TYPE, (Object)this.delegateAnnotation.getSimpleName()));
                    return false;
                }
            } else if (classDecl instanceof InterfaceDeclaration && !this.isValidInterfaceType((TypeDeclaration)((InterfaceDeclaration)classDecl), null, variableType)) {
                this.getMessager().printError(this.delegateAnnotation.getPosition(), NLS.bind((String)Messages.DECORATOR_MISMATCHED_TYPE, (Object)this.delegateAnnotation.getSimpleName()));
                return false;
            }
        }
        return true;
    }

    private void processVariables(Collection<Declaration> parameters, Declaration method) {
        for (Declaration parameter : parameters) {
            if (!JcdiAPUtils.isAnnotatedWith(parameter, "javax.decorator.Delegate")) continue;
            if (this.delegateAnnotation == null) {
                this.delegateAnnotation = parameter;
                this.containingDelegate = method == null ? parameter : method;
                continue;
            }
            this.getMessager().printError(parameter.getPosition(), NLS.bind((String)Messages.DECORATOR_MULTIPLE_DELEGATE, (Object)parameter.getSimpleName()));
            this.hasMultipleDelegate = true;
        }
    }

    @Override
    protected boolean isValidTarget(Declaration declaration) {
        return declaration instanceof TypeDeclaration;
    }

    @Override
    protected String getAnnotationName() {
        return annotationName;
    }

    private boolean isValidSuperClass(ClassDeclaration classDeclaration, String parameterizedName, String variableType) {
        String fullName;
        if (parameterizedName == null && (fullName = classDeclaration.getQualifiedName()).indexOf(LEFT_BRACKET) > 0) {
            parameterizedName = fullName.substring(fullName.indexOf(LEFT_BRACKET));
        }
        if (variableType.indexOf(LEFT_BRACKET) > 0 && variableType.indexOf("?") > 0) {
            variableType = variableType.substring(0, variableType.indexOf(LEFT_BRACKET));
        }
        if (this.isNameIncluded(classDeclaration.getQualifiedName(), parameterizedName, variableType)) {
            return true;
        }
        ClassType superClass = classDeclaration.getSuperclass();
        if (superClass != null && superClass instanceof ClassDeclaration && this.isValidSuperClass((ClassDeclaration)superClass, parameterizedName, variableType)) {
            return true;
        }
        return this.isValidInterfaceType((TypeDeclaration)classDeclaration, null, variableType);
    }

    private boolean isValidInterfaceType(TypeDeclaration interfaceDeclaration, String parameterizedName, String variableName) {
        String fullName;
        if (parameterizedName == null && (fullName = interfaceDeclaration.getQualifiedName()).indexOf(LEFT_BRACKET) > 0) {
            parameterizedName = fullName.substring(fullName.indexOf(LEFT_BRACKET));
        }
        if (this.isNameIncluded(interfaceDeclaration.getQualifiedName(), parameterizedName, variableName)) {
            return true;
        }
        Collection interfaces = interfaceDeclaration.getSuperinterfaces();
        if (interfaces == null || interfaces.size() == 0) {
            return false;
        }
        for (InterfaceType typeInterface : interfaces) {
            if (!(typeInterface instanceof InterfaceDeclaration) || !this.isValidInterfaceType((TypeDeclaration)((InterfaceDeclaration)typeInterface), parameterizedName, variableName)) continue;
            return true;
        }
        return false;
    }

    private boolean isNameIncluded(String typeName, String parameterizedName, String variableName) {
        int index1 = ((String)typeName).indexOf(LEFT_BRACKET);
        int index2 = variableName.indexOf(LEFT_BRACKET);
        if (index1 > 0) {
            if (index2 > 0) {
                if (parameterizedName != null) {
                    typeName = ((String)typeName).substring(0, index1) + parameterizedName;
                }
                return ((String)typeName).equals(variableName);
            }
            return ((String)typeName).substring(0, index1).equals(variableName);
        }
        return ((String)typeName).equals(variableName);
    }
}

