/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.javaee.internal.cdi.annotations.processor.jcdi;

import com.ibm.etools.javaee.internal.cdi.annotations.processor.jcdi.AbstractAP;
import com.ibm.etools.javaee.internal.cdi.annotations.processor.utils.AnnotationCache;
import com.ibm.etools.javaee.internal.cdi.annotations.processor.utils.JcdiAPUtils;
import com.ibm.etools.javaee.internal.cdi.ui.CDIUIExtPlugin;
import com.ibm.etools.javaee.internal.cdi.ui.Messages;
import com.ibm.ws.ast.facets.core.FacetUtilities;
import com.sun.mirror.apt.AnnotationProcessorEnvironment;
import com.sun.mirror.declaration.AnnotationTypeDeclaration;
import com.sun.mirror.declaration.ClassDeclaration;
import com.sun.mirror.declaration.Declaration;
import com.sun.mirror.declaration.FieldDeclaration;
import com.sun.mirror.declaration.MethodDeclaration;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.apt.core.util.EclipseMessager;

public abstract class AbstractScopedAP
extends AbstractAP {
    public static final String MULTI_SCOPE_ERR = "MULTI_SCOPE_ERR";
    EclipseMessager em = (EclipseMessager)this.getMessager();

    public AbstractScopedAP(Set<AnnotationTypeDeclaration> atds, AnnotationProcessorEnvironment env) {
        super(atds, env);
    }

    @Override
    protected abstract String getAnnotationName();

    @Override
    protected void processAnnotation(AnnotationCache annotation) {
        Declaration decl = annotation.getDeclaration();
        if (decl instanceof ClassDeclaration) {
            IProject proj = this._env.getJavaProject().getProject();
            try {
                if (FacetUtilities.hasFacet((IProject)proj, (String)"com.ibm.etools.javaee.cdi") && JcdiAPUtils.isAnnotatedWithMultipleScopes(decl, this.getAnnotationName())) {
                    this.em.printFixableError(annotation.getSourcePosition(), Messages.bind((String)Messages.MULTIPLE_SCOPED_ANNOTATIONS, (Object)((ClassDeclaration)decl).getQualifiedName()), "com.ibm.etools.javaee.cdi.ext.ui", MULTI_SCOPE_ERR);
                }
            }
            catch (CoreException e) {
                CDIUIExtPlugin.logError(e.getMessage());
            }
        } else if (JcdiAPUtils.isProducer(decl) && JcdiAPUtils.isAnnotatedWithMultipleScopes(decl, this.getAnnotationName())) {
            if (decl instanceof MethodDeclaration) {
                this.em.printFixableError(annotation.getSourcePosition(), Messages.bind((String)Messages.MULTIPLE_SCOPED_PRODUCER_METHOD, (Object)decl.getSimpleName()), "com.ibm.etools.javaee.cdi.ext.ui", MULTI_SCOPE_ERR);
            } else if (decl instanceof FieldDeclaration) {
                this.em.printFixableError(annotation.getSourcePosition(), Messages.bind((String)Messages.MULTIPLE_SCOPED_PRODUCER_FIELD, (Object)decl.getSimpleName()), "com.ibm.etools.javaee.cdi.ext.ui", MULTI_SCOPE_ERR);
            }
        }
    }

    @Override
    protected abstract boolean isValidTarget(Declaration var1);
}

