/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.javaee.internal.cdi.annotations.processor.jcdi;

import com.ibm.etools.javaee.internal.cdi.annotations.processor.utils.AnnotationCache;
import com.ibm.etools.javaee.internal.cdi.annotations.processor.utils.JcdiAPUtils;
import com.sun.mirror.apt.AnnotationProcessor;
import com.sun.mirror.apt.AnnotationProcessorEnvironment;
import com.sun.mirror.apt.Messager;
import com.sun.mirror.declaration.AnnotationMirror;
import com.sun.mirror.declaration.AnnotationTypeDeclaration;
import com.sun.mirror.declaration.Declaration;
import java.util.Collection;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.apt.core.env.EclipseAnnotationProcessorEnvironment;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jem.util.logger.proxy.Logger;
import org.eclipse.wst.server.core.IRuntime;

public abstract class AbstractAP
implements AnnotationProcessor {
    protected final Set<AnnotationTypeDeclaration> _atds;
    protected final EclipseAnnotationProcessorEnvironment _env;

    public AbstractAP(Set<AnnotationTypeDeclaration> atds, AnnotationProcessorEnvironment env) {
        this._atds = atds;
        this._env = (EclipseAnnotationProcessorEnvironment)env;
    }

    public void process() {
        AnnotationTypeDeclaration annoDecl = (AnnotationTypeDeclaration)this._env.getTypeDeclaration(this.getAnnotationName());
        if (annoDecl == null) {
            return;
        }
        Collection annotatedDecls = this._env.getDeclarationsAnnotatedWith(annoDecl);
        if (annotatedDecls == null) {
            return;
        }
        for (Declaration decl : annotatedDecls) {
            if (!this.isValidTarget(decl)) continue;
            Collection mirrors = decl.getAnnotationMirrors();
            for (AnnotationMirror mirror : mirrors) {
                if (!this.getAnnotationName().equals(JcdiAPUtils.getQualifiedName(mirror))) continue;
                AnnotationCache annotation = new AnnotationCache(decl, mirror);
                this.processAnnotation(annotation);
            }
        }
    }

    protected abstract String getAnnotationName();

    protected EclipseAnnotationProcessorEnvironment getEnv() {
        return this._env;
    }

    protected Messager getMessager() {
        return this.getEnv().getMessager();
    }

    protected IJavaProject getJavaProject() {
        return this._env.getJavaProject();
    }

    protected IProject getProject() {
        return this.getJavaProject().getProject();
    }

    protected abstract void processAnnotation(AnnotationCache var1);

    protected abstract boolean isValidTarget(Declaration var1);

    protected String getServerTargetID() {
        try {
            IRuntime target = JcdiAPUtils.getServerRuntime(this.getProject());
            if (null != target) {
                return target.getRuntimeType().getId();
            }
        }
        catch (CoreException ce) {
            Logger.getLogger().log((Throwable)ce);
        }
        return null;
    }
}

