/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.javaee.cdi.ui.validation;

import com.ibm.etools.annotations.core.data.AnnotatedProjectInfo;
import com.ibm.etools.annotations.core.data.AnnotatedProjectInfosRepository;
import com.ibm.etools.annotations.core.data.AnnotationInfo;
import com.ibm.etools.javaee.internal.cdi.ui.CDIUIExtPlugin;
import com.ibm.etools.javaee.internal.cdi.ui.Messages;
import com.ibm.xwt.dde.customization.ValidationMessage;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class BeansCommonValidation {
    private static final String DECORATORS = "decorators";
    private static final String ALTERNATIVES = "alternatives";
    private static final String INTERCEPTORS_CLASS = "interceptors.class";
    private static final String DECORATORS_CLASS = "decorators.class";
    private static final String ALTERNATIVES_CLASS = "alternatives.class";
    private static final String ALTERNATIVES_STEREOTYPE = "alternatives.stereotype";
    private static final String DOT = ".";
    public static final String STEREOTYPE = "stereotype";
    public static final String CLASS = "class";
    private static final Map<String, List<String>> EXPECTED_ANNOTATIONS = new HashMap<String, List<String>>();

    public ValidationMessage verifyDuplicated(String text, Node treeNodeElement, Element parent, String nodeType) {
        ValidationMessage msg = null;
        if (nodeType != null && text != null && !text.isEmpty()) {
            Node child;
            NodeList siblings = parent.getChildNodes();
            for (int i = 0; i < siblings.getLength() && (child = siblings.item(i)) != treeNodeElement; ++i) {
                String childType = this.getNodeName(child);
                String childClass = this.getNodeText(child);
                if (childType == null || childClass == null || !nodeType.equalsIgnoreCase(childType) || !text.equals(childClass)) continue;
                msg = this.createMsg(Messages.ALREADY_LISTED, this.getTypeForMessage(nodeType, this.getNodeName(parent)), text);
            }
        }
        return msg;
    }

    public ValidationMessage verifyType(String text, String nodeType, String parentType, IResource resource) {
        ValidationMessage msg = null;
        try {
            if (text == null || text.isEmpty()) {
                msg = this.createMsg(Messages.EMPTY_ITEM, this.getTypeForMessage(nodeType, parentType));
            } else {
                IProject project = resource.getProject();
                IJavaProject jProject = JavaCore.create((IProject)project);
                IJavaElement jElement = JavaModelUtil.findTypeContainer((IJavaProject)jProject, (String)text);
                if (jElement == null || !jElement.exists()) {
                    msg = this.createMsg(Messages.NOT_FOUND, this.getTypeForMessage(nodeType, parentType), text);
                } else if (nodeType.equalsIgnoreCase(CLASS) && (jElement.getElementType() != 7 || !((IType)jElement).isClass())) {
                    msg = this.createMsg(Messages.NOT_A_CLASS, text);
                } else if (nodeType.equalsIgnoreCase(STEREOTYPE) && (jElement.getElementType() != 7 || !((IType)jElement).isAnnotation())) {
                    msg = this.createMsg(Messages.NOT_AN_ANNOTATION, text, parentType);
                } else if (!this.isValid(parentType + DOT + nodeType, text, project)) {
                    msg = this.createMsg(Messages.INCORRECT_TYPE, text, this.getTypeForMessage(nodeType, parentType));
                }
            }
        }
        catch (JavaModelException e) {
            CDIUIExtPlugin.logError(e.getMessage(), e);
        }
        return msg;
    }

    protected String getNodeText(Node node) {
        return node == null ? null : this.getTrimmed(node.getTextContent());
    }

    protected String getNodeName(Node node) {
        return node == null ? null : this.getTrimmed(node.getNodeName());
    }

    protected String getTrimmed(String original) {
        return original == null ? null : original.trim();
    }

    private String getTypeForMessage(String nodeType, String parentType) {
        String expectedMessageType = parentType.equals(ALTERNATIVES) ? (nodeType.equalsIgnoreCase(CLASS) ? Messages.ALTERNATIVE_CLASS : Messages.ALTERNATIVE_STEREOTYPE) : (parentType.equals(DECORATORS) ? Messages.DECORATOR_CLASS : Messages.INTERCEPTOR_CLASS);
        return expectedMessageType;
    }

    private boolean isValid(String type, String text, IProject project) {
        AnnotatedProjectInfo pAnn = AnnotatedProjectInfosRepository.getInstance().getAnnotatedProjectInfoForJCDI(project, false, true);
        boolean found = false;
        for (String expected : EXPECTED_ANNOTATIONS.get(type)) {
            found = false;
            for (Object obj : pAnn.getAllAnnotationsForType(text)) {
                if (!(obj instanceof AnnotationInfo) || !((AnnotationInfo)obj).getFullyQualifiedName().equals(expected)) continue;
                found = true;
                break;
            }
            if (found) continue;
            break;
        }
        return found;
    }

    private ValidationMessage createMsg(String msgTemplate, String ... values) {
        return new ValidationMessage(Messages.bind((String)msgTemplate, (Object[])values), 1);
    }

    static {
        EXPECTED_ANNOTATIONS.put(ALTERNATIVES_STEREOTYPE, new ArrayList());
        EXPECTED_ANNOTATIONS.put(ALTERNATIVES_CLASS, new ArrayList());
        EXPECTED_ANNOTATIONS.put(DECORATORS_CLASS, new ArrayList());
        EXPECTED_ANNOTATIONS.put(INTERCEPTORS_CLASS, new ArrayList());
        EXPECTED_ANNOTATIONS.get(ALTERNATIVES_STEREOTYPE).add("javax.enterprise.inject.Alternative");
        EXPECTED_ANNOTATIONS.get(ALTERNATIVES_STEREOTYPE).add("javax.enterprise.inject.Stereotype");
        EXPECTED_ANNOTATIONS.get(ALTERNATIVES_CLASS).add("javax.enterprise.inject.Alternative");
        EXPECTED_ANNOTATIONS.get(DECORATORS_CLASS).add("javax.decorator.Decorator");
        EXPECTED_ANNOTATIONS.get(INTERCEPTORS_CLASS).add("javax.interceptor.Interceptor");
    }
}

