/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.javaee.cdi.ui.quickfix.resolutions;

import com.ibm.etools.javaee.cdi.ui.quickfix.CDIQuickFixMessages;
import com.ibm.etools.javaee.internal.cdi.ui.CDIUIExtPlugin;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTParser;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.BodyDeclaration;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.FieldDeclaration;
import org.eclipse.jdt.core.dom.ImportDeclaration;
import org.eclipse.jdt.core.dom.Modifier;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.PrimitiveType;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.eclipse.jdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.jdt.core.dom.rewrite.ListRewrite;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.swt.graphics.Image;
import org.eclipse.text.edits.MalformedTreeException;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.ui.IMarkerResolution2;
import org.eclipse.ui.texteditor.MarkerUtilities;

public class AddSerializableResolution
implements IMarkerResolution2 {
    private String serialVersionUIDFieldName = "serialVersionUID";
    private String serialiableImportString = "java.io.Serializable";

    public String getLabel() {
        return CDIQuickFixMessages.IMPLEMENT_SERIALIZABLE_INTERFACE;
    }

    public void run(IMarker marker) {
        block9: {
            IResource res = marker.getResource();
            int lineNum = MarkerUtilities.getLineNumber((IMarker)marker);
            IJavaElement el = JavaCore.create((IResource)res);
            try {
                ASTParser parser = null;
                parser = ASTParser.newParser((int)3);
                if (!(el instanceof ICompilationUnit)) break block9;
                ICompilationUnit cu = (ICompilationUnit)el;
                if (!cu.isWorkingCopy()) {
                    cu.getWorkingCopy(null);
                }
                parser.setSource(cu);
                parser.setResolveBindings(true);
                CompilationUnit astCU = (CompilationUnit)parser.createAST(null);
                AST astRoot = astCU.getAST();
                ASTRewrite rewrite1 = ASTRewrite.create((AST)astCU.getAST());
                ImportDeclaration imD = astRoot.newImportDeclaration();
                ListRewrite lrw1 = rewrite1.getListRewrite((ASTNode)astCU, CompilationUnit.IMPORTS_PROPERTY);
                if (!this.importsSerializable(lrw1.getOriginalList())) {
                    Name nFullName = astRoot.newName(this.serialiableImportString);
                    imD.setName(nFullName);
                    lrw1.insertLast((ASTNode)imD, null);
                }
                TypeDeclarationNodeVisitor tdnv = new TypeDeclarationNodeVisitor(lineNum, astCU);
                astCU.accept((ASTVisitor)tdnv);
                TypeDeclaration domType = tdnv.getMatchedTypeDecl();
                if (domType != null) {
                    ListRewrite sit = rewrite1.getListRewrite((ASTNode)domType, TypeDeclaration.SUPER_INTERFACE_TYPES_PROPERTY);
                    sit.getOriginalList();
                    Name nSimpleName = domType.getAST().newName("Serializable");
                    sit.insertLast((ASTNode)domType.getAST().newSimpleType(nSimpleName), null);
                    ListRewrite bodyDeclList = rewrite1.getListRewrite((ASTNode)domType, TypeDeclaration.BODY_DECLARATIONS_PROPERTY);
                    if (!this.hasDefaultSerialVersionUID(bodyDeclList.getOriginalList())) {
                        String svID = "1L";
                        VariableDeclarationFragment vdf = astRoot.newVariableDeclarationFragment();
                        vdf.setInitializer((Expression)vdf.getAST().newNumberLiteral(svID));
                        vdf.setName(domType.getAST().newSimpleName(this.serialVersionUIDFieldName));
                        FieldDeclaration fd = astRoot.newFieldDeclaration(vdf);
                        fd.modifiers().add(astRoot.newModifier(Modifier.ModifierKeyword.PRIVATE_KEYWORD));
                        fd.modifiers().add(astRoot.newModifier(Modifier.ModifierKeyword.STATIC_KEYWORD));
                        fd.modifiers().add(astRoot.newModifier(Modifier.ModifierKeyword.FINAL_KEYWORD));
                        fd.setType((Type)astRoot.newPrimitiveType(PrimitiveType.LONG));
                        bodyDeclList.insertFirst((ASTNode)fd, null);
                    }
                    Document doc = new Document(cu.getSource());
                    TextEdit edits1 = rewrite1.rewriteAST((IDocument)doc, null);
                    try {
                        edits1.apply((IDocument)doc);
                    }
                    catch (MalformedTreeException e) {
                        CDIUIExtPlugin.logError(e.getMessage(), e);
                    }
                    catch (BadLocationException e) {
                        CDIUIExtPlugin.logError(e.getMessage(), e);
                    }
                    cu.getBuffer().setContents(doc.get());
                    break block9;
                }
                CDIUIExtPlugin.logError("AddSerializableResolution ERROR: No matching type declaration found ");
            }
            catch (CoreException e) {
                CDIUIExtPlugin.logError(e.getMessage(), e);
            }
        }
    }

    private boolean importsSerializable(List<ImportDeclaration> imports) {
        Iterator<ImportDeclaration> it = imports.iterator();
        while (it.hasNext()) {
            if (!it.next().getName().getFullyQualifiedName().equals(this.serialiableImportString)) continue;
            return true;
        }
        return false;
    }

    private boolean hasDefaultSerialVersionUID(List<BodyDeclaration> bodyDecls) {
        for (BodyDeclaration bd : bodyDecls) {
            if (!(bd instanceof FieldDeclaration)) continue;
            List frags = ((FieldDeclaration)bd).fragments();
            Iterator fragIter = frags.iterator();
            while (fragIter.hasNext()) {
                if (!((VariableDeclarationFragment)fragIter.next()).getName().getIdentifier().equals(this.serialVersionUIDFieldName)) continue;
                return true;
            }
        }
        return false;
    }

    public String getDescription() {
        return null;
    }

    public Image getImage() {
        return null;
    }

    public class TypeDeclarationNodeVisitor
    extends ASTVisitor {
        private int lineNum_;
        private CompilationUnit cu_;
        private TypeDeclaration matchedTypeDecl;

        public TypeDeclarationNodeVisitor(int lineNum, CompilationUnit cu) {
            this.lineNum_ = lineNum;
            this.cu_ = cu;
        }

        public boolean visit(TypeDeclaration md) {
            int lineNum = this.cu_.getLineNumber(md.getName().getStartPosition());
            if (lineNum == this.lineNum_) {
                this.matchedTypeDecl = md;
                return false;
            }
            return true;
        }

        public TypeDeclaration getMatchedTypeDecl() {
            return this.matchedTypeDecl;
        }
    }
}

