/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.javaee.cdi.ui.quickfix.proposals;

import com.ibm.etools.javaee.cdi.ui.quickfix.CDIQuickFixMessages;
import com.ibm.etools.javaee.internal.cdi.ui.CDIUIExtPlugin;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.Annotation;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.IAnnotationBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.ImportDeclaration;
import org.eclipse.jdt.core.dom.MarkerAnnotation;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.NormalAnnotation;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.SingleMemberAnnotation;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.jdt.core.dom.rewrite.ImportRewrite;
import org.eclipse.jdt.core.dom.rewrite.ListRewrite;
import org.eclipse.jdt.ui.CodeStyleConfiguration;
import org.eclipse.jdt.ui.text.java.IInvocationContext;
import org.eclipse.jdt.ui.text.java.IJavaCompletionProposal;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.text.edits.MalformedTreeException;
import org.eclipse.text.edits.TextEdit;

public class ReplaceWithStatefulAnnotationProposal
implements IJavaCompletionProposal {
    private final int fRelevance;
    private final CompilationUnit fCompilationUnit;
    private final ASTNode node;
    private String fullyQualifiedAnnotationName;
    private CDIPassivatingScopeVisitor cdiPSScopeVisitor = new CDIPassivatingScopeVisitor();
    private String STATELESS_ANNO = "javax.ejb.Stateless";
    private String SINGLETON_ANNO = "javax.ejb.Singleton";
    private String STATEFUL_ANNO = "javax.ejb.Stateful";

    public ReplaceWithStatefulAnnotationProposal(IInvocationContext context, ASTNode selectedNode, int relevance) {
        this(context.getASTRoot(), context.getCoveredNode().getParent(), relevance);
    }

    public ReplaceWithStatefulAnnotationProposal(CompilationUnit icu, ASTNode selectedNode, int relevance) {
        this.fRelevance = relevance;
        this.fCompilationUnit = icu;
        this.node = selectedNode;
        this.node.accept((ASTVisitor)this.cdiPSScopeVisitor);
    }

    public void apply(IDocument document) {
        AST ast = this.fCompilationUnit.getAST();
        ASTRewrite rewrite = ASTRewrite.create((AST)ast);
        Annotation markerToRemove = this.cdiPSScopeVisitor.getAnnotationToRemove();
        SimpleName newName = ast.newSimpleName("Stateful");
        MarkerAnnotation newMA = ast.newMarkerAnnotation();
        newMA.setTypeName((Name)newName);
        try {
            ListRewrite list = rewrite.getListRewrite(this.node, TypeDeclaration.MODIFIERS2_PROPERTY);
            list.replace((ASTNode)markerToRemove, (ASTNode)newMA, null);
            TextEdit edit = rewrite.rewriteAST();
            edit.apply(document);
            ListRewrite importsList = rewrite.getListRewrite((ASTNode)this.fCompilationUnit, CompilationUnit.IMPORTS_PROPERTY);
            if (!this.importsStateful(importsList.getOriginalList())) {
                ImportRewrite importRewrite = CodeStyleConfiguration.createImportRewrite((CompilationUnit)this.fCompilationUnit, (boolean)true);
                importRewrite.addImport(this.STATEFUL_ANNO);
                edit = importRewrite.rewriteImports(null);
            }
            edit.apply(document);
        }
        catch (MalformedTreeException e) {
            CDIUIExtPlugin.logError(e.getMessage(), e);
        }
        catch (BadLocationException e) {
            CDIUIExtPlugin.logError(e.getMessage(), e);
        }
        catch (JavaModelException e) {
            CDIUIExtPlugin.logError(e.getMessage(), e);
        }
        catch (IllegalArgumentException e) {
            CDIUIExtPlugin.logError(e.getMessage(), e);
        }
        catch (CoreException e) {
            CDIUIExtPlugin.logError(e.getMessage(), e);
        }
    }

    public String getAdditionalProposalInfo() {
        return null;
    }

    public IContextInformation getContextInformation() {
        return null;
    }

    public String getDisplayString() {
        return CDIQuickFixMessages.bind((String)CDIQuickFixMessages.REPLACE_WITH_STATEFUL_ANNOTATION, (Object)this.fullyQualifiedAnnotationName);
    }

    public Image getImage() {
        return null;
    }

    public Point getSelection(IDocument arg0) {
        return null;
    }

    public int getRelevance() {
        return this.fRelevance;
    }

    private boolean importsStateful(List<ImportDeclaration> imports) {
        Iterator<ImportDeclaration> it = imports.iterator();
        while (it.hasNext()) {
            if (!it.next().getName().getFullyQualifiedName().equals(this.STATEFUL_ANNO)) continue;
            return true;
        }
        return false;
    }

    private final class CDIPassivatingScopeVisitor
    extends ASTVisitor {
        private Annotation ma = null;

        private CDIPassivatingScopeVisitor() {
        }

        private boolean visitCommon(Annotation ann) {
            ITypeBinding annotationType;
            IAnnotationBinding binding = ann.resolveAnnotationBinding();
            if (binding != null && (annotationType = binding.getAnnotationType()) != null) {
                String annotationName = annotationType.getQualifiedName();
                if (annotationName.equals(ReplaceWithStatefulAnnotationProposal.this.STATELESS_ANNO)) {
                    this.ma = ann;
                    ReplaceWithStatefulAnnotationProposal.this.fullyQualifiedAnnotationName = ReplaceWithStatefulAnnotationProposal.this.STATELESS_ANNO;
                } else if (annotationName.equals(ReplaceWithStatefulAnnotationProposal.this.SINGLETON_ANNO)) {
                    this.ma = ann;
                    ReplaceWithStatefulAnnotationProposal.this.fullyQualifiedAnnotationName = ReplaceWithStatefulAnnotationProposal.this.SINGLETON_ANNO;
                }
            }
            return true;
        }

        public boolean visit(MarkerAnnotation ann) {
            return this.visitCommon((Annotation)ann);
        }

        public boolean visit(NormalAnnotation ann) {
            return this.visitCommon((Annotation)ann);
        }

        public boolean visit(SingleMemberAnnotation ann) {
            return this.visitCommon((Annotation)ann);
        }

        public Annotation getAnnotationToRemove() {
            return this.ma;
        }
    }
}

