/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.javaee.cdi.ui.quickfix.proposals;

import com.ibm.etools.javaee.cdi.ui.quickfix.CDIQuickFixMessages;
import com.ibm.etools.javaee.internal.cdi.ui.CDIUIExtPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.Annotation;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.IAnnotationBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.MarkerAnnotation;
import org.eclipse.jdt.core.dom.NormalAnnotation;
import org.eclipse.jdt.core.dom.SingleMemberAnnotation;
import org.eclipse.jdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.jdt.core.dom.rewrite.ImportRewrite;
import org.eclipse.jdt.ui.CodeStyleConfiguration;
import org.eclipse.jdt.ui.text.java.IInvocationContext;
import org.eclipse.jdt.ui.text.java.IJavaCompletionProposal;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.text.edits.MalformedTreeException;
import org.eclipse.text.edits.TextEdit;

public class RemoveMultiScopeProposal
implements IJavaCompletionProposal {
    private final int fRelevance;
    private final CompilationUnit fCompilationUnit;
    private final ASTNode node;
    private String fullyQualifiedAnnotationName;
    private CDIScopeVisitor cdiScopeVisitor = new CDIScopeVisitor();

    public RemoveMultiScopeProposal(IInvocationContext context, ASTNode selectedNode, int relevance) {
        this(context.getASTRoot(), context.getCoveredNode().getParent(), relevance);
    }

    public RemoveMultiScopeProposal(CompilationUnit icu, ASTNode selectedNode, int relevance) {
        this.fRelevance = relevance;
        this.fCompilationUnit = icu;
        this.node = selectedNode;
        selectedNode.accept((ASTVisitor)this.cdiScopeVisitor);
    }

    public int getRelevance() {
        return this.fRelevance;
    }

    public void apply(IDocument document) {
        ASTRewrite rewrite = ASTRewrite.create((AST)this.fCompilationUnit.getAST());
        rewrite.remove(this.node, null);
        try {
            TextEdit edit = rewrite.rewriteAST();
            edit.apply(document);
            this.fCompilationUnit.accept((ASTVisitor)this.cdiScopeVisitor);
            if (this.cdiScopeVisitor.getNumScopRefs() == 1) {
                ImportRewrite importRewrite = CodeStyleConfiguration.createImportRewrite((CompilationUnit)this.fCompilationUnit, (boolean)true);
                importRewrite.removeImport(this.fullyQualifiedAnnotationName);
                edit = importRewrite.rewriteImports(null);
                edit.apply(document);
            }
        }
        catch (MalformedTreeException e) {
            CDIUIExtPlugin.logError(e.getMessage(), e);
        }
        catch (BadLocationException e) {
            CDIUIExtPlugin.logError(e.getMessage(), e);
        }
        catch (JavaModelException e) {
            CDIUIExtPlugin.logError(e.getMessage(), e);
        }
        catch (IllegalArgumentException e) {
            CDIUIExtPlugin.logError(e.getMessage(), e);
        }
        catch (CoreException e) {
            CDIUIExtPlugin.logError(e.getMessage(), e);
        }
    }

    public String getAdditionalProposalInfo() {
        return null;
    }

    public IContextInformation getContextInformation() {
        return null;
    }

    public String getDisplayString() {
        return CDIQuickFixMessages.bind((String)CDIQuickFixMessages.REMOVE_SCOPE, (Object)this.fullyQualifiedAnnotationName);
    }

    public Image getImage() {
        return null;
    }

    public Point getSelection(IDocument arg0) {
        return null;
    }

    private final class CDIScopeVisitor
    extends ASTVisitor {
        private int numSameNameScopesRef = 0;

        private boolean visitCommon(Annotation ann) {
            ITypeBinding annotationType;
            IAnnotationBinding binding = ann.resolveAnnotationBinding();
            if (binding != null && (annotationType = binding.getAnnotationType()) != null) {
                if (RemoveMultiScopeProposal.this.fullyQualifiedAnnotationName == null) {
                    RemoveMultiScopeProposal.this.fullyQualifiedAnnotationName = annotationType.getQualifiedName();
                } else if (annotationType.getQualifiedName().equals(RemoveMultiScopeProposal.this.fullyQualifiedAnnotationName)) {
                    ++this.numSameNameScopesRef;
                }
            }
            return true;
        }

        public boolean visit(MarkerAnnotation ann) {
            return this.visitCommon((Annotation)ann);
        }

        public boolean visit(NormalAnnotation ann) {
            return this.visitCommon((Annotation)ann);
        }

        public boolean visit(SingleMemberAnnotation ann) {
            return this.visitCommon((Annotation)ann);
        }

        public int getNumScopRefs() {
            return this.numSameNameScopesRef;
        }
    }
}

