/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.javaee.cdi.ui.popup;

import com.ibm.etools.javaee.cdi.ui.internal.quickfix.CDIFacet;
import com.ibm.etools.javaee.cdi.ui.internal.quickfix.CDIProjectConverter;
import com.ibm.etools.javaee.cdi.ui.internal.quickfix.CDIUtils;
import com.ibm.etools.javaee.cdi.ui.quickfix.CDIQuickFixMessages;
import com.ibm.etools.javaee.internal.cdi.ui.CDIUIExtPlugin;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jst.common.project.facet.core.JavaFacet;
import org.eclipse.jst.j2ee.project.JavaEEProjectUtilities;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.wst.common.componentcore.internal.util.FacetedProjectUtilities;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;

public class ConvertProjectToCDI
implements IObjectActionDelegate {
    private IStructuredSelection selection;

    public void run(IAction action) {
        IProject project = (IProject)this.selection.getFirstElement();
        if (project.exists()) {
            try {
                IFacetedProject facetProj = ProjectFacetsManager.create((IProject)project);
                if (facetProj != null) {
                    if (JavaEEProjectUtilities.isUtilityProject((IProject)project)) {
                        CDIProjectConverter.selectCDIAndConvert(project);
                    } else {
                        if (CDIUtils.isJavaEE8Project(project)) {
                            CDIProjectConverter.addCDIFacet(CDIFacet.v2_0, facetProj);
                        } else if (CDIUtils.isJavaEE7Project(project)) {
                            CDIProjectConverter.addCDIFacet(CDIFacet.v1_2, facetProj);
                        } else if (CDIUtils.isJavaEE6Project(project)) {
                            CDIProjectConverter.addCDIFacet(CDIFacet.v1_0, facetProj);
                        } else if (FacetedProjectUtilities.getProjectFacetVersion((IProject)project, (String)"java").equals((Object)JavaFacet.VERSION_1_8)) {
                            CDIProjectConverter.addCDIFacet(CDIFacet.v2_0, facetProj);
                        } else if (FacetedProjectUtilities.getProjectFacetVersion((IProject)project, (String)"java").equals((Object)JavaFacet.VERSION_1_7)) {
                            CDIProjectConverter.addCDIFacet(CDIFacet.v1_2, facetProj);
                        } else {
                            CDIProjectConverter.addCDIFacet(CDIFacet.v1_0, facetProj);
                        }
                        StringBuilder msg = new StringBuilder(CDIQuickFixMessages.CDI_Facet_Added_Notification).append(" ").append(project.getName());
                        CDIUtils.displayMessage(CDIQuickFixMessages.CDI_Information_Title, msg.toString());
                    }
                } else {
                    CDIProjectConverter.selectRuntimeAndConvert(project);
                }
            }
            catch (CoreException e) {
                Status status = new Status(2, "com.ibm.etools.javaee.cdi.ext.ui", 2, CDIQuickFixMessages.CDI_Add_Facet_Warning, (Throwable)e);
                CDIUIExtPlugin.getDefault().getLog().log((IStatus)status);
            }
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
        if (selection instanceof IStructuredSelection) {
            this.selection = (IStructuredSelection)selection;
        }
    }

    public void setActivePart(IAction arg0, IWorkbenchPart arg1) {
    }
}

