/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.javaee.cdi.ui.internal.quickfix;

import com.ibm.etools.javaee.cdi.ui.dialogs.CDIRuntimeSelectionDialog;
import com.ibm.etools.javaee.cdi.ui.dialogs.CDIUtilityProjectVersionSelectionDialog;
import com.ibm.etools.javaee.cdi.ui.internal.quickfix.CDIFacet;
import com.ibm.etools.javaee.cdi.ui.internal.quickfix.CDIUtils;
import com.ibm.etools.javaee.cdi.ui.quickfix.CDIQuickFixMessages;
import com.ibm.etools.javaee.internal.cdi.ui.CDIUIExtPlugin;
import java.util.HashSet;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.rewrite.ImportRewrite;
import org.eclipse.jdt.ui.CodeStyleConfiguration;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jst.common.project.facet.JavaFacetInstallDataModelProvider;
import org.eclipse.jst.common.project.facet.core.JavaFacet;
import org.eclipse.jst.j2ee.project.facet.J2EEModuleFacetInstallDataModelProvider;
import org.eclipse.jst.server.core.FacetUtil;
import org.eclipse.swt.widgets.Display;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.wst.common.componentcore.datamodel.FacetProjectCreationDataModelProvider;
import org.eclipse.wst.common.componentcore.datamodel.properties.IFacetProjectCreationDataModelProperties;
import org.eclipse.wst.common.frameworks.datamodel.DataModelFactory;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.frameworks.datamodel.IDataModelProvider;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;
import org.eclipse.wst.server.core.IRuntime;

public class CDIProjectConverter {
    public static void selectRuntimeAndConvert(IJavaProject javaProject, ASTNode node, IDocument document, ICompilationUnit fCompilationUnit) {
        IProject project = javaProject.getProject();
        CDIProjectConverter.internalSelectRuntimeAndConvert(project, node, document, fCompilationUnit);
    }

    public static void selectRuntimeAndConvert(IProject project) {
        CDIProjectConverter.internalSelectRuntimeAndConvert(project, null, null, null);
    }

    public static void selectCDIAndConvert(IProject project) {
        CDIProjectConverter.internalSelectCDIVersionAndConvert(project, null, null, null);
    }

    private static void internalSelectRuntimeAndConvert(final IProject project, final ASTNode node, final IDocument document, final ICompilationUnit fCompilationUnit) {
        try {
            IWorkspaceRunnable runnable = new IWorkspaceRunnable(){

                public void run(IProgressMonitor monitor) throws CoreException {
                    CDIRuntimeSelectionDialog dialog = new CDIRuntimeSelectionDialog(Display.getDefault().getActiveShell(), CDIQuickFixMessages.AddCDISupportWAS, CDIQuickFixMessages.AddCDISupport_Dialog_Message);
                    dialog.setSelectedNode(node);
                    if (dialog.open() == 0) {
                        CDIProjectConverter.internalConvert(project, dialog.getWasRuntime(), dialog.getCdiVersion(), node, document, fCompilationUnit);
                    }
                }
            };
            ResourcesPlugin.getWorkspace().run(runnable, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (CoreException e) {
            CDIUIExtPlugin.getDefault().getLog().log(e.getStatus());
        }
    }

    private static void internalSelectCDIVersionAndConvert(final IProject project, final ASTNode node, final IDocument document, final ICompilationUnit fCompilationUnit) {
        try {
            IWorkspaceRunnable runnable = new IWorkspaceRunnable(){

                public void run(IProgressMonitor monitor) throws CoreException {
                    CDIUtilityProjectVersionSelectionDialog dialog = new CDIUtilityProjectVersionSelectionDialog(Display.getDefault().getActiveShell(), CDIQuickFixMessages.AddCDISupportWAS, CDIQuickFixMessages.CDI_Version_ToolTip, project);
                    if (dialog.open() == 0) {
                        CDIProjectConverter.internalConvert(project, null, dialog.getCdiVersion(), node, document, fCompilationUnit);
                    }
                }
            };
            ResourcesPlugin.getWorkspace().run(runnable, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (CoreException e) {
            CDIUIExtPlugin.getDefault().getLog().log(e.getStatus());
        }
    }

    private static void internalConvert(IProject project, IRuntime runtime, CDIFacet cdiFacetVersion, ASTNode node, IDocument document, ICompilationUnit fCompilationUnit) {
        IDataModel jdm = null;
        if (cdiFacetVersion.getVersion().equals("1.0")) {
            jdm = CDIProjectConverter.prepareFacetedJavaProject(project, JavaFacet.VERSION_1_6);
        } else if (cdiFacetVersion.getVersion().equals("1.2")) {
            jdm = CDIProjectConverter.prepareFacetedJavaProject(project, JavaFacet.VERSION_1_7);
        } else if (cdiFacetVersion.getVersion().equals("2.0")) {
            jdm = CDIProjectConverter.prepareFacetedJavaProject(project, JavaFacet.VERSION_1_8);
        }
        IDataModel udm = CDIProjectConverter.prepareJ2EEModule(project, cdiFacetVersion);
        CDIProjectConverter.prepareConvertionOperations(project, jdm, udm);
        IFacetedProject facetProj = null;
        if (project.exists()) {
            try {
                facetProj = ProjectFacetsManager.create((IProject)project);
                if (facetProj != null) {
                    CDIProjectConverter.addCDIFacet(cdiFacetVersion, facetProj);
                    if (runtime != null && facetProj.getPrimaryRuntime() == null) {
                        CDIUtils.setRuntime(facetProj, FacetUtil.getRuntime((IRuntime)runtime));
                    }
                    if (fCompilationUnit != null && document != null && node != null) {
                        CDIProjectConverter.addAnnotationImport(node, document, fCompilationUnit, facetProj);
                    }
                    project.build(10, (IProgressMonitor)new NullProgressMonitor());
                    StringBuilder msg = new StringBuilder(CDIQuickFixMessages.CDI_Facet_Added_Notification).append(" ").append(project.getName());
                    CDIUtils.displayMessage(CDIQuickFixMessages.CDI_Information_Title, msg.toString());
                }
            }
            catch (CoreException e) {
                CDIUIExtPlugin.getDefault().getLog().log(e.getStatus());
            }
            catch (Exception e) {
                Status status = new Status(2, "com.ibm.etools.javaee.cdi.ext.ui", 2, CDIQuickFixMessages.CDI_Configuration_Warning, (Throwable)e);
                CDIUIExtPlugin.getDefault().getLog().log((IStatus)status);
            }
        }
    }

    public static void addCDIFacet(CDIFacet cdiFacetVersion, IFacetedProject facetProj) throws CoreException {
        HashSet<IFacetedProject.Action> actions = new HashSet<IFacetedProject.Action>();
        if (!CDIUtils.hasFacet(facetProj, "com.ibm.etools.javaee.cdi")) {
            IFacetedProject.Action addFacetVersionAction = new IFacetedProject.Action(IFacetedProject.Action.Type.INSTALL, cdiFacetVersion.getFacetVersion(), null);
            actions.add(addFacetVersionAction);
        }
        if (!actions.isEmpty()) {
            facetProj.modify(actions, (IProgressMonitor)new NullProgressMonitor());
        }
    }

    private static void addAnnotationImport(ASTNode node, IDocument document, ICompilationUnit fCompilationUnit, IFacetedProject facetProj) throws CoreException, JavaModelException, BadLocationException {
        if (facetProj.getPrimaryRuntime() != null && CDIUtils.hasFacet(facetProj, "com.ibm.etools.javaee.cdi")) {
            Name nameNode = null;
            if (node instanceof Name) {
                nameNode = (Name)node;
            }
            if (nameNode != null && nameNode.isSimpleName()) {
                ImportRewrite importRewrite = CodeStyleConfiguration.createImportRewrite((ICompilationUnit)fCompilationUnit, (boolean)true);
                importRewrite.addImport(CDIUtils.getQualifiedName(nameNode.getFullyQualifiedName()));
                TextEdit edit = importRewrite.rewriteImports(null);
                edit.apply(document);
            }
        }
    }

    private static IDataModel prepareFacetedJavaProject(IProject project, IProjectFacetVersion javaFacet) {
        IDataModel jdm = DataModelFactory.createDataModel((IDataModelProvider)new JavaFacetInstallDataModelProvider());
        jdm.setProperty("IFacetDataModelProperties.FACET_PROJECT_NAME", (Object)project.getName());
        jdm.setProperty("IFacetDataModelPropeties.FACET_VERSION", (Object)javaFacet);
        return jdm;
    }

    private static void prepareConvertionOperations(IProject project, IDataModel jdm, IDataModel udm) {
        try {
            IDataModel dm = DataModelFactory.createDataModel((IDataModelProvider)new FacetProjectCreationDataModelProvider());
            dm.setProperty("IFacetDataModelProperties.FACET_PROJECT_NAME", (Object)project.getName());
            IFacetProjectCreationDataModelProperties.FacetDataModelMap map = (IFacetProjectCreationDataModelProperties.FacetDataModelMap)dm.getProperty("IFacetProjectCreationDataModelProperties.FACET_DM_MAP");
            map.add(jdm);
            map.add(udm);
            dm.getDefaultOperation().execute((IProgressMonitor)new NullProgressMonitor(), null);
        }
        catch (Exception e) {
            Status status = new Status(2, "com.ibm.etools.javaee.cdi.ext.ui", 2, CDIQuickFixMessages.CDI_Error_Message, (Throwable)e);
            CDIUIExtPlugin.getDefault().getLog().log((IStatus)status);
        }
    }

    private static IDataModel prepareJ2EEModule(IProject project, CDIFacet cdiFacetVersion) {
        IDataModel udm = DataModelFactory.createDataModel((IDataModelProvider)new J2EEModuleFacetInstallDataModelProvider(){

            protected int convertFacetVersionToJ2EEVersion(IProjectFacetVersion version) {
                return 0;
            }

            public Object getDefaultProperty(String propertyName) {
                if ("IFacetDataModelProperties.FACET_ID".equals(propertyName)) {
                    return "jst.utility";
                }
                return super.getDefaultProperty(propertyName);
            }
        });
        udm.setProperty("IFacetDataModelProperties.FACET_PROJECT_NAME", (Object)project.getName());
        udm.setProperty("IFacetDataModelProperties.FACET_VERSION_STR", (Object)cdiFacetVersion.getVersion());
        udm.setProperty("IJ2EEFacetInstallDataModelProperties.ADD_TO_EAR", (Object)Boolean.FALSE);
        return udm;
    }
}

