/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.javaee.cdi.ui;

import com.ibm.etools.j2ee.J2EEProjectUtilities;
import com.ibm.etools.javaee.cdi.ui.internal.actions.ResourceUtils;
import com.ibm.etools.javaee.cdi.ui.internal.quickfix.CDIUtils;
import com.ibm.etools.javaee.internal.cdi.ui.CDIUIExtPlugin;
import com.ibm.etools.javaee.project.facet.IJavaEEFacetConstants;
import java.io.InputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.wst.common.project.facet.core.IDelegate;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public final class CDIFacetVersionChangeDelegate
implements IDelegate {
    private boolean isJEE6 = true;
    private boolean isJEE7 = false;
    private boolean isJEE8 = false;
    private final String XML_NS_XSI = "xmlns:xsi";
    private final String XML_NS = "xmlns";
    private final String XSI_SCHEMA_LOCATION = "xsi:schemaLocation";
    private final String XSI_NS_URL = "http://www.w3.org/2001/XMLSchema-instance";
    private final String JAVAEE_NS_URL = "http://java.sun.com/xml/ns/javaee";
    private final String JAVAEE7_NS_URL = "http://xmlns.jcp.org/xml/ns/javaee";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(IProject project, IProjectFacetVersion projectFacetVersion, Object cfg, IProgressMonitor monitor) throws CoreException {
        this.isJEE6 = projectFacetVersion.equals((Object)IJavaEEFacetConstants.CDI_1);
        this.isJEE7 = projectFacetVersion.equals((Object)IJavaEEFacetConstants.CDI_12);
        this.isJEE8 = projectFacetVersion.equals((Object)IJavaEEFacetConstants.CDI_20);
        if (monitor != null) {
            monitor.beginTask("", 1);
        }
        try {
            IFile beansFile = CDIUtils.getBeansFile(project, ResourceUtils.getContainer(project));
            if (beansFile.exists()) {
                try {
                    this.updateNamespace(beansFile);
                }
                catch (Exception exception) {
                    CDIUIExtPlugin.logError("Failed to update the CDI beans.xml during facet change.", exception);
                }
            }
        }
        finally {
            if (monitor != null) {
                monitor.done();
            }
        }
    }

    private void updateNamespace(IFile file) throws Exception {
        InputStream inputStream = file.getContents();
        DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder dBuilder = dbFactory.newDocumentBuilder();
        Document document = dBuilder.parse(inputStream);
        this.updateAttributes(document);
        J2EEProjectUtilities.saveXMLFileContent((IFile)file, (Document)document);
    }

    private void updateAttributes(Document document) {
        Element root = document.getDocumentElement();
        Attr attrXML_NS_XSI = root.getAttributeNode("xmlns:xsi");
        if (attrXML_NS_XSI == null) {
            attrXML_NS_XSI = document.createAttribute("xmlns:xsi");
            root.setAttributeNode(attrXML_NS_XSI);
        }
        attrXML_NS_XSI.setNodeValue(this.getattrXML_NS_XSI());
        Attr attrXML_NS = root.getAttributeNode("xmlns");
        if (attrXML_NS == null) {
            attrXML_NS = document.createAttribute("xmlns");
            root.setAttributeNode(attrXML_NS);
        }
        attrXML_NS.setNodeValue(this.getXML_NS());
        Attr attrXSI_SCHEMA_LOCATION = root.getAttributeNode("xsi:schemaLocation");
        if (attrXSI_SCHEMA_LOCATION == null) {
            attrXSI_SCHEMA_LOCATION = document.createAttribute("xsi:schemaLocation");
            root.setAttributeNode(attrXSI_SCHEMA_LOCATION);
        }
        attrXSI_SCHEMA_LOCATION.setNodeValue(this.getSchemaLocation());
        if (!this.isJEE6) {
            Attr attrDiscoveryMode = root.getAttributeNode("bean-discovery-mode");
            if (attrDiscoveryMode == null) {
                attrDiscoveryMode = document.createAttribute("bean-discovery-mode");
                root.setAttributeNode(attrDiscoveryMode);
                attrDiscoveryMode.setNodeValue("annotated");
            }
        } else {
            Attr attrDiscoveryMode = root.getAttributeNode("bean-discovery-mode");
            if (attrDiscoveryMode != null) {
                root.removeAttributeNode(attrDiscoveryMode);
            }
        }
    }

    private String getSchemaLocation() {
        if (this.isJEE8) {
            return this.getXML_NS() + " http://xmlns.jcp.org/xml/ns/javaee/beans_2_0.xsd";
        }
        if (this.isJEE7) {
            return this.getXML_NS() + " http://xmlns.jcp.org/xml/ns/javaee/beans_1_1.xsd";
        }
        return this.getXML_NS() + " http://java.sun.com/xml/ns/javaee/beans_1_0.xsd";
    }

    private String getattrXML_NS_XSI() {
        return "http://www.w3.org/2001/XMLSchema-instance";
    }

    private String getXML_NS() {
        if (this.isJEE6) {
            return "http://java.sun.com/xml/ns/javaee";
        }
        return "http://xmlns.jcp.org/xml/ns/javaee";
    }
}

