/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.common.internal.migration.ui;

import com.ibm.etools.common.internal.migration.framework.MigrationMessages;
import com.ibm.etools.common.internal.migration.framework.WorkspaceMigrationEngine;
import com.ibm.etools.common.internal.migration.ui.plugin.MigrationUIPlugin;
import com.ibm.etools.common.internal.migration.validation.framework.MigrationValidatorEngine;
import com.ibm.etools.common.migration.validation.framework.IMigrationResult;
import com.ibm.etools.common.migration.validation.framework.IMigrationResultsListener;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.TextViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.custom.ViewForm;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.part.PageBook;
import org.eclipse.ui.part.ViewPart;

public class MigrationValidationResultsView
extends ViewPart
implements IMigrationResultsListener {
    LinkedHashMap<IProject, IMigrationResult> results = new LinkedHashMap();
    private static final int VIEW_VERTICAL = 0;
    private static final int VIEW_HORIZONTAL = 1;
    private static final Color OK_COLOR = new Color(null, 0, 128, 0);
    private static final Color ERROR_COLOR = new Color(null, 255, 0, 0);
    private static final Color INFO_COLOR = new Color(null, 0, 0, 255);
    private static final Color WARNING_COLOR = new Color(null, 255, 128, 0);
    private static final String lineSeparator = System.getProperty("line.separator");
    private static final IPath metadataLocation = Platform.getLogFileLocation().removeLastSegments(1);
    private static final File LOGFILE = metadataLocation.append("migration.log").toFile();
    private boolean fInComputeOrientation = false;
    private TableViewer fProjectsViewer;
    private TextViewer fResultsViewer;
    private SashForm fResultsSplitter;
    private PageBook fPagebook;
    private ViewForm fProjectsViewerViewForm;
    private ViewForm fResultViewerViewForm;
    private Composite fParent;
    private Object oldValue;
    private Clipboard clipboard;
    private List<IProject> projects = new ArrayList<IProject>();
    private StringBuffer log;
    private Action removeAction;
    private Action removeAllAction;
    private Action copyAction;
    private Action selectAllAction;
    private Action runAction;
    private Action refreshAction;
    private Action logAction;
    private Action openAction;
    private Action removeOKAction;
    private Action removeErrorAction;
    private Action removeWarningAction;
    private Composite emptyViewer;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resultsUpdate(IMigrationResult message, boolean dynamicUpdate) {
        LinkedHashMap<IProject, IMigrationResult> linkedHashMap = this.results;
        synchronized (linkedHashMap) {
            this.addResults(message, dynamicUpdate);
        }
    }

    public void clearView() {
        this.clearResults();
    }

    private void addResults(IMigrationResult message, boolean dynamicUpdate) {
        this.results.put(message.getProject(), message);
        if (this.results.size() == 1) {
            this.updateActionsEnabledState(true);
            this.log = null;
        }
        if (dynamicUpdate) {
            this.fProjectsViewer.setInput((Object)this);
            if (this.results.size() == 1) {
                this.fPagebook.showPage((Control)this.fResultsSplitter);
                if (this.fProjectsViewer.getSelection().isEmpty() && this.results.size() > 0) {
                    this.oldValue = null;
                    this.fProjectsViewer.getControl().update();
                    this.fProjectsViewer.setSelection((ISelection)new StructuredSelection(this.fProjectsViewer.getElementAt(0)), true);
                }
            }
        }
    }

    public void showResults() {
        if (!this.fPagebook.isDisposed()) {
            this.fPagebook.showPage((Control)this.fResultsSplitter);
            this.fProjectsViewer.setInput((Object)this);
            if (this.fProjectsViewer.getSelection().isEmpty() && this.results.size() > 0) {
                this.oldValue = null;
                this.fProjectsViewer.setSelection((ISelection)new StructuredSelection(this.fProjectsViewer.getElementAt(0)), true);
                this.writeToMigrationLog();
            }
        }
    }

    private void writeToMigrationLog() {
        this.createLogContent();
        this.writeFile(LOGFILE, this.log.toString(), true);
    }

    public void setFocus() {
        this.fPagebook.setFocus();
    }

    private Control createProjectsViewerControl(Composite parent) {
        this.fProjectsViewer = new TableViewer(parent, 2816);
        this.initializeProjectsViewer();
        this.fProjectsViewer.setInput((Object)this);
        return this.fProjectsViewer.getControl();
    }

    private void initializeProjectsViewer() {
        this.fProjectsViewer.getControl().setVisible(true);
        this.fProjectsViewer.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public Object[] getElements(Object inputElement) {
                Set<IProject> c = MigrationValidationResultsView.this.results.keySet();
                if (c.isEmpty()) {
                    MigrationValidationResultsView.this.fPagebook.showPage((Control)MigrationValidationResultsView.this.emptyViewer);
                }
                return c.toArray();
            }

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }
        });
        this.fProjectsViewer.setLabelProvider((IBaseLabelProvider)new ILabelProvider(){

            public void addListener(ILabelProviderListener listener) {
            }

            public void removeListener(ILabelProviderListener listener) {
            }

            public void dispose() {
            }

            public Image getImage(Object element) {
                Image image = null;
                if (element instanceof IProject) {
                    IMigrationResult result = MigrationValidationResultsView.this.results.get(element);
                    String name = null;
                    switch (result.getSeverity()) {
                        case 4: {
                            name = "IMG_OBJS_ERROR_TSK";
                            break;
                        }
                        case 2: {
                            name = "IMG_OBJS_WARN_TSK";
                            break;
                        }
                        default: {
                            return MigrationUIPlugin.getDefault().getImage("icons/migration_suc.gif");
                        }
                    }
                    image = PlatformUI.getWorkbench().getSharedImages().getImage(name);
                }
                return image;
            }

            public String getText(Object element) {
                if (element instanceof IProject) {
                    return ((IProject)element).getName();
                }
                return null;
            }

            public boolean isLabelProperty(Object element, String property) {
                return false;
            }
        });
        this.fProjectsViewer.addPostSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                MigrationValidationResultsView.this.doProjectSelectionChanged(event);
            }
        });
    }

    private Control createResultViewerControl(Composite parent) {
        this.fResultsViewer = new TextViewer(parent, 2818);
        this.fResultsViewer.setDocument((IDocument)new Document());
        StyledText styleText = this.fResultsViewer.getTextWidget();
        styleText.setEditable(false);
        Control control = this.fResultsViewer.getControl();
        return control;
    }

    public void createPartControl(Composite container) {
        this.fParent = container;
        this.addResizeListener(container);
        Color background = container.getDisplay().getSystemColor(25);
        this.fPagebook = new PageBook(container, 0);
        this.createEmptyViewer(this.fPagebook, background);
        this.fResultsSplitter = new SashForm((Composite)this.fPagebook, 512);
        this.fResultsSplitter.setVisible(false);
        this.fProjectsViewerViewForm = new ViewForm((Composite)this.fResultsSplitter, 0);
        Control projectsViewerControl = this.createProjectsViewerControl((Composite)this.fProjectsViewerViewForm);
        this.fProjectsViewerViewForm.setContent(projectsViewerControl);
        this.fResultViewerViewForm = new ViewForm((Composite)this.fResultsSplitter, 0);
        this.fResultsSplitter.setWeights(new int[]{20, 80});
        Control resultsViewerPart = this.createResultViewerControl((Composite)this.fResultViewerViewForm);
        this.fResultViewerViewForm.setContent(resultsViewerPart);
        this.createActions();
        this.initProjectsContextMenu();
        this.initResultsContextMenu();
        this.initToolBar();
        this.initPulldownMenu();
        this.fPagebook.showPage((Control)this.emptyViewer);
        this.computeOrientation();
    }

    private void createEmptyViewer(PageBook pageBook, Color background) {
        this.emptyViewer = new Composite((Composite)pageBook, 0);
        this.emptyViewer.setLayout((Layout)new GridLayout(1, false));
        this.emptyViewer.setBackground(background);
        Link migrationResultsLink = new Link(this.emptyViewer, 16576);
        migrationResultsLink.setText(com.ibm.etools.common.internal.migration.framework.ui.MigrationMessages.MigrationResultsView_no_migration_results_available);
        migrationResultsLink.setLayoutData((Object)new GridData(1, 0x1000000, true, false));
        migrationResultsLink.setBackground(background);
        migrationResultsLink.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ProgressMonitorDialog progressMonitorDialog = new ProgressMonitorDialog(null);
                try {
                    progressMonitorDialog.run(false, true, new IRunnableWithProgress(){

                        public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                            SubProgressMonitor subMonitor = new SubProgressMonitor(monitor, 1000);
                            try {
                                MigrationValidationResultsView.this.runWorkspaceValidation((IProgressMonitor)subMonitor);
                            }
                            finally {
                                subMonitor.done();
                            }
                        }
                    });
                }
                catch (InvocationTargetException e1) {
                    MigrationUIPlugin.logError(e1);
                }
                catch (InterruptedException e2) {
                    MigrationUIPlugin.logError(e2);
                }
            }
        });
    }

    private void initProjectsContextMenu() {
        MenuManager menuMgr = new MenuManager("#PopupMenu");
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                MigrationValidationResultsView.this.fillProjectsContextMenu(manager);
            }
        });
        Menu menu = menuMgr.createContextMenu(this.fProjectsViewer.getControl());
        this.fProjectsViewer.getControl().setMenu(menu);
    }

    private void initResultsContextMenu() {
        MenuManager menuMgr = new MenuManager("#PopupMenu");
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                MigrationValidationResultsView.this.fillResultsContextMenu(manager);
            }
        });
        Menu menu = menuMgr.createContextMenu(this.fResultsViewer.getControl());
        this.fResultsViewer.getControl().setMenu(menu);
    }

    private void fillProjectsContextMenu(IMenuManager manager) {
        manager.add((IAction)this.removeAction);
        manager.add((IAction)this.removeAllAction);
    }

    private void fillResultsContextMenu(IMenuManager manager) {
        int selectedTextCount = this.fResultsViewer.getTextWidget().getSelectionText().length();
        this.copyAction.setEnabled(selectedTextCount > 0);
        this.selectAllAction.setEnabled(selectedTextCount < this.fResultsViewer.getTextWidget().getText().length());
        manager.add((IAction)this.copyAction);
        manager.add((IAction)this.selectAllAction);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.runAction);
        manager.add((IAction)this.refreshAction);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.logAction);
        manager.add((IAction)this.openAction);
    }

    private void createActions() {
        this.createCopyAction();
        this.createSelectAllAction();
        this.createRemoveAction();
        this.createRemoveAllAction();
        this.createRunMigrationAction();
        this.createRunValidationAction();
        this.createExportLogAction();
        this.createRemoveOKAction();
        this.createRemoveErrorAction();
        this.createRemoveWarningAction();
        this.createOpenLogAction();
    }

    private void initToolBar() {
        IActionBars bars = this.getViewSite().getActionBars();
        IToolBarManager tm = bars.getToolBarManager();
        tm.add((IAction)this.runAction);
        tm.add((IAction)this.refreshAction);
        tm.add((IAction)this.removeAction);
        tm.add((IAction)this.removeAllAction);
        tm.add((IAction)this.logAction);
        tm.add((IAction)this.openAction);
    }

    private void initPulldownMenu() {
        IMenuManager menuMgr = this.getViewSite().getActionBars().getMenuManager();
        menuMgr.add((IAction)this.removeOKAction);
        menuMgr.add((IAction)this.removeWarningAction);
        menuMgr.add((IAction)this.removeErrorAction);
    }

    private void addResizeListener(Composite parent) {
        parent.addControlListener(new ControlListener(){

            public void controlMoved(ControlEvent e) {
            }

            public void controlResized(ControlEvent e) {
                MigrationValidationResultsView.this.computeOrientation();
            }
        });
    }

    void computeOrientation() {
        if (this.fInComputeOrientation) {
            return;
        }
        this.fInComputeOrientation = true;
        try {
            Point size = this.fParent.getSize();
            if (size.x != 0 && size.y != 0) {
                if (size.x > size.y) {
                    this.setOrientation(1);
                } else {
                    this.setOrientation(0);
                }
            }
        }
        finally {
            this.fInComputeOrientation = false;
        }
    }

    public void setOrientation(int orientation) {
        if (this.fResultViewerViewForm != null && !this.fResultViewerViewForm.isDisposed() && this.fResultsSplitter != null && !this.fResultsSplitter.isDisposed()) {
            this.fResultsSplitter.setOrientation(orientation == 1 ? 256 : 512);
            this.fResultsSplitter.layout();
        }
    }

    protected void doProjectSelectionChanged(SelectionChangedEvent e) {
        if (e.getSelection() != null && !e.getSelection().isEmpty()) {
            this.doProjectSelectionChanged(e.getSelection());
        }
    }

    protected void doProjectSelectionChanged(ISelection s) {
        if (s instanceof IStructuredSelection) {
            IStructuredSelection selection = (IStructuredSelection)s;
            Object sel = selection.getFirstElement();
            this.setInput(this.fResultsViewer, sel);
        }
    }

    public void clearResults() {
        this.results.clear();
        this.fProjectsViewer.setInput((Object)this);
        this.updateActionsEnabledState(false);
    }

    private void setInput(TextViewer resultsViewer, Object newValue) {
        if (this.oldValue != null && newValue != null && this.oldValue.equals(newValue)) {
            return;
        }
        this.oldValue = newValue;
        if (newValue != null && newValue instanceof IProject) {
            StyledText styledText = resultsViewer.getTextWidget();
            styledText.setText("");
            IMigrationResult result = this.results.get(newValue);
            for (IStatus status : result.getStatusReports()) {
                Color color = null;
                switch (status.getSeverity()) {
                    case 0: {
                        color = OK_COLOR;
                        break;
                    }
                    case 4: {
                        color = ERROR_COLOR;
                        break;
                    }
                    case 2: {
                        color = WARNING_COLOR;
                        break;
                    }
                    default: {
                        color = INFO_COLOR;
                    }
                }
                styledText.append(status.getMessage());
                int lineIndex = styledText.getLineCount() - 1;
                int lineLength = styledText.getLine(lineIndex).length();
                styledText.setStyleRange(new StyleRange(styledText.getOffsetAtLine(lineIndex), lineLength, color, null));
                styledText.append(lineSeparator);
            }
        }
    }

    private void createCopyAction() {
        this.clipboard = new Clipboard(Display.getCurrent());
        this.copyAction = new Action(com.ibm.etools.common.internal.migration.framework.ui.MigrationMessages.MigrationValidationResultsView_copy){

            public void run() {
                MigrationValidationResultsView.this.copyToClipboard();
            }
        };
        ISharedImages sharedImages = PlatformUI.getWorkbench().getSharedImages();
        ImageDescriptor id = sharedImages.getImageDescriptor("IMG_TOOL_COPY");
        if (id != null) {
            this.copyAction.setImageDescriptor(id);
        }
        if ((id = sharedImages.getImageDescriptor("IMG_TOOL_COPY_DISABLED")) != null) {
            this.copyAction.setDisabledImageDescriptor(id);
        }
    }

    private void createSelectAllAction() {
        this.selectAllAction = new Action(com.ibm.etools.common.internal.migration.framework.ui.MigrationMessages.MigrationValidationResultsView_select_all){

            public void run() {
                MigrationValidationResultsView.this.selectAllProjects();
            }
        };
    }

    private void createRemoveAllAction() {
        this.removeAllAction = new Action(com.ibm.etools.common.internal.migration.framework.ui.MigrationMessages.MigrationValidationResultsView_remove_all){

            public void run() {
                MigrationValidationResultsView.this.clearResults();
            }
        };
        this.removeAllAction.setEnabled(false);
        this.removeAllAction.setToolTipText(com.ibm.etools.common.internal.migration.framework.ui.MigrationMessages.MigrationValidationResultsView_remove_all);
        ImageDescriptor id = MigrationUIPlugin.getDefault().getImageDescriptor("icons/remall_ena.gif");
        if (id != null) {
            this.removeAllAction.setImageDescriptor(id);
        }
        if ((id = MigrationUIPlugin.getDefault().getImageDescriptor("icons/remall_dis.gif")) != null) {
            this.removeAllAction.setDisabledImageDescriptor(id);
        }
    }

    private void createRemoveAction() {
        this.removeAction = new Action(com.ibm.etools.common.internal.migration.framework.ui.MigrationMessages.MigrationValidationResultsView_remove_selected){

            public void run() {
                MigrationValidationResultsView.this.removeProject();
            }
        };
        this.removeAction.setEnabled(false);
        this.removeAction.setToolTipText(com.ibm.etools.common.internal.migration.framework.ui.MigrationMessages.MigrationValidationResultsView_remove_selected);
        ImageDescriptor id = MigrationUIPlugin.getDefault().getImageDescriptor("icons/remove_ena.gif");
        if (id != null) {
            this.removeAction.setImageDescriptor(id);
        }
        if ((id = MigrationUIPlugin.getDefault().getImageDescriptor("icons/remove_dis.gif")) != null) {
            this.removeAction.setDisabledImageDescriptor(id);
        }
    }

    private void createRunValidationAction() {
        this.refreshAction = new Action(com.ibm.etools.common.internal.migration.framework.ui.MigrationMessages.MigrationValidationResultsView_run_validate){

            public void run() {
                ProgressMonitorDialog progressMonitorDialog = new ProgressMonitorDialog(null);
                try {
                    progressMonitorDialog.run(false, true, new IRunnableWithProgress(){

                        public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                            SubProgressMonitor subMonitor = new SubProgressMonitor(monitor, 1000);
                            try {
                                MigrationValidationResultsView.this.runWorkspaceValidation((IProgressMonitor)subMonitor);
                            }
                            finally {
                                subMonitor.done();
                            }
                        }
                    });
                }
                catch (InvocationTargetException e) {
                    MigrationUIPlugin.logError(e);
                }
                catch (InterruptedException e1) {
                    MigrationUIPlugin.logError(e1);
                }
            }
        };
        this.refreshAction.setToolTipText(com.ibm.etools.common.internal.migration.framework.ui.MigrationMessages.MigrationValidationResultsView_run_validate);
        ImageDescriptor id = MigrationUIPlugin.getDefault().getImageDescriptor("icons/validate_refresh.gif");
        if (id != null) {
            this.refreshAction.setImageDescriptor(id);
        }
    }

    private void createRunMigrationAction() {
        this.runAction = new Action(com.ibm.etools.common.internal.migration.framework.ui.MigrationMessages.MigrationValidationResultsView_run_migration){

            public void run() {
                MigrationValidationResultsView.this.runWorkspaceMigration();
            }
        };
        this.runAction.setToolTipText(com.ibm.etools.common.internal.migration.framework.ui.MigrationMessages.MigrationValidationResultsView_run_migration);
        ImageDescriptor id = MigrationUIPlugin.getDefault().getImageDescriptor("icons/validate_run.gif");
        if (id != null) {
            this.runAction.setImageDescriptor(id);
        }
    }

    private void createRemoveWarningAction() {
        this.removeWarningAction = new Action(com.ibm.etools.common.internal.migration.framework.ui.MigrationMessages.MigrationValidationResultsView_warning_projects){

            public void run() {
                MigrationValidationResultsView.this.removeProjectBySeverity(2);
            }
        };
        this.removeWarningAction.setEnabled(false);
    }

    private void createRemoveErrorAction() {
        this.removeErrorAction = new Action(com.ibm.etools.common.internal.migration.framework.ui.MigrationMessages.MigrationValidationResultsView_error_projects){

            public void run() {
                MigrationValidationResultsView.this.removeProjectBySeverity(4);
            }
        };
        this.removeErrorAction.setEnabled(false);
    }

    private void createRemoveOKAction() {
        this.removeOKAction = new Action(com.ibm.etools.common.internal.migration.framework.ui.MigrationMessages.MigrationValidationResultsView_ok_projects){

            public void run() {
                MigrationValidationResultsView.this.removeProjectBySeverity(0);
            }
        };
        this.removeOKAction.setEnabled(false);
    }

    private void createExportLogAction() {
        this.logAction = new Action(com.ibm.etools.common.internal.migration.framework.ui.MigrationMessages.MigrationValidationResultsView_export_results){

            public void run() {
                MigrationValidationResultsView.this.handleExport();
            }
        };
        this.logAction.setEnabled(false);
        this.logAction.setToolTipText(com.ibm.etools.common.internal.migration.framework.ui.MigrationMessages.MigrationValidationResultsView_export_results);
        ImageDescriptor id = MigrationUIPlugin.getDefault().getImageDescriptor("icons/export_ena.gif");
        if (id != null) {
            this.logAction.setImageDescriptor(id);
        }
        if ((id = MigrationUIPlugin.getDefault().getImageDescriptor("icons/export_dis.gif")) != null) {
            this.logAction.setDisabledImageDescriptor(id);
        }
    }

    private void createOpenLogAction() {
        this.openAction = new Action(com.ibm.etools.common.internal.migration.framework.ui.MigrationMessages.MigrationValidationResultsView_open_migrationLog){

            public void run() {
                MigrationValidationResultsView.this.openMigrationLog();
            }
        };
        this.openAction.setEnabled(LOGFILE.exists());
        this.openAction.setToolTipText(com.ibm.etools.common.internal.migration.framework.ui.MigrationMessages.MigrationValidationResultsView_open_migrationLog);
        ImageDescriptor id = MigrationUIPlugin.getDefault().getImageDescriptor("icons/open_log_ena.gif");
        if (id != null) {
            this.openAction.setImageDescriptor(id);
        }
        if ((id = MigrationUIPlugin.getDefault().getImageDescriptor("icons/open_log_dis.gif")) != null) {
            this.openAction.setDisabledImageDescriptor(id);
        }
    }

    public void copyToClipboard() {
        String selection = this.fResultsViewer.getTextWidget().getSelectionText();
        if (selection.length() == 0) {
            return;
        }
        Object[] data = new Object[]{selection};
        Transfer[] transferTypes = new Transfer[]{TextTransfer.getInstance()};
        this.clipboard.setContents(data, transferTypes);
    }

    private void selectAllProjects() {
        this.fResultsViewer.getTextWidget().selectAll();
    }

    private void removeProject() {
        IStructuredSelection pSelection = (IStructuredSelection)this.fProjectsViewer.getSelection();
        Object sel = pSelection.getFirstElement();
        if (sel != null && sel instanceof IProject) {
            if (this.results.size() <= 1) {
                this.clearResults();
            } else {
                this.log = null;
                this.projects.clear();
                this.projects.addAll(this.results.keySet());
                int lastIndex = this.projects.size() - 1;
                int index = this.projects.indexOf(sel);
                this.results.remove(sel);
                this.fProjectsViewer.setInput((Object)this);
                if (index == lastIndex) {
                    this.fProjectsViewer.setSelection((ISelection)new StructuredSelection(this.fProjectsViewer.getElementAt(index - 1)), true);
                } else {
                    this.fProjectsViewer.setSelection((ISelection)new StructuredSelection(this.fProjectsViewer.getElementAt(index)), true);
                }
            }
        }
    }

    private void removeProjectBySeverity(int severity) {
        boolean didRemove = false;
        this.projects.clear();
        this.projects.addAll(this.results.keySet());
        for (IProject project : this.projects) {
            int projSeverity = this.results.get(project).getSeverity();
            if (severity != projSeverity) continue;
            if (this.results.size() <= 1) {
                this.clearResults();
                return;
            }
            this.results.remove(project);
            if (didRemove) continue;
            didRemove = true;
        }
        if (didRemove) {
            this.log = null;
            this.fProjectsViewer.setInput((Object)this);
            this.fProjectsViewer.setSelection((ISelection)new StructuredSelection(this.fProjectsViewer.getElementAt(0)), true);
        }
    }

    private void runWorkspaceValidation(IProgressMonitor subMonitor) {
        MigrationValidatorEngine migrationEngine = new MigrationValidatorEngine();
        migrationEngine.validateMigration(subMonitor, (IMigrationResultsListener)this);
    }

    private void runWorkspaceMigration() {
        WorkspaceMigrationEngine engine = WorkspaceMigrationEngine.instance();
        IProject[] allProjects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        if (allProjects.length > 0) {
            for (int i = 0; i < allProjects.length; ++i) {
                IProject project = allProjects[i];
                engine.addProject(project);
            }
        }
        if (engine.hasProjects()) {
            engine.setManualMigration(true);
            engine.begin(true);
        } else {
            MessageDialog.openInformation((Shell)this.getViewSite().getShell(), (String)com.ibm.etools.common.internal.migration.framework.ui.MigrationMessages.MigrationFrameworkWizard_title, (String)com.ibm.etools.common.internal.migration.framework.ui.MigrationMessages.MigrationResultsView_no_migration_needed_msg);
        }
    }

    private void handleExport() {
        FileDialog dialog = new FileDialog(this.getViewSite().getShell(), 8192);
        String path = dialog.open();
        if (path != null) {
            File outputFile = new Path(path).toFile();
            if (outputFile.exists()) {
                String message = NLS.bind((String)com.ibm.etools.common.internal.migration.framework.ui.MigrationMessages.MigrationValidationResultsView_confirmOverwrite, (Object)outputFile.toString());
                if (!MessageDialog.openQuestion((Shell)this.getViewSite().getShell(), (String)com.ibm.etools.common.internal.migration.framework.ui.MigrationMessages.MigrationValidationResultsView_export_results, (String)message)) {
                    return;
                }
            }
            this.createLogContent();
            this.writeFile(outputFile, this.log.toString(), false);
        }
    }

    private void openMigrationLog() {
        if (!LOGFILE.exists()) {
            return;
        }
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        IWorkbenchPage page = window.getActivePage();
        try {
            String editorId = IDE.getEditorDescriptor((String)LOGFILE.getAbsolutePath()).getId();
            IDE.openEditor((IWorkbenchPage)page, (URI)LOGFILE.toURI(), (String)editorId, (boolean)true);
        }
        catch (PartInitException e) {
            MigrationUIPlugin.logError((CoreException)e);
        }
    }

    private void createLogContent() {
        if (this.log == null) {
            this.log = new StringBuffer();
            for (IMigrationResult migResult : this.results.values()) {
                for (IStatus status : migResult.getStatusReports()) {
                    String linePrefix = "";
                    switch (status.getSeverity()) {
                        case 4: {
                            linePrefix = "ERROR  ";
                            break;
                        }
                        case 2: {
                            linePrefix = "WARNING";
                            break;
                        }
                        case 1: {
                            linePrefix = "INFO   ";
                            break;
                        }
                        default: {
                            linePrefix = "OK     ";
                        }
                    }
                    this.log.append(linePrefix);
                    this.log.append(status.getMessage());
                    this.log.append(lineSeparator);
                }
                this.log.append(lineSeparator);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeFile(File outputFile, String contents, boolean append) {
        BufferedWriter out = null;
        try {
            out = new BufferedWriter(new FileWriter(outputFile, append));
            out.newLine();
            out.write(contents);
            if (append) {
                out.write(MigrationMessages.MigrationFramework_MigrationComplete);
                out.newLine();
            }
            out.flush();
        }
        catch (IOException e) {
            MigrationUIPlugin.logError(e);
        }
        finally {
            try {
                if (out != null) {
                    out.close();
                }
            }
            catch (IOException e1) {
                MigrationUIPlugin.logError(e1);
            }
        }
    }

    private void updateActionsEnabledState(boolean isEnabled) {
        this.removeAllAction.setEnabled(isEnabled);
        this.removeAction.setEnabled(isEnabled);
        this.logAction.setEnabled(isEnabled);
        this.removeOKAction.setEnabled(isEnabled);
        this.removeWarningAction.setEnabled(isEnabled);
        this.removeErrorAction.setEnabled(isEnabled);
        this.openAction.setEnabled(LOGFILE.exists());
    }
}

