/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.common.internal.migration.ui;

import com.ibm.etools.common.internal.migration.framework.ui.MigrationMessages;
import com.ibm.etools.common.internal.migration.ui.plugin.MigrationUIPlugin;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.JFaceColors;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.Hyperlink;
import org.eclipse.ui.model.WorkbenchLabelProvider;

public class ListLegacyProjectsDialog
extends MessageDialog {
    private static final String DIALOG_SETTINGS_SECTION = "com.ibm.etools.migration.LegacyProjects";
    private static final String DIALOG_ORIGIN_X = "DIALOG_X_ORIGIN";
    private static final String DIALOG_ORIGIN_Y = "DIALOG_Y_ORIGIN";
    private static final String DIALOG_WIDTH = "DIALOG_WIDTH";
    private static final String DIALOG_HEIGHT = "DIALOG_HEIGHT";
    IProject[] listItems;
    Label dummyLabel;

    public ListLegacyProjectsDialog(Shell parent, String title, String msg, IProject[] items) {
        super(parent, title, null, msg, 1, new String[]{IDialogConstants.OK_LABEL}, 0);
        this.listItems = items;
    }

    protected Control createDialogArea(Composite parent) {
        this.createMessageArea(parent);
        this.createHyperLink(parent);
        Composite composite = this.createComposite(parent);
        this.createProjectTable(composite);
        return composite;
    }

    private Composite createComposite(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        composite.setLayout((Layout)layout);
        GridData data = new GridData(1808);
        data.horizontalSpan = 2;
        composite.setLayoutData((Object)data);
        return composite;
    }

    private void createHyperLink(Composite parent) {
        this.dummyLabel = new Label(parent, 0);
        Hyperlink documentationLink = new Hyperlink(parent, 0);
        documentationLink.setUnderlined(true);
        documentationLink.setForeground(JFaceColors.getActiveHyperlinkText((Display)parent.getDisplay()));
        documentationLink.setText(MigrationMessages.MigrationFrameworkHandler_hyperlink_text);
        documentationLink.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                ListLegacyProjectsDialog.this.performHelp();
            }
        });
    }

    public void performHelp() {
        String helpId = "/com.ibm.etools.rad.migration.doc/topics/c_migrate_unsupported.html";
        PlatformUI.getWorkbench().getHelpSystem().displayHelpResource(helpId);
    }

    private Control createProjectTable(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = this.convertVerticalDLUsToPixels(7);
        layout.marginWidth = this.convertHorizontalDLUsToPixels(7);
        layout.horizontalSpacing = this.convertHorizontalDLUsToPixels(4);
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(4, 4, true, true));
        Label projectsLabel = new Label(composite, 0);
        projectsLabel.setText(MigrationMessages.MigrationFrameworkHandler_legacy_projects_label);
        TableViewer projectsViewer = new TableViewer(composite, 2816);
        GridData data = new GridData(4, 4, true, true);
        data.widthHint = this.convertWidthInCharsToPixels(100);
        data.heightHint = this.convertHeightInCharsToPixels(10);
        projectsViewer.getControl().setLayoutData((Object)data);
        this.initializeProjectsViewer(projectsViewer);
        projectsViewer.setInput((Object)this.listItems);
        return composite;
    }

    private void initializeProjectsViewer(TableViewer projectsViewer) {
        projectsViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        projectsViewer.setLabelProvider((IBaseLabelProvider)new ILabelProvider(){

            public Image getImage(Object element) {
                WorkbenchLabelProvider pr = new WorkbenchLabelProvider();
                return pr.getImage(element);
            }

            public String getText(Object element) {
                return ((IProject)element).getName();
            }

            public void addListener(ILabelProviderListener listener) {
            }

            public void dispose() {
            }

            public boolean isLabelProperty(Object element, String property) {
                return false;
            }

            public void removeListener(ILabelProviderListener listener) {
            }
        });
    }

    public boolean close() {
        this.persistDialogSettings(this.getShell(), DIALOG_SETTINGS_SECTION);
        return super.close();
    }

    protected Point getInitialLocation(Point initialSize) {
        Point p = this.getInitialLocation(DIALOG_SETTINGS_SECTION);
        return p != null ? p : super.getInitialLocation(initialSize);
    }

    protected Point getInitialSize() {
        Point p = super.getInitialSize();
        return this.getInitialSize(DIALOG_SETTINGS_SECTION, p);
    }

    public Point getInitialLocation(String dialogSettingsSectionName) {
        IDialogSettings settings = this.getDialogSettings(dialogSettingsSectionName);
        try {
            int x = settings.getInt(DIALOG_ORIGIN_X);
            int y = settings.getInt(DIALOG_ORIGIN_Y);
            return new Point(x, y);
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
    }

    private IDialogSettings getDialogSettings(String dialogSettingsSectionName) {
        IDialogSettings settings = MigrationUIPlugin.getDefault().getDialogSettings();
        IDialogSettings section = settings.getSection(dialogSettingsSectionName);
        if (section == null) {
            section = settings.addNewSection(dialogSettingsSectionName);
        }
        return section;
    }

    private void persistDialogSettings(Shell shell, String dialogSettingsSectionName) {
        Point shellLocation = shell.getLocation();
        Point shellSize = shell.getSize();
        IDialogSettings settings = this.getDialogSettings(dialogSettingsSectionName);
        settings.put(DIALOG_ORIGIN_X, shellLocation.x);
        settings.put(DIALOG_ORIGIN_Y, shellLocation.y);
        settings.put(DIALOG_WIDTH, shellSize.x);
        settings.put(DIALOG_HEIGHT, shellSize.y);
    }

    private Point getInitialSize(String dialogSettingsSectionName, Point initialSize) {
        IDialogSettings settings = this.getDialogSettings(dialogSettingsSectionName);
        try {
            int x = settings.getInt(DIALOG_WIDTH);
            int y = settings.getInt(DIALOG_HEIGHT);
            return new Point(Math.max(x, initialSize.x), Math.max(y, initialSize.y));
        }
        catch (NumberFormatException numberFormatException) {
            return initialSize;
        }
    }

    protected boolean isResizable() {
        return true;
    }
}

