/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.common.internal.migration.framework.ui;

import com.ibm.etools.common.internal.migration.framework.IMigrationFrameworkDataModelProperties;
import com.ibm.etools.common.internal.migration.framework.MigrationFrameworkDataModelProvider;
import com.ibm.etools.common.internal.migration.framework.MigrationLog;
import com.ibm.etools.common.internal.migration.framework.ui.MigrationFrameworkProjectsWizardPage;
import com.ibm.etools.common.internal.migration.framework.ui.MigrationFrameworkResourcesWizardPage;
import com.ibm.etools.common.internal.migration.framework.ui.MigrationMessages;
import com.ibm.etools.common.internal.migration.plugin.MigrationPlugin;
import com.ibm.etools.common.internal.migration.ui.plugin.MigrationUIPlugin;
import org.eclipse.jface.dialogs.MessageDialogWithToggle;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.frameworks.datamodel.IDataModelProvider;
import org.eclipse.wst.common.frameworks.internal.datamodel.ui.AddablePageGroup;
import org.eclipse.wst.common.frameworks.internal.datamodel.ui.DataModelWizard;
import org.eclipse.wst.common.frameworks.internal.datamodel.ui.IDMPageGroup;
import org.eclipse.wst.common.frameworks.internal.datamodel.ui.IDMPageGroupHandler;
import org.eclipse.wst.common.frameworks.internal.datamodel.ui.SimplePageGroup;
import org.eclipse.wst.common.frameworks.internal.ui.PageGroupManager;

public class MigrationFrameworkWizard
extends DataModelWizard
implements IMigrationFrameworkDataModelProperties,
IDMPageGroupHandler {
    private static final String WIZARD_IMAGE = "icons/wizban/migration_wiz.gif";
    private static final String STARTUP_PAGE = "startupPage";
    private static final String FINISH_PAGE = "finishPage";
    private static final String MIGRATION_WIZARD_PROJECTS_GROUP = "migrationWizardProjectsGroup";
    private static final String MIGRATION_WIZARD_FINISH_GROUP = "migrationWizardFinishGroup";
    public static final String ROOT_GROUP_EXTENDER_ID = "migrationWizardStartupExtension";
    public static final String PROJECTS_GROUP_EXTENDER_ID = "migrationWizardProjectsExtension";
    private SimplePageGroup rootPageGroup;
    private boolean migratingWorkspaceMetadata = false;
    private static final String CANCEL_MIGRATION_KEY = "cancelmigrationkey";

    public MigrationFrameworkWizard(IDataModel dataModel) {
        super(dataModel);
        this.init();
    }

    protected void init() {
        this.setWindowTitle(MigrationMessages.MigrationFrameworkWizard_title);
        this.setDefaultPageImageDescriptor(MigrationUIPlugin.imageDescriptorFromPlugin((String)"com.ibm.etools.common.migration.ui", (String)WIZARD_IMAGE));
        this.setNeedsProgressMonitor(true);
        this.migratingWorkspaceMetadata = this.getDataModel().getBooleanProperty("IMigrationFrameworkDataModelProperties.NEEDS_METADATA_MIGRATION");
    }

    protected AddablePageGroup createRootPageGroup() {
        this.rootPageGroup = new SimplePageGroup(this.getDataModel().getID(), this.getDataModel().getID());
        this.rootPageGroup.addPage((IWizardPage)new MigrationFrameworkProjectsWizardPage(this.getDataModel(), STARTUP_PAGE));
        this.rootPageGroup.setPageGroupHandler((IDMPageGroupHandler)this);
        return this.rootPageGroup;
    }

    public void doAddPages() {
        PageGroupManager pageManager = this.getPageGroupManager();
        SimplePageGroup projectsGroup = new SimplePageGroup(MIGRATION_WIZARD_PROJECTS_GROUP, this.getDataModel().getID());
        pageManager.addGroupAfter(this.rootPageGroup.getPageGroupID(), (IDMPageGroup)projectsGroup);
        SimplePageGroup lastGroup = new SimplePageGroup(MIGRATION_WIZARD_FINISH_GROUP, this.getDataModel().getID());
        lastGroup.addPage((IWizardPage)new MigrationFrameworkResourcesWizardPage(this.getDataModel(), FINISH_PAGE));
        pageManager.addGroupAfter(this.rootPageGroup.getPageGroupID(), (IDMPageGroup)lastGroup);
        super.doAddPages();
    }

    public String getNextPageGroup(String currentPageGroupID, String[] pageGroupIDs) {
        if (pageGroupIDs == null || pageGroupIDs.length == 0) {
            return null;
        }
        String currentID = currentPageGroupID;
        String extenderID = null;
        if (!this.migratingWorkspaceMetadata && currentPageGroupID == null) {
            return MIGRATION_WIZARD_PROJECTS_GROUP;
        }
        if (currentPageGroupID == null || currentPageGroupID.endsWith(ROOT_GROUP_EXTENDER_ID)) {
            extenderID = ROOT_GROUP_EXTENDER_ID;
        } else if (currentPageGroupID.equals(MIGRATION_WIZARD_PROJECTS_GROUP)) {
            extenderID = PROJECTS_GROUP_EXTENDER_ID;
            currentID = null;
        } else if (currentPageGroupID.endsWith(PROJECTS_GROUP_EXTENDER_ID)) {
            extenderID = PROJECTS_GROUP_EXTENDER_ID;
        } else {
            if (currentPageGroupID.equals(MIGRATION_WIZARD_FINISH_GROUP)) {
                return null;
            }
            MigrationPlugin.logError((String)MigrationMessages.bind((String)MigrationMessages.MigrationFrameworkWizard_unknownPageGroup, (Object)currentPageGroupID));
            return null;
        }
        boolean currentFound = false;
        String nextID = null;
        for (int index = 0; index < pageGroupIDs.length; ++index) {
            nextID = pageGroupIDs[index];
            if (currentID == null && nextID.endsWith(extenderID)) break;
            if (nextID.equals(currentID)) {
                currentFound = true;
            } else if (currentFound && nextID.endsWith(extenderID)) break;
            nextID = null;
        }
        if (extenderID.equals(ROOT_GROUP_EXTENDER_ID) && nextID == null) {
            nextID = MIGRATION_WIZARD_PROJECTS_GROUP;
        }
        if (extenderID.equals(PROJECTS_GROUP_EXTENDER_ID) && nextID == null) {
            nextID = MIGRATION_WIZARD_FINISH_GROUP;
        }
        return nextID;
    }

    protected IDataModelProvider getDefaultProvider() {
        return new MigrationFrameworkDataModelProvider();
    }

    public boolean canFinish() {
        return this.getContainer().getCurrentPage().getName() == FINISH_PAGE && super.canFinish();
    }

    protected boolean runForked() {
        return false;
    }

    protected boolean isCancelable() {
        return true;
    }

    public boolean performCancel() {
        if (MigrationUIPlugin.getDefault().getPreferenceStore().getBoolean(CANCEL_MIGRATION_KEY)) {
            MigrationLog.getInstance().logMessage(MigrationMessages.MigrationFrameworkWizard_migrationCanceled);
            return super.performCancel();
        }
        MessageDialogWithToggle warningMessage = MessageDialogWithToggle.openOkCancelConfirm((Shell)this.getShell(), (String)MigrationMessages.MigrationFrameworkWizard_migrationCanceled, (String)MigrationMessages.MigrationFrameworkStartupWizardPage_skipMigration, (String)MigrationMessages.MigrationFrameworkWizard_migrationCancelToggleMessage, (boolean)false, null, null);
        MigrationUIPlugin.getDefault().getPreferenceStore().setValue(CANCEL_MIGRATION_KEY, warningMessage.getToggleState());
        MigrationUIPlugin.getDefault().savePluginPreferences();
        if (warningMessage.getReturnCode() == 0) {
            MigrationLog.getInstance().logMessage(MigrationMessages.MigrationFrameworkWizard_migrationCanceled);
            return super.performCancel();
        }
        return false;
    }
}

