/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.common.internal.migration.framework.ui;

import com.ibm.etools.common.internal.migration.framework.IMigrationFrameworkDataModelProperties;
import com.ibm.etools.common.internal.migration.framework.MigrationLog;
import com.ibm.etools.common.internal.migration.framework.WorkspaceMigrationEngine;
import com.ibm.etools.common.internal.migration.framework.ui.MigrationMessages;
import com.ibm.etools.common.internal.migration.plugin.MigrationPlugin;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.layout.PixelConverter;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.frameworks.internal.datamodel.ui.DataModelWizardPage;

public class MigrationFrameworkStartupWizardPage
extends DataModelWizardPage
implements IMigrationFrameworkDataModelProperties {
    private boolean firstVisit = true;

    public MigrationFrameworkStartupWizardPage(IDataModel dataModel, String pageName) {
        super(dataModel, pageName);
        this.setTitle(MigrationMessages.MigrationFrameworkWizard_title);
        this.setDescription(MigrationMessages.MigrationFrameworkStartupWizardPage_description);
    }

    protected Composite createTopLevelComposite(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(1, true));
        GridData data = new GridData(4, 128, true, false);
        Label label = new Label(composite, 64);
        PixelConverter converter = new PixelConverter((Control)label);
        data.widthHint = converter.convertWidthInCharsToPixels(40);
        data.heightHint = converter.convertHeightInCharsToPixels(6);
        label.setLayoutData((Object)data);
        label.setText(MigrationMessages.MigrationFrameworkStartupWizardPage_text);
        GridData data1 = new GridData(4, 128, true, false);
        Label skipMigration = new Label(composite, 64);
        PixelConverter convert = new PixelConverter((Control)skipMigration);
        data1.widthHint = convert.convertWidthInCharsToPixels(40);
        data1.heightHint = convert.convertHeightInCharsToPixels(6);
        skipMigration.setLayoutData((Object)data1);
        skipMigration.setText(MigrationMessages.MigrationFrameworkStartupWizardPage_skipMigration);
        MigrationLog.getInstance().createLogFile((IPath)this.getDataModel().getProperty("IMigrationFrameworkDataModelProperties.MIGRATION_LOG_DESTINATION"));
        return composite;
    }

    public void performHelp() {
        String helpId = "/com.ibm.etools.rad.migration.doc/topics/c_migrationoverview.html";
        PlatformUI.getWorkbench().getHelpSystem().displayHelpResource(helpId);
    }

    public void enter() {
        super.enter();
        if (this.firstVisit) {
            this.getProjectsToMigrate();
            this.firstVisit = false;
        }
    }

    protected void validatePage(boolean showMessage) {
        super.validatePage(false);
    }

    private void getProjectsToMigrate() {
        IRunnableWithProgress runnable = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) {
                List potentialProjects = (List)MigrationFrameworkStartupWizardPage.this.getDataModel().getProperty("IMigrationFrameworkDataModelProperties.POTENTIAL_MIGRATION_PROJECTS");
                List projectsToMigrate = WorkspaceMigrationEngine.instance().getProjectsToMigrate(potentialProjects, monitor);
                monitor.done();
                MigrationFrameworkStartupWizardPage.this.getDataModel().setProperty("IMigrationFrameworkDataModelProperties.MIGRATION_PROJECTS", (Object)projectsToMigrate);
                Set needsMigration = WorkspaceMigrationEngine.instance().getNonMigratedProjects();
                needsMigration.addAll(projectsToMigrate);
            }
        };
        try {
            ProgressMonitorDialog progress = new ProgressMonitorDialog(this.getShell());
            progress.run(false, true, runnable);
        }
        catch (InvocationTargetException e) {
            MigrationPlugin.logError((Throwable)e);
        }
        catch (InterruptedException e) {
            MigrationPlugin.logError((Throwable)e);
        }
    }

    protected String[] getValidationPropertyNames() {
        return new String[]{"IMigrationFrameworkDataModelProperties.MIGRATION_PROJECTS"};
    }
}

